/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors.es93;

import java.io.IOException;
import org.apache.lucene.codecs.hnsw.FlatVectorScorerUtil;
import org.apache.lucene.codecs.hnsw.FlatVectorsReader;
import org.apache.lucene.codecs.hnsw.FlatVectorsScorer;
import org.apache.lucene.codecs.hnsw.FlatVectorsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.elasticsearch.index.codec.vectors.AbstractFlatVectorsFormat;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryFlatVectorsScorer;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsReader;
import org.elasticsearch.index.codec.vectors.es818.ES818BinaryQuantizedVectorsWriter;
import org.elasticsearch.index.codec.vectors.es93.ES93GenericFlatVectorsFormat;

public class ES93BinaryQuantizedVectorsFormat
extends AbstractFlatVectorsFormat {
    public static final String NAME = "ES93BinaryQuantizedVectorsFormat";
    private static final ES818BinaryFlatVectorsScorer scorer = new ES818BinaryFlatVectorsScorer(FlatVectorScorerUtil.getLucene99FlatVectorsScorer());
    private final ES93GenericFlatVectorsFormat rawFormat;

    public ES93BinaryQuantizedVectorsFormat() {
        this(ES93GenericFlatVectorsFormat.ElementType.STANDARD, false);
    }

    public ES93BinaryQuantizedVectorsFormat(ES93GenericFlatVectorsFormat.ElementType elementType, boolean useDirectIO) {
        super(NAME);
        this.rawFormat = new ES93GenericFlatVectorsFormat(elementType, useDirectIO);
    }

    @Override
    public FlatVectorsScorer flatVectorsScorer() {
        return scorer;
    }

    public FlatVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return new ES818BinaryQuantizedVectorsWriter(scorer, this.rawFormat.fieldsWriter(state), state);
    }

    public FlatVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return new ES818BinaryQuantizedVectorsReader(state, this.rawFormat.fieldsReader(state), scorer);
    }

    @Override
    public String toString() {
        return this.getName() + "(name=" + this.getName() + ", rawVectorFormat=" + String.valueOf((Object)this.rawFormat) + ", scorer=" + String.valueOf(scorer) + ")";
    }
}

