/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.LeafScoreFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class WeightFactorFunction
extends ScoreFunction {
    private static final ScoreFunction SCORE_ONE = new ScoreOne();
    private final ScoreFunction scoreFunction;
    private final float weight;

    public WeightFactorFunction(float weight, ScoreFunction scoreFunction) {
        super(CombineFunction.MULTIPLY);
        this.scoreFunction = scoreFunction == null ? SCORE_ONE : scoreFunction;
        this.weight = weight;
    }

    public WeightFactorFunction(float weight) {
        super(CombineFunction.MULTIPLY);
        this.scoreFunction = SCORE_ONE;
        this.weight = weight;
    }

    @Override
    public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) throws IOException {
        final LeafScoreFunction leafFunction = this.scoreFunction.getLeafScoreFunction(ctx);
        return new LeafScoreFunction(){

            @Override
            public double score(int docId, float subQueryScore) throws IOException {
                return leafFunction.score(docId, subQueryScore) * (double)WeightFactorFunction.this.getWeight();
            }

            @Override
            public Explanation explainScore(int docId, Explanation subQueryScore) throws IOException {
                Explanation functionExplanation = leafFunction.explainScore(docId, subQueryScore);
                return Explanation.match((Number)Float.valueOf(functionExplanation.getValue().floatValue() * WeightFactorFunction.this.getWeight()), (String)"product of:", (Explanation[])new Explanation[]{functionExplanation, WeightFactorFunction.this.explainWeight()});
            }
        };
    }

    @Override
    public boolean needsScores() {
        return this.scoreFunction.needsScores();
    }

    public Explanation explainWeight() {
        return Explanation.match((Number)Float.valueOf(this.getWeight()), (String)"weight", (Explanation[])new Explanation[0]);
    }

    @Override
    public float getWeight() {
        return this.weight;
    }

    public ScoreFunction getScoreFunction() {
        return this.scoreFunction;
    }

    @Override
    protected boolean doEquals(ScoreFunction other) {
        WeightFactorFunction weightFactorFunction = (WeightFactorFunction)other;
        return this.weight == weightFactorFunction.weight && Objects.equals(this.scoreFunction, weightFactorFunction.scoreFunction);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(Float.valueOf(this.weight), this.scoreFunction);
    }

    private static class ScoreOne
    extends ScoreFunction {
        protected ScoreOne() {
            super(CombineFunction.MULTIPLY);
        }

        @Override
        public LeafScoreFunction getLeafScoreFunction(LeafReaderContext ctx) {
            return new LeafScoreFunction(this){

                @Override
                public double score(int docId, float subQueryScore) {
                    return 1.0;
                }

                @Override
                public Explanation explainScore(int docId, Explanation subQueryScore) {
                    return Explanation.match((Number)Float.valueOf(1.0f), (String)"constant score 1.0 - no function provided", (Explanation[])new Explanation[0]);
                }
            };
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        protected boolean doEquals(ScoreFunction other) {
            return true;
        }

        @Override
        protected int doHashCode() {
            return 0;
        }
    }
}

