/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.NodeUsageStatsForThreadPools;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardMovementWriteLoadSimulator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.WriteLoadConstraintSettings;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.FrequencyCappedAction;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.core.Strings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.shard.ShardId;

public class WriteLoadConstraintDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(WriteLoadConstraintDecider.class);
    public static final String NAME = "write_load";
    private final FrequencyCappedAction logInterventionMessage;
    private final WriteLoadConstraintSettings writeLoadConstraintSettings;

    public WriteLoadConstraintDecider(ClusterSettings clusterSettings) {
        this.writeLoadConstraintSettings = new WriteLoadConstraintSettings(clusterSettings);
        this.logInterventionMessage = new FrequencyCappedAction(System::currentTimeMillis, TimeValue.ZERO);
        clusterSettings.initializeAndWatch(WriteLoadConstraintSettings.WRITE_LOAD_DECIDER_MINIMUM_LOGGING_INTERVAL, this.logInterventionMessage::setMinInterval);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (this.writeLoadConstraintSettings.getWriteLoadConstraintEnabled().disabled()) {
            return Decision.single(Decision.Type.YES, NAME, "Decider is disabled", new Object[0]);
        }
        if (!shardRouting.assignedToNode()) {
            return Decision.single(Decision.Type.YES, NAME, "Shard is unassigned. Decider takes no action.", new Object[0]);
        }
        Map<ShardId, Double> allShardWriteLoads = allocation.clusterInfo().getShardWriteLoads();
        Double shardWriteLoad = allShardWriteLoads.get(shardRouting.shardId());
        if (shardWriteLoad == null || shardWriteLoad == 0.0) {
            return Decision.single(Decision.Type.YES, NAME, "Shard has no estimated write load. Decider takes no action.", new Object[0]);
        }
        Map<String, NodeUsageStatsForThreadPools> allNodeUsageStats = allocation.clusterInfo().getNodeUsageStatsForThreadPools();
        NodeUsageStatsForThreadPools nodeUsageStatsForThreadPools = allNodeUsageStats.get(node.nodeId());
        if (nodeUsageStatsForThreadPools == null) {
            return Decision.single(Decision.Type.YES, NAME, "The node has no write load estimate. Decider takes no action.", new Object[0]);
        }
        assert (!nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().isEmpty());
        assert (nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().get("write") != null);
        NodeUsageStatsForThreadPools.ThreadPoolUsageStats nodeWriteThreadPoolStats = nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().get("write");
        double nodeWriteThreadPoolLoadThreshold = this.writeLoadConstraintSettings.getHighUtilizationThreshold();
        if ((double)nodeWriteThreadPoolStats.averageThreadPoolUtilization() >= nodeWriteThreadPoolLoadThreshold) {
            String explain = Strings.format((String)"Node [%s] with write thread pool utilization [%.2f] already exceeds the high utilization threshold of [%f]. Cannot allocate shard [%s] to node without risking increased write latencies.", (Object[])new Object[]{node.nodeId(), Float.valueOf(nodeWriteThreadPoolStats.averageThreadPoolUtilization()), nodeWriteThreadPoolLoadThreshold, shardRouting.shardId()});
            if (logger.isDebugEnabled()) {
                this.logInterventionMessage.maybeExecute(() -> logger.debug(explain));
            }
            return Decision.single(Decision.Type.NOT_PREFERRED, NAME, explain, new Object[0]);
        }
        float newWriteThreadPoolUtilization = this.calculateShardMovementChange(nodeWriteThreadPoolStats, shardWriteLoad);
        if ((double)newWriteThreadPoolUtilization >= nodeWriteThreadPoolLoadThreshold) {
            String explain = Strings.format((String)"The high utilization threshold of [%f] would be exceeded on node [%s] with utilization [%.2f] if shard [%s] with estimated additional utilisation [%.5f] (write load [%.5f] / threads [%d]) were assigned to it. Cannot allocate shard to node without risking increased write latencies.", (Object[])new Object[]{nodeWriteThreadPoolLoadThreshold, node.nodeId(), Float.valueOf(nodeWriteThreadPoolStats.averageThreadPoolUtilization()), shardRouting.shardId(), shardWriteLoad / (double)nodeWriteThreadPoolStats.totalThreadPoolThreads(), shardWriteLoad, nodeWriteThreadPoolStats.totalThreadPoolThreads()});
            if (logger.isDebugEnabled()) {
                this.logInterventionMessage.maybeExecute(() -> logger.debug(explain));
            }
            return Decision.single(Decision.Type.NOT_PREFERRED, NAME, explain, new Object[0]);
        }
        String explanation = Strings.format((String)"Shard [%s] in index [%s] can be assigned to node [%s]. The node's utilization would become [%s]", (Object[])new Object[]{shardRouting.shardId(), shardRouting.index(), node.nodeId(), Float.valueOf(newWriteThreadPoolUtilization)});
        return allocation.decision(Decision.YES, NAME, explanation, new Object[0]);
    }

    @Override
    public Decision canRemain(IndexMetadata indexMetadata, ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (this.writeLoadConstraintSettings.getWriteLoadConstraintEnabled().notFullyEnabled()) {
            return Decision.single(Decision.Type.YES, NAME, "canRemain() is not enabled", new Object[0]);
        }
        Map<ShardId, Double> allShardWriteLoads = allocation.clusterInfo().getShardWriteLoads();
        Double shardWriteLoad = allShardWriteLoads.get(shardRouting.shardId());
        if (shardWriteLoad == null || shardWriteLoad == 0.0) {
            return Decision.single(Decision.Type.YES, NAME, "Shard has no estimated write load. Decider takes no action.", new Object[0]);
        }
        Map<String, NodeUsageStatsForThreadPools> allNodeUsageStats = allocation.clusterInfo().getNodeUsageStatsForThreadPools();
        NodeUsageStatsForThreadPools nodeUsageStatsForThreadPools = allNodeUsageStats.get(node.nodeId());
        if (nodeUsageStatsForThreadPools == null) {
            return Decision.single(Decision.Type.YES, NAME, "The node has no write load estimate. Decider takes no action.", new Object[0]);
        }
        assert (!nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().isEmpty());
        assert (nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().get("write") != null);
        NodeUsageStatsForThreadPools.ThreadPoolUsageStats nodeWriteThreadPoolStats = nodeUsageStatsForThreadPools.threadPoolUsageStatsMap().get("write");
        TimeValue nodeWriteThreadPoolQueueLatencyThreshold = this.writeLoadConstraintSettings.getQueueLatencyThreshold();
        if (nodeWriteThreadPoolStats.maxThreadPoolQueueLatencyMillis() >= nodeWriteThreadPoolQueueLatencyThreshold.millis()) {
            String explain = Strings.format((String)"Node [%s] has a queue latency of [%d] millis that exceeds the queue latency threshold of [%s]. This node is hot-spotting. Current thread pool utilization [%f]. Moving shard(s) away.", (Object[])new Object[]{node.nodeId(), nodeWriteThreadPoolStats.maxThreadPoolQueueLatencyMillis(), nodeWriteThreadPoolQueueLatencyThreshold.toHumanReadableString(2), Float.valueOf(nodeWriteThreadPoolStats.averageThreadPoolUtilization())});
            if (logger.isDebugEnabled()) {
                this.logInterventionMessage.maybeExecute(() -> logger.debug(explain));
            }
            return Decision.single(Decision.Type.NOT_PREFERRED, NAME, explain, new Object[0]);
        }
        String explanation = Strings.format((String)"Node [%s]'s queue latency of [%d] does not exceed the threshold of [%s]", (Object[])new Object[]{node.nodeId(), nodeWriteThreadPoolStats.maxThreadPoolQueueLatencyMillis(), nodeWriteThreadPoolQueueLatencyThreshold.toHumanReadableString(2)});
        return allocation.decision(Decision.YES, NAME, explanation, new Object[0]);
    }

    private float calculateShardMovementChange(NodeUsageStatsForThreadPools.ThreadPoolUsageStats nodeWriteThreadPoolStats, double shardWriteLoad) {
        assert (shardWriteLoad > 0.0);
        return ShardMovementWriteLoadSimulator.updateNodeUtilizationWithShardMovements(nodeWriteThreadPoolStats.averageThreadPoolUtilization(), (float)shardWriteLoad, nodeWriteThreadPoolStats.totalThreadPoolThreads());
    }
}

