/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import java.util.List;
import java.util.Objects;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.SingleNodeShutdownMetadata;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;

public class SnapshotInProgressAllocationDecider
extends AllocationDecider {
    public static final String NAME = "snapshot_in_progress";
    private static final Decision YES_NOT_RUNNING = Decision.single(Decision.Type.YES, "snapshot_in_progress", "no snapshots are currently running", new Object[0]);
    private static final Decision YES_NOT_SNAPSHOTTED = Decision.single(Decision.Type.YES, "snapshot_in_progress", "the shard is not being snapshotted", new Object[0]);

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        return SnapshotInProgressAllocationDecider.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return SnapshotInProgressAllocationDecider.canMove(shardRouting, allocation);
    }

    @Override
    public Decision canForceAllocateDuringReplace(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.canAllocate(shardRouting, node, allocation);
    }

    private static Decision canMove(ShardRouting shardRouting, RoutingAllocation allocation) {
        if (allocation.isSimulating()) {
            return allocation.decision(Decision.YES, NAME, "allocation is always enabled when simulating", new Object[0]);
        }
        if (!shardRouting.primary()) {
            return YES_NOT_SNAPSHOTTED;
        }
        SnapshotsInProgress snapshotsInProgress = SnapshotsInProgress.get(allocation.getClusterState());
        if (snapshotsInProgress.isEmpty()) {
            return YES_NOT_RUNNING;
        }
        if (shardRouting.currentNodeId() == null) {
            return YES_NOT_SNAPSHOTTED;
        }
        Iterable<List<SnapshotsInProgress.Entry>> entriesByRepoIterable = snapshotsInProgress.entriesByRepo();
        for (List<SnapshotsInProgress.Entry> entriesByRepo : entriesByRepoIterable) {
            for (SnapshotsInProgress.Entry entry : entriesByRepo) {
                SingleNodeShutdownMetadata nodeShutdown;
                SnapshotsInProgress.ShardSnapshotStatus shardSnapshotStatus;
                if (entry.isClone() || !entry.hasShardsInInitState() || (shardSnapshotStatus = entry.shards().get(shardRouting.shardId())) == null || shardSnapshotStatus.state().completed() || !Objects.equals(shardRouting.currentNodeId(), shardSnapshotStatus.nodeId()) || shardSnapshotStatus.state() == SnapshotsInProgress.ShardState.PAUSED_FOR_NODE_REMOVAL && (nodeShutdown = allocation.metadata().nodeShutdowns().get(shardRouting.currentNodeId())) != null && nodeShutdown.getType() != SingleNodeShutdownMetadata.Type.RESTART) continue;
                return allocation.decision(Decision.THROTTLE, NAME, "waiting for snapshot [%s] of shard [%s] to complete on node [%s]", entry.snapshot(), shardRouting.shardId(), shardRouting.currentNodeId());
            }
        }
        return YES_NOT_SNAPSHOTTED;
    }
}

