/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;

public class ConcurrentRebalanceAllocationDecider
extends AllocationDecider {
    private static final Logger logger = LogManager.getLogger(ConcurrentRebalanceAllocationDecider.class);
    public static final String NAME = "concurrent_rebalance";
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING = Setting.intSetting("cluster.routing.allocation.cluster_concurrent_rebalance", 2, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int clusterConcurrentRebalance;
    public static final Setting<Integer> CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_FROZEN_REBALANCE_SETTING = Setting.intSetting("cluster.routing.allocation.cluster_concurrent_frozen_rebalance", CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING, -1, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private volatile int clusterConcurrentFrozenRebalance;

    public ConcurrentRebalanceAllocationDecider(ClusterSettings clusterSettings) {
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING, this::setClusterConcurrentRebalance);
        clusterSettings.initializeAndWatch(CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_FROZEN_REBALANCE_SETTING, this::setClusterConcurrentFrozenRebalance);
        logger.debug("using [cluster_concurrent_rebalance] with [concurrent_rebalance={}, concurrent_frozen_rebalance={}]", (Object)this.clusterConcurrentRebalance, (Object)this.clusterConcurrentFrozenRebalance);
    }

    private void setClusterConcurrentRebalance(int concurrentRebalance) {
        this.clusterConcurrentRebalance = concurrentRebalance;
    }

    private void setClusterConcurrentFrozenRebalance(int concurrentFrozenRebalance) {
        this.clusterConcurrentFrozenRebalance = concurrentFrozenRebalance;
    }

    @Override
    public Decision canRebalance(ShardRouting shardRouting, RoutingAllocation allocation) {
        int relocatingFrozenShards = allocation.routingNodes().getRelocatingFrozenShardCount();
        if (allocation.routingNodes().isDedicatedFrozenNode(shardRouting.currentNodeId())) {
            if (this.clusterConcurrentFrozenRebalance == -1) {
                return allocation.decision(Decision.YES, NAME, "unlimited concurrent frozen rebalances are allowed", new Object[0]);
            }
            if (relocatingFrozenShards >= this.clusterConcurrentFrozenRebalance) {
                return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of concurrently rebalancing frozen shards [%d], cluster setting [%s=%d]", relocatingFrozenShards, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_FROZEN_REBALANCE_SETTING.getKey(), this.clusterConcurrentFrozenRebalance);
            }
            return allocation.decision(Decision.YES, NAME, "below threshold [%d] for concurrent frozen rebalances, current frozen rebalance shard count [%d]", this.clusterConcurrentFrozenRebalance, relocatingFrozenShards);
        }
        int relocatingShards = allocation.routingNodes().getRelocatingShardCount() - relocatingFrozenShards;
        if (this.clusterConcurrentRebalance == -1) {
            return allocation.decision(Decision.YES, NAME, "unlimited concurrent rebalances are allowed", new Object[0]);
        }
        if (relocatingShards >= this.clusterConcurrentRebalance) {
            return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of concurrently rebalancing shards [%d], cluster setting [%s=%d]", relocatingShards, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING.getKey(), this.clusterConcurrentRebalance);
        }
        return allocation.decision(Decision.YES, NAME, "below threshold [%d] for concurrent rebalances, current rebalance shard count [%d]", this.clusterConcurrentRebalance, relocatingShards);
    }

    @Override
    public Decision canRebalance(RoutingAllocation allocation) {
        int relocatingFrozenShards = allocation.routingNodes().getRelocatingFrozenShardCount();
        int relocatingShards = allocation.routingNodes().getRelocatingShardCount();
        if (allocation.isSimulating() && relocatingShards >= 2) {
            return allocation.decision(Decision.THROTTLE, NAME, "allocation should move one shard at the time when simulating", new Object[0]);
        }
        if (this.clusterConcurrentRebalance == -1 || (relocatingShards -= relocatingFrozenShards) < this.clusterConcurrentRebalance) {
            return allocation.decision(Decision.YES, NAME, "below threshold [%s=%d] for concurrent rebalances, current rebalance shard count [%d]", CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING.getKey(), this.clusterConcurrentRebalance, relocatingShards);
        }
        if (this.clusterConcurrentFrozenRebalance == -1 || relocatingFrozenShards < this.clusterConcurrentFrozenRebalance) {
            return allocation.decision(Decision.YES, NAME, "below threshold [%s=%d] for concurrent frozen rebalances, current frozen rebalance shard count [%d]", CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_FROZEN_REBALANCE_SETTING.getKey(), this.clusterConcurrentFrozenRebalance, relocatingFrozenShards);
        }
        return allocation.decision(Decision.THROTTLE, NAME, "reached the limit of concurrently rebalancing shards [%d] for concurrent rebalances, cluster setting [%s=%d], and [%d] for concurrent frozen rebalances, frozen cluster setting [%s=%d]", relocatingShards, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_REBALANCE_SETTING.getKey(), this.clusterConcurrentRebalance, relocatingFrozenShards, CLUSTER_ROUTING_ALLOCATION_CLUSTER_CONCURRENT_FROZEN_REBALANCE_SETTING.getKey(), this.clusterConcurrentFrozenRebalance);
    }
}

