/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;

public class RepositoryMetadata
implements Writeable {
    private final String name;
    private final String uuid;
    private final String type;
    private final Settings settings;
    private final long generation;
    private final long pendingGeneration;

    public RepositoryMetadata(String name, String type, Settings settings) {
        this(name, "_na_", type, settings);
    }

    public RepositoryMetadata(String name, String uuid, String type, Settings settings) {
        this(name, uuid, type, settings, -2L, -1L);
    }

    public RepositoryMetadata(RepositoryMetadata metadata, long generation, long pendingGeneration) {
        this(metadata.name, metadata.uuid, metadata.type, metadata.settings, generation, pendingGeneration);
    }

    public RepositoryMetadata(String name, String uuid, String type, Settings settings, long generation, long pendingGeneration) {
        this.name = name;
        this.uuid = uuid;
        this.type = type;
        this.settings = settings;
        this.generation = generation;
        this.pendingGeneration = pendingGeneration;
        assert (generation <= pendingGeneration) : "Pending generation [" + pendingGeneration + "] must be greater or equal to generation [" + generation + "]";
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String uuid() {
        return this.uuid;
    }

    public Settings settings() {
        return this.settings;
    }

    public long generation() {
        return this.generation;
    }

    public long pendingGeneration() {
        return this.pendingGeneration;
    }

    public RepositoryMetadata(StreamInput in) throws IOException {
        this.name = in.readString();
        this.uuid = in.readString();
        this.type = in.readString();
        this.settings = Settings.readSettingsFromStream(in);
        this.generation = in.readLong();
        this.pendingGeneration = in.readLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.uuid);
        out.writeString(this.type);
        this.settings.writeTo(out);
        out.writeLong(this.generation);
        out.writeLong(this.pendingGeneration);
    }

    public boolean equalsIgnoreGenerations(RepositoryMetadata other) {
        return this.name.equals(other.name) && this.uuid.equals(other.uuid()) && this.type.equals(other.type()) && this.settings.equals(other.settings());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RepositoryMetadata that = (RepositoryMetadata)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.uuid.equals(that.uuid)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.generation != that.generation) {
            return false;
        }
        if (this.pendingGeneration != that.pendingGeneration) {
            return false;
        }
        return this.settings.equals(that.settings);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uuid, this.type, this.settings, this.generation, this.pendingGeneration);
    }

    public String toString() {
        return "RepositoryMetadata{" + this.name + "}{" + this.uuid + "}{" + this.type + "}{" + String.valueOf(this.settings) + "}{" + this.generation + "}{" + this.pendingGeneration + "}";
    }

    public RepositoryMetadata withUuid(String uuid) {
        return new RepositoryMetadata(this.name, uuid, this.type, this.settings, this.generation, this.pendingGeneration);
    }

    public RepositoryMetadata withSettings(Settings settings) {
        return new RepositoryMetadata(this.name, this.uuid, this.type, settings, this.generation, this.pendingGeneration);
    }

    public RepositoryMetadata withGeneration(long generation, long pendingGeneration) {
        return new RepositoryMetadata(this.name, this.uuid, this.type, this.settings, generation, pendingGeneration);
    }
}

