/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.RealtimeRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.search.fetch.subphase.FetchSourceContext;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class MultiGetRequest
extends LegacyActionRequest
implements Iterable<Item>,
CompositeIndicesRequest,
RealtimeRequest,
ToXContentObject {
    private static final ParseField DOCS = new ParseField("docs", new String[0]);
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ROUTING = new ParseField("routing", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField VERSION_TYPE = new ParseField("version_type", new String[0]);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final ParseField STORED_FIELDS = new ParseField("stored_fields", new String[0]);
    private static final ParseField SOURCE = new ParseField("_source", new String[0]);
    String preference;
    boolean realtime = true;
    boolean refresh;
    List<Item> items = new ArrayList<Item>();
    private boolean forceSyntheticSource = false;

    public MultiGetRequest() {
    }

    public MultiGetRequest(StreamInput in) throws IOException {
        super(in);
        this.preference = in.readOptionalString();
        this.refresh = in.readBoolean();
        this.realtime = in.readBoolean();
        this.items = in.readCollectionAsList(Item::new);
        this.forceSyntheticSource = in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.preference);
        out.writeBoolean(this.refresh);
        out.writeBoolean(this.realtime);
        out.writeCollection(this.items);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
            out.writeBoolean(this.forceSyntheticSource);
        } else if (this.forceSyntheticSource) {
            throw new IllegalArgumentException("force_synthetic_source is not supported before 8.4.0");
        }
    }

    public List<Item> getItems() {
        return this.items;
    }

    public MultiGetRequest add(Item item) {
        this.items.add(item);
        return this;
    }

    public MultiGetRequest add(String index, String id) {
        this.items.add(new Item(index, id));
        return this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.items.isEmpty()) {
            validationException = ValidateActions.addValidationError("no documents to get", validationException);
        } else {
            for (int i = 0; i < this.items.size(); ++i) {
                Item item = this.items.get(i);
                if (item.index() == null) {
                    validationException = ValidateActions.addValidationError("index is missing for doc " + i, validationException);
                }
                if (item.id() != null) continue;
                validationException = ValidateActions.addValidationError("id is missing for doc " + i, validationException);
            }
        }
        return validationException;
    }

    public MultiGetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public boolean realtime() {
        return this.realtime;
    }

    public MultiGetRequest realtime(boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public MultiGetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public MultiGetRequest setForceSyntheticSource(boolean forceSyntheticSource) {
        this.forceSyntheticSource = forceSyntheticSource;
        return this;
    }

    public boolean isForceSyntheticSource() {
        return this.forceSyntheticSource;
    }

    public MultiGetRequest add(@Nullable String defaultIndex, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting, XContentParser parser, boolean allowExplicitIndex) throws IOException {
        String currentFieldName = null;
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            String message = String.format(Locale.ROOT, "unexpected token [%s], expected [%s]", token, XContentParser.Token.START_OBJECT);
            throw new ParsingException(parser.getTokenLocation(), message, new Object[0]);
        }
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                if ("docs".equals(currentFieldName)) {
                    MultiGetRequest.parseDocuments(parser, this.items, defaultIndex, defaultFields, defaultFetchSource, defaultRouting, allowExplicitIndex);
                    continue;
                }
                if ("ids".equals(currentFieldName)) {
                    MultiGetRequest.parseIds(parser, this.items, defaultIndex, defaultFields, defaultFetchSource, defaultRouting);
                    continue;
                }
                String message = String.format(Locale.ROOT, "unknown key [%s] for a %s, expected [docs] or [ids]", currentFieldName, token);
                throw new ParsingException(parser.getTokenLocation(), message, new Object[0]);
            }
            String message = String.format(Locale.ROOT, "unexpected token [%s], expected [%s] or [%s]", token, XContentParser.Token.FIELD_NAME, XContentParser.Token.START_ARRAY);
            throw new ParsingException(parser.getTokenLocation(), message, new Object[0]);
        }
        return this;
    }

    private static void parseDocuments(XContentParser parser, List<Item> items, @Nullable String defaultIndex, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting, boolean allowExplicitIndex) throws IOException {
        XContentParser.Token token;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (token != XContentParser.Token.START_OBJECT) {
                throw new IllegalArgumentException("docs array element should include an object");
            }
            String index = defaultIndex;
            String id = null;
            String routing = defaultRouting;
            ArrayList<String> storedFields = null;
            long version = -3L;
            VersionType versionType = VersionType.INTERNAL;
            FetchSourceContext fetchSourceContext = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token.isValue()) {
                    if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                        if (!allowExplicitIndex) {
                            throw new IllegalArgumentException("explicit index in multi get is not allowed");
                        }
                        index = parser.text();
                        continue;
                    }
                    if (ID.match(currentFieldName, parser.getDeprecationHandler())) {
                        id = parser.text();
                        continue;
                    }
                    if (ROUTING.match(currentFieldName, parser.getDeprecationHandler())) {
                        routing = parser.text();
                        continue;
                    }
                    if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new ParsingException(parser.getTokenLocation(), "Unsupported field [fields] used, expected [stored_fields] instead", new Object[0]);
                    }
                    if (STORED_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                        storedFields = new ArrayList();
                        storedFields.add(parser.text());
                        continue;
                    }
                    if (VERSION.match(currentFieldName, parser.getDeprecationHandler())) {
                        version = parser.longValue();
                        continue;
                    }
                    if (VERSION_TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                        versionType = VersionType.fromString(parser.text());
                        continue;
                    }
                    if (SOURCE.match(currentFieldName, parser.getDeprecationHandler())) {
                        if (parser.isBooleanValue()) {
                            fetchSourceContext = fetchSourceContext == null ? FetchSourceContext.of(parser.booleanValue()) : FetchSourceContext.of(parser.booleanValue(), fetchSourceContext.includes(), fetchSourceContext.excludes());
                            continue;
                        }
                        if (token == XContentParser.Token.VALUE_STRING) {
                            fetchSourceContext = FetchSourceContext.of(fetchSourceContext == null || fetchSourceContext.fetchSource(), new String[]{parser.text()}, fetchSourceContext == null ? Strings.EMPTY_ARRAY : fetchSourceContext.excludes());
                            continue;
                        }
                        throw new ElasticsearchParseException("illegal type for _source: [{}]", token);
                    }
                    throw new ElasticsearchParseException("failed to parse multi get request. unknown field [{}]", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if (FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new ParsingException(parser.getTokenLocation(), "Unsupported field [fields] used, expected [stored_fields] instead", new Object[0]);
                    }
                    if (STORED_FIELDS.match(currentFieldName, parser.getDeprecationHandler())) {
                        storedFields = new ArrayList<String>();
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            storedFields.add(parser.text());
                        }
                        continue;
                    }
                    if (!SOURCE.match(currentFieldName, parser.getDeprecationHandler())) continue;
                    ArrayList<String> includes = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        includes.add(parser.text());
                    }
                    fetchSourceContext = FetchSourceContext.of(fetchSourceContext == null || fetchSourceContext.fetchSource(), includes.toArray(Strings.EMPTY_ARRAY), fetchSourceContext == null ? Strings.EMPTY_ARRAY : fetchSourceContext.excludes());
                    continue;
                }
                if (token != XContentParser.Token.START_OBJECT || !SOURCE.match(currentFieldName, parser.getDeprecationHandler())) continue;
                List currentList = null;
                ArrayList includes = null;
                ArrayList excludes = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        if ("includes".equals(currentFieldName) || "include".equals(currentFieldName)) {
                            currentList = includes != null ? includes : new ArrayList(2);
                            continue;
                        }
                        if ("excludes".equals(currentFieldName) || "exclude".equals(currentFieldName)) {
                            currentList = excludes != null ? excludes : new ArrayList(2);
                            continue;
                        }
                        throw new ElasticsearchParseException("source definition may not contain [{}]", parser.text());
                    }
                    if (token == XContentParser.Token.START_ARRAY) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            currentList.add(parser.text());
                        }
                        continue;
                    }
                    if (token.isValue()) {
                        currentList.add(parser.text());
                        continue;
                    }
                    throw new ElasticsearchParseException("unexpected token while parsing source settings", new Object[0]);
                }
                fetchSourceContext = FetchSourceContext.of(fetchSourceContext == null || fetchSourceContext.fetchSource(), includes == null ? Strings.EMPTY_ARRAY : includes.toArray(Strings.EMPTY_ARRAY), excludes == null ? Strings.EMPTY_ARRAY : excludes.toArray(Strings.EMPTY_ARRAY));
            }
            String[] aFields = storedFields != null ? storedFields.toArray(Strings.EMPTY_ARRAY) : defaultFields;
            items.add(new Item(index, id).routing(routing).storedFields(aFields).version(version).versionType(versionType).fetchSourceContext(fetchSourceContext == null ? defaultFetchSource : fetchSourceContext));
        }
    }

    public static void parseIds(XContentParser parser, List<Item> items, @Nullable String defaultIndex, @Nullable String[] defaultFields, @Nullable FetchSourceContext defaultFetchSource, @Nullable String defaultRouting) throws IOException {
        XContentParser.Token token;
        while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
            if (!token.isValue()) {
                throw new IllegalArgumentException("ids array element should only contain ids");
            }
            items.add(new Item(defaultIndex, parser.text()).storedFields(defaultFields).fetchSourceContext(defaultFetchSource).routing(defaultRouting));
        }
    }

    @Override
    public Iterator<Item> iterator() {
        return Collections.unmodifiableCollection(this.items).iterator();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(DOCS.getPreferredName());
        for (Item item : this.items) {
            builder.value((ToXContent)item);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static class Item
    implements Writeable,
    IndicesRequest,
    ToXContentObject {
        private String index;
        private String id;
        private String routing;
        private String[] storedFields;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;
        private FetchSourceContext fetchSourceContext;

        public Item() {
        }

        public Item(StreamInput in) throws IOException {
            this.index = in.readString();
            if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                in.readOptionalString();
            }
            this.id = in.readString();
            this.routing = in.readOptionalString();
            this.storedFields = in.readOptionalStringArray();
            this.version = in.readLong();
            this.versionType = VersionType.fromValue(in.readByte());
            this.fetchSourceContext = in.readOptionalWriteable(FetchSourceContext::readFrom);
        }

        public Item(String index, String id) {
            this.index = index;
            this.id = id;
        }

        public String index() {
            return this.index;
        }

        @Override
        public String[] indices() {
            return new String[]{this.index};
        }

        @Override
        public IndicesOptions indicesOptions() {
            return GetRequest.INDICES_OPTIONS;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item storedFields(String ... fields) {
            this.storedFields = fields;
            return this;
        }

        public String[] storedFields() {
            return this.storedFields;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public FetchSourceContext fetchSourceContext() {
            return this.fetchSourceContext;
        }

        public Item fetchSourceContext(FetchSourceContext fetchSourceContext) {
            this.fetchSourceContext = fetchSourceContext;
            return this;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
                out.writeOptionalString("_doc");
            }
            out.writeString(this.id);
            out.writeOptionalString(this.routing);
            out.writeOptionalStringArray(this.storedFields);
            out.writeLong(this.version);
            out.writeByte(this.versionType.getValue());
            out.writeOptionalWriteable(this.fetchSourceContext);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX.getPreferredName(), this.index);
            builder.field(ID.getPreferredName(), this.id);
            builder.field(ROUTING.getPreferredName(), this.routing);
            builder.array(STORED_FIELDS.getPreferredName(), this.storedFields);
            builder.field(VERSION.getPreferredName(), this.version);
            builder.field(VERSION_TYPE.getPreferredName(), VersionType.toString(this.versionType));
            builder.field(SOURCE.getPreferredName(), (ToXContent)this.fetchSourceContext);
            builder.endObject();
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item item = (Item)o;
            if (this.version != item.version) {
                return false;
            }
            if (this.fetchSourceContext != null ? !this.fetchSourceContext.equals(item.fetchSourceContext) : item.fetchSourceContext != null) {
                return false;
            }
            if (!Arrays.equals(this.storedFields, item.storedFields)) {
                return false;
            }
            if (!this.id.equals(item.id)) {
                return false;
            }
            if (!this.index.equals(item.index)) {
                return false;
            }
            if (this.routing != null ? !this.routing.equals(item.routing) : item.routing != null) {
                return false;
            }
            return this.versionType == item.versionType;
        }

        public int hashCode() {
            int result = this.index.hashCode();
            result = 31 * result + this.id.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + (this.storedFields != null ? Arrays.hashCode(this.storedFields) : 0);
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.versionType.hashCode();
            result = 31 * result + (this.fetchSourceContext != null ? this.fetchSourceContext.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }
    }
}

