/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.downsample;

import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class DownsampleConfig
implements NamedWriteable,
ToXContentObject {
    public static final TransportVersion ADD_LAST_VALUE_DOWNSAMPLE_API = TransportVersion.fromName("add_last_value_downsample_api");
    private static final String NAME = "downsample/action/config";
    public static final String FIXED_INTERVAL = "fixed_interval";
    public static final String SAMPLING_METHOD = "sampling_method";
    public static final String TIME_ZONE = "time_zone";
    public static final String DEFAULT_TIMEZONE = ZoneId.of("UTC").getId();
    private static final String timestampField = "@timestamp";
    private final DateHistogramInterval fixedInterval;
    private final String timeZone = DEFAULT_TIMEZONE;
    private final String intervalType = "fixed_interval";
    @Nullable
    private final SamplingMethod samplingMethod;
    private static final ConstructingObjectParser<DownsampleConfig, Void> PARSER = new ConstructingObjectParser("downsample/action/config", a -> {
        DateHistogramInterval fixedInterval = (DateHistogramInterval)a[0];
        if (fixedInterval != null) {
            return new DownsampleConfig(fixedInterval, (SamplingMethod)a[1]);
        }
        throw new IllegalArgumentException("Parameter [fixed_interval] is required.");
    });

    @Deprecated
    public DownsampleConfig(DateHistogramInterval fixedInterval) {
        this(fixedInterval, null);
    }

    public DownsampleConfig(DateHistogramInterval fixedInterval, @Nullable SamplingMethod samplingMethod) {
        if (fixedInterval == null) {
            throw new IllegalArgumentException("Parameter [fixed_interval] is required.");
        }
        this.fixedInterval = fixedInterval;
        this.samplingMethod = samplingMethod;
        DownsampleConfig.createRounding(this.fixedInterval.toString(), this.timeZone);
    }

    public DownsampleConfig(StreamInput in) throws IOException {
        this.fixedInterval = new DateHistogramInterval(in);
        this.samplingMethod = in.getTransportVersion().supports(ADD_LAST_VALUE_DOWNSAMPLE_API) ? in.readOptionalWriteable(SamplingMethod::read) : null;
    }

    public static void validateSourceAndTargetIntervals(DownsampleConfig source, DownsampleConfig target) {
        long targetMillis;
        long sourceMillis = source.fixedInterval.estimateMillis();
        if (sourceMillis >= (targetMillis = target.fixedInterval.estimateMillis())) {
            throw new IllegalArgumentException("Downsampling interval [" + String.valueOf(target.fixedInterval) + "] must be greater than the source index interval [" + String.valueOf(source.fixedInterval) + "].");
        }
        if (targetMillis % sourceMillis != 0L) {
            throw new IllegalArgumentException("Downsampling interval [" + String.valueOf(target.fixedInterval) + "] must be a multiple of the source index interval [" + String.valueOf(source.fixedInterval) + "].");
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.fixedInterval.writeTo(out);
        if (out.getTransportVersion().supports(ADD_LAST_VALUE_DOWNSAMPLE_API)) {
            out.writeOptionalWriteable(this.samplingMethod);
        }
    }

    public String getTimestampField() {
        return timestampField;
    }

    public String getIntervalType() {
        return FIXED_INTERVAL;
    }

    public DateHistogramInterval getInterval() {
        return this.getFixedInterval();
    }

    public DateHistogramInterval getFixedInterval() {
        return this.fixedInterval;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Rounding.Prepared createRounding() {
        return DownsampleConfig.createRounding(this.fixedInterval.toString(), this.timeZone);
    }

    @Nullable
    public SamplingMethod getSamplingMethod() {
        return this.samplingMethod;
    }

    public SamplingMethod getSamplingMethodOrDefault() {
        return SamplingMethod.getOrDefault(this.samplingMethod);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        return builder.endObject();
    }

    public XContentBuilder toXContentFragment(XContentBuilder builder) throws IOException {
        builder.field(FIXED_INTERVAL, this.fixedInterval.toString());
        if (this.samplingMethod != null) {
            builder.field(SAMPLING_METHOD, this.samplingMethod.label);
        }
        return builder;
    }

    public static DownsampleConfig fromXContent(XContentParser parser) throws IOException {
        return (DownsampleConfig)PARSER.parse(parser, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DownsampleConfig)) {
            return false;
        }
        DownsampleConfig that = (DownsampleConfig)other;
        return Objects.equals(this.fixedInterval, that.fixedInterval) && Objects.equals(FIXED_INTERVAL, that.intervalType) && ZoneId.of(this.timeZone, ZoneId.SHORT_IDS).getRules().equals(ZoneId.of(that.timeZone, ZoneId.SHORT_IDS).getRules()) && Objects.equals(this.samplingMethod, that.samplingMethod);
    }

    public int hashCode() {
        return Objects.hash(this.fixedInterval, FIXED_INTERVAL, ZoneId.of(this.timeZone), this.samplingMethod);
    }

    public String toString() {
        return Strings.toString((ToXContent)this, true, true);
    }

    public static Rounding.Prepared createRounding(String expr, String timeZone) {
        Rounding.DateTimeUnit timeUnit = DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(expr);
        Rounding.Builder rounding = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue((String)expr, (String)"createRounding"));
        rounding.timeZone(ZoneId.of(timeZone, ZoneId.SHORT_IDS));
        return rounding.build().prepareForUnknown();
    }

    public static String generateDownsampleIndexName(String prefix, IndexMetadata sourceIndexMetadata, DateHistogramInterval fixedInterval) {
        String downsampleOriginName = IndexMetadata.INDEX_DOWNSAMPLE_ORIGIN_NAME.get(sourceIndexMetadata.getSettings());
        String sourceIndexName = Strings.hasText(downsampleOriginName) ? downsampleOriginName : (Strings.hasText(IndexMetadata.INDEX_DOWNSAMPLE_SOURCE_NAME.get(sourceIndexMetadata.getSettings())) ? IndexMetadata.INDEX_DOWNSAMPLE_SOURCE_NAME.get(sourceIndexMetadata.getSettings()) : sourceIndexMetadata.getIndex().getName());
        return prefix + String.valueOf(fixedInterval) + "-" + sourceIndexName;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> SamplingMethod.fromString(p.text()), new ParseField(SAMPLING_METHOD, new String[0]), ObjectParser.ValueType.STRING);
    }

    public static enum SamplingMethod implements Writeable
    {
        AGGREGATE(0, "aggregate"),
        LAST_VALUE(1, "last_value");

        private final byte id;
        private final String label;

        private SamplingMethod(byte id, String label) {
            this.id = id;
            this.label = label;
        }

        byte id() {
            return this.id;
        }

        public static SamplingMethod read(StreamInput in) throws IOException {
            byte id = in.readByte();
            return switch (id) {
                case 0 -> AGGREGATE;
                case 1 -> LAST_VALUE;
                default -> throw new IllegalArgumentException("Sampling method id [" + id + "] is not one of the accepted ids " + String.valueOf(Arrays.stream(SamplingMethod.values()).map(SamplingMethod::id).toList()) + ".");
            };
        }

        @Nullable
        public static SamplingMethod fromString(@Nullable String label) {
            if (label == null) {
                return null;
            }
            return switch (label.toLowerCase(Locale.ROOT)) {
                case "aggregate" -> AGGREGATE;
                case "last_value" -> LAST_VALUE;
                default -> throw new IllegalArgumentException("Sampling method [" + label + "] is not one of the accepted methods " + String.valueOf(Arrays.stream(SamplingMethod.values()).map(SamplingMethod::toString).toList()) + ".");
            };
        }

        @Nullable
        public static SamplingMethod fromIndexMetadata(IndexMetadata indexMetadata) {
            SamplingMethod method = SamplingMethod.fromString(indexMetadata.getSettings().get("index.downsample.sampling_method"));
            if (method != null) {
                return method;
            }
            boolean isIndexDownsampled = indexMetadata.getSettings().get("index.downsample.interval") != null;
            return isIndexDownsampled ? AGGREGATE : null;
        }

        public static SamplingMethod getOrDefault(@Nullable SamplingMethod samplingMethod) {
            return samplingMethod == null ? AGGREGATE : samplingMethod;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeByte(this.id);
        }

        public String toString() {
            return this.label;
        }
    }
}

