/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.mapping.put;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.TransportPutMappingAction;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataMappingService;
import org.elasticsearch.cluster.project.ProjectResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndices;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportAutoPutMappingAction
extends AcknowledgedTransportMasterNodeAction<PutMappingRequest> {
    public static final ActionType<AcknowledgedResponse> TYPE = new ActionType("indices:admin/mapping/auto_put");
    private static final Logger logger = LogManager.getLogger(TransportAutoPutMappingAction.class);
    private final MetadataMappingService metadataMappingService;
    private final ProjectResolver projectResolver;
    private final SystemIndices systemIndices;

    @Inject
    public TransportAutoPutMappingAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataMappingService metadataMappingService, ActionFilters actionFilters, ProjectResolver projectResolver, SystemIndices systemIndices) {
        super(TYPE.name(), transportService, clusterService, threadPool, actionFilters, PutMappingRequest::new, EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.metadataMappingService = metadataMappingService;
        this.projectResolver = projectResolver;
        this.systemIndices = systemIndices;
    }

    @Override
    protected void doExecute(Task task, PutMappingRequest request, ActionListener<AcknowledgedResponse> listener) {
        if (request.getConcreteIndex() == null) {
            throw new IllegalArgumentException("concrete index missing");
        }
        super.doExecute(task, request, listener);
    }

    @Override
    protected ClusterBlockException checkBlock(PutMappingRequest request, ClusterState state) {
        String[] indices = new String[]{request.getConcreteIndex().getName()};
        return state.blocks().indicesBlockedException(this.projectResolver.getProjectId(), ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(Task task, PutMappingRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        Index[] concreteIndices = new Index[]{request.getConcreteIndex()};
        String message = TransportPutMappingAction.checkForSystemIndexViolations(this.systemIndices, concreteIndices, request);
        if (message != null) {
            logger.warn(message);
            listener.onFailure(new IllegalStateException(message));
            return;
        }
        TransportPutMappingAction.performMappingUpdate(concreteIndices, request, listener, this.metadataMappingService, true);
    }
}

