/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.ComponentTemplate;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.metadata.Template;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xpack.core.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.DeprecationInfoAction;
import org.elasticsearch.xpack.deprecation.LegacyTiersDetection;
import org.elasticsearch.xpack.deprecation.ResourceDeprecationChecker;
import org.elasticsearch.xpack.deprecation.TransportDeprecationInfoAction;

public class TemplateDeprecationChecker
implements ResourceDeprecationChecker {
    public static final String NAME = "templates";
    private final List<Function<ComposableIndexTemplate, DeprecationIssue>> indexTemplateChecks = List.of(this::checkLegacyTiersInIndexTemplate);
    private final List<Function<ComponentTemplate, DeprecationIssue>> componentTemplateChecks = List.of(this::checkSourceModeInComponentTemplates, this::checkLegacyTiersInComponentTemplates);

    @Override
    public Map<String, List<DeprecationIssue>> check(ProjectMetadata project, DeprecationInfoAction.Request request, TransportDeprecationInfoAction.PrecomputedData precomputedData) {
        return this.check(project);
    }

    Map<String, List<DeprecationIssue>> check(ProjectMetadata project) {
        List<DeprecationIssue> issuesForSingleIndexTemplate;
        ComposableIndexTemplate template;
        String name;
        Set indexTemplates = project.templatesV2().entrySet();
        Set componentTemplates = project.componentTemplates().entrySet();
        if (indexTemplates.isEmpty() && componentTemplates.isEmpty()) {
            return Map.of();
        }
        HashMap<String, List> issues = new HashMap<String, List>();
        for (Map.Entry entry : indexTemplates) {
            name = (String)entry.getKey();
            template = (ComposableIndexTemplate)entry.getValue();
            issuesForSingleIndexTemplate = this.indexTemplateChecks.stream().map(c -> (DeprecationIssue)c.apply(template)).filter(Objects::nonNull).toList();
            if (issuesForSingleIndexTemplate.isEmpty()) continue;
            issues.computeIfAbsent(name, ignored -> new ArrayList()).addAll(issuesForSingleIndexTemplate);
        }
        for (Map.Entry entry : componentTemplates) {
            name = (String)entry.getKey();
            template = (ComponentTemplate)entry.getValue();
            issuesForSingleIndexTemplate = this.componentTemplateChecks.stream().map(arg_0 -> TemplateDeprecationChecker.lambda$check$2((ComponentTemplate)template, arg_0)).filter(Objects::nonNull).toList();
            if (issuesForSingleIndexTemplate.isEmpty()) continue;
            issues.computeIfAbsent(name, ignored -> new ArrayList()).addAll(issuesForSingleIndexTemplate);
        }
        return issues.isEmpty() ? Map.of() : issues;
    }

    private DeprecationIssue checkLegacyTiersInIndexTemplate(ComposableIndexTemplate composableIndexTemplate) {
        Template template = composableIndexTemplate.template();
        if (template != null) {
            List<String> deprecatedSettings = LegacyTiersDetection.getDeprecatedFilteredAllocationSettings(template.settings());
            if (deprecatedSettings.isEmpty()) {
                return null;
            }
            return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Configuring tiers via filtered allocation is not recommended.", "https://ela.st/migrate-to-tiers", "One or more of your index templates is configured with 'index.routing.allocation.*.data' settings. This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.", false, DeprecationIssue.createMetaMapForRemovableSettings(deprecatedSettings));
        }
        return null;
    }

    private DeprecationIssue checkSourceModeInComponentTemplates(ComponentTemplate template) {
        Map sourceMap;
        Object source;
        Map sourceAsMap;
        if (template.template().mappings() != null && (sourceAsMap = (Map)((Map)XContentHelper.convertToMap((BytesReference)template.template().mappings().uncompressed(), (boolean)true).v2()).get("_doc")) != null && (source = sourceAsMap.get("_source")) instanceof Map && (sourceMap = (Map)source).containsKey("mode")) {
            return new DeprecationIssue(DeprecationIssue.Level.CRITICAL, "Configuring source mode in mappings is deprecated.", "https://ela.st/migrate-source-mode", "Configuring source mode in mappings is deprecated and will be removed in future versions. Use [index.mapping.source.mode] index setting instead.", false, null);
        }
        return null;
    }

    private DeprecationIssue checkLegacyTiersInComponentTemplates(ComponentTemplate componentTemplate) {
        Template template = componentTemplate.template();
        List<String> deprecatedSettings = LegacyTiersDetection.getDeprecatedFilteredAllocationSettings(template.settings());
        if (deprecatedSettings.isEmpty()) {
            return null;
        }
        return new DeprecationIssue(DeprecationIssue.Level.WARNING, "Configuring tiers via filtered allocation is not recommended.", "https://ela.st/migrate-to-tiers", "One or more of your component templates is configured with 'index.routing.allocation.*.data' settings. This is typically used to create a hot/warm or tiered architecture, based on legacy guidelines. Data tiers are a recommended replacement for tiered architecture clusters.", false, DeprecationIssue.createMetaMapForRemovableSettings(deprecatedSettings));
    }

    @Override
    public String getName() {
        return NAME;
    }

    private static /* synthetic */ DeprecationIssue lambda$check$2(ComponentTemplate template, Function c) {
        return (DeprecationIssue)c.apply(template);
    }
}

