/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.process;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class BlackHoleResultIterator<T>
implements Iterator<T> {
    private final BlockingQueue<T> results;
    private final Supplier<Boolean> isRunning;
    private volatile T latestResult;

    public BlackHoleResultIterator(BlockingQueue<T> results, Supplier<Boolean> isRunning) {
        this.results = results;
        this.isRunning = isRunning;
    }

    @Override
    public boolean hasNext() {
        try {
            while (this.isRunning.get().booleanValue()) {
                this.latestResult = this.results.poll(100L, TimeUnit.MILLISECONDS);
                if (this.latestResult == null) continue;
                return true;
            }
            this.latestResult = this.results.poll();
            return this.latestResult != null;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public T next() {
        return this.latestResult;
    }
}

