/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.datafeed.extractor.aggregation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfigUtils;
import org.elasticsearch.xpack.core.ml.datafeed.SearchInterval;
import org.elasticsearch.xpack.ml.datafeed.DatafeedTimingStatsReporter;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractor;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorQueryContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.DataExtractorUtils;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationDataExtractorContext;
import org.elasticsearch.xpack.ml.datafeed.extractor.aggregation.AggregationToJsonProcessor;

abstract class AbstractAggregationDataExtractor
implements DataExtractor {
    private static final Logger LOGGER = LogManager.getLogger(AbstractAggregationDataExtractor.class);
    protected final Client client;
    protected final AggregationDataExtractorContext context;
    private final DatafeedTimingStatsReporter timingStatsReporter;
    private boolean hasNext;
    private volatile boolean isCancelled;
    private AggregationToJsonProcessor aggregationToJsonProcessor;
    private final ByteArrayOutputStream outputStream;

    AbstractAggregationDataExtractor(Client client, AggregationDataExtractorContext dataExtractorContext, DatafeedTimingStatsReporter timingStatsReporter) {
        this.client = Objects.requireNonNull(client);
        this.context = Objects.requireNonNull(dataExtractorContext);
        this.timingStatsReporter = Objects.requireNonNull(timingStatsReporter);
        this.hasNext = true;
        this.isCancelled = false;
        this.outputStream = new ByteArrayOutputStream();
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void cancel() {
        LOGGER.debug("[{}] Data extractor received cancel request", (Object)this.context.jobId);
        this.isCancelled = true;
        this.hasNext = false;
    }

    @Override
    public void destroy() {
        this.cancel();
    }

    @Override
    public long getEndTime() {
        return this.context.queryContext.end;
    }

    @Override
    public DataExtractor.Result next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        SearchInterval searchInterval = new SearchInterval(this.context.queryContext.start, this.context.queryContext.end);
        if (this.aggregationToJsonProcessor == null) {
            InternalAggregations aggs = this.search();
            if (aggs == null) {
                this.hasNext = false;
                return new DataExtractor.Result(searchInterval, Optional.empty());
            }
            this.initAggregationProcessor(aggs);
        }
        this.outputStream.reset();
        this.aggregationToJsonProcessor.writeAllDocsCancellable(_timestamp -> this.isCancelled, this.outputStream);
        this.hasNext = false;
        return new DataExtractor.Result(searchInterval, this.aggregationToJsonProcessor.getKeyValueCount() > 0L ? Optional.of(new ByteArrayInputStream(this.outputStream.toByteArray())) : Optional.empty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalAggregations search() {
        LOGGER.debug("[{}] Executing aggregated search", (Object)this.context.jobId);
        ActionRequestBuilder<SearchRequest, SearchResponse> searchRequest = this.buildSearchRequest(this.buildBaseSearchSource());
        assert (!((SearchRequest)searchRequest.request()).allowPartialSearchResults().booleanValue());
        SearchResponse searchResponse = AbstractAggregationDataExtractor.executeSearchRequest(this.client, this.context.queryContext, searchRequest);
        try {
            LOGGER.debug("[{}] Search response was obtained", (Object)this.context.jobId);
            this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            InternalAggregations internalAggregations = AbstractAggregationDataExtractor.validateAggs(searchResponse.getAggregations());
            return internalAggregations;
        }
        finally {
            searchResponse.decRef();
        }
    }

    private void initAggregationProcessor(InternalAggregations aggs) throws IOException {
        this.aggregationToJsonProcessor = new AggregationToJsonProcessor(this.context.queryContext.timeField, this.context.fields, this.context.includeDocCount, this.context.queryContext.start, null);
        this.aggregationToJsonProcessor.process(aggs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SearchResponse executeSearchRequest(Client client, DataExtractorQueryContext context, ActionRequestBuilder<SearchRequest, SearchResponse> searchRequestBuilder) {
        SearchResponse searchResponse = (SearchResponse)ClientHelper.executeWithHeaders(context.headers, (String)"ml", (Client)client, () -> searchRequestBuilder.get());
        boolean success = false;
        try {
            DataExtractorUtils.checkForSkippedClusters(searchResponse);
            success = true;
        }
        finally {
            if (!success) {
                searchResponse.decRef();
            }
        }
        return searchResponse;
    }

    private SearchSourceBuilder buildBaseSearchSource() {
        long histogramSearchStartTime = Math.max(0L, this.context.queryContext.start - DatafeedConfigUtils.getHistogramIntervalMillis((AggregatorFactories.Builder)this.context.aggs));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().size(0).query(DataExtractorUtils.wrapInTimeRangeQuery(this.context.queryContext.query, this.context.queryContext.timeField, histogramSearchStartTime, this.context.queryContext.end));
        if (!this.context.queryContext.runtimeMappings.isEmpty()) {
            searchSourceBuilder.runtimeMappings(this.context.queryContext.runtimeMappings);
        }
        this.context.aggs.getAggregatorFactories().forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        this.context.aggs.getPipelineAggregatorFactories().forEach(arg_0 -> ((SearchSourceBuilder)searchSourceBuilder).aggregation(arg_0));
        return searchSourceBuilder;
    }

    protected abstract ActionRequestBuilder<SearchRequest, SearchResponse> buildSearchRequest(SearchSourceBuilder var1);

    private static InternalAggregations validateAggs(@Nullable InternalAggregations aggs) {
        if (aggs == null) {
            return null;
        }
        List aggsAsList = aggs.asList();
        if (aggsAsList.isEmpty()) {
            return null;
        }
        if (aggsAsList.size() > 1) {
            throw new IllegalArgumentException("Multiple top level aggregations not supported; found: " + String.valueOf(aggsAsList.stream().map(Aggregation::getName).toList()));
        }
        return aggs;
    }

    public AggregationDataExtractorContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataExtractor.DataSummary getSummary() {
        ActionRequestBuilder<SearchRequest, SearchResponse> searchRequestBuilder = this.buildSearchRequest(DataExtractorUtils.getSearchSourceBuilderForSummary(this.context.queryContext));
        SearchResponse searchResponse = AbstractAggregationDataExtractor.executeSearchRequest(this.client, this.context.queryContext, searchRequestBuilder);
        try {
            LOGGER.debug("[{}] Aggregating Data summary response was obtained", (Object)this.context.jobId);
            this.timingStatsReporter.reportSearchDuration(searchResponse.getTook());
            DataExtractor.DataSummary dataSummary = DataExtractorUtils.getDataSummary(searchResponse);
            return dataSummary;
        }
        finally {
            searchResponse.decRef();
        }
    }
}

