/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.core.expression;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.esql.core.capabilities.Unresolvable;
import org.elasticsearch.xpack.esql.core.capabilities.UnresolvedException;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NameId;
import org.elasticsearch.xpack.esql.core.expression.Nullability;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.CollectionUtils;

public class UnresolvedAttribute
extends Attribute
implements Unresolvable {
    private final boolean customMessage;
    private final String unresolvedMsg;
    private final Object resolutionMetadata;

    public UnresolvedAttribute(Source source, String name) {
        this(source, name, (String)null);
    }

    public UnresolvedAttribute(Source source, String name, @Nullable String unresolvedMessage) {
        this(source, null, name, unresolvedMessage);
    }

    public UnresolvedAttribute(Source source, @Nullable String qualifier, String name, @Nullable String unresolvedMessage) {
        this(source, qualifier, name, null, unresolvedMessage, null);
    }

    public UnresolvedAttribute(Source source, String name, @Nullable NameId id, @Nullable String unresolvedMessage, Object resolutionMetadata) {
        this(source, null, name, id, unresolvedMessage, resolutionMetadata);
    }

    public UnresolvedAttribute(Source source, @Nullable String qualifier, String name, @Nullable NameId id, @Nullable String unresolvedMessage, Object resolutionMetadata) {
        super(source, qualifier, name, id);
        boolean bl = this.customMessage = unresolvedMessage != null;
        this.unresolvedMsg = unresolvedMessage == null ? UnresolvedAttribute.errorMessage(this.qualifier() != null ? this.qualifiedName() : this.name(), null) : unresolvedMessage;
        this.resolutionMetadata = resolutionMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("doesn't escape the node");
    }

    @Override
    protected NodeInfo<UnresolvedAttribute> info() {
        return NodeInfo.create(this, UnresolvedAttribute::new, this.qualifier(), this.name(), this.id(), this.unresolvedMsg, this.resolutionMetadata);
    }

    public Object resolutionMetadata() {
        return this.resolutionMetadata;
    }

    public boolean customMessage() {
        return this.customMessage;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    protected Attribute clone(Source source, String qualifier, String name, DataType dataType, Nullability nullability, NameId id, boolean synthetic) {
        return this;
    }

    @Override
    public UnresolvedAttribute withId(NameId id) {
        return new UnresolvedAttribute(this.source(), this.qualifier(), this.name(), id, this.unresolvedMessage(), this.resolutionMetadata());
    }

    public UnresolvedAttribute withUnresolvedMessage(String unresolvedMessage) {
        return new UnresolvedAttribute(this.source(), this.qualifier(), this.name(), this.id(), unresolvedMessage, this.resolutionMetadata());
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return new Expression.TypeResolution("unresolved attribute [" + this.name() + "]");
    }

    @Override
    public DataType dataType() {
        throw new UnresolvedException("dataType", (Object)this);
    }

    @Override
    public String toString() {
        return "?" + this.qualifiedName();
    }

    @Override
    protected String label() {
        return "?";
    }

    @Override
    public boolean isDimension() {
        throw new UnsupportedOperationException("This should never be called before the attribute is resolved");
    }

    @Override
    public boolean isMetric() {
        throw new UnsupportedOperationException("This should never be called before the attribute is resolved");
    }

    @Override
    public String nodeString() {
        return this.toString();
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    public static String errorMessage(String name, List<String> potentialMatches) {
        String msg = "Unknown column [" + name + "]";
        if (!CollectionUtils.isEmpty(potentialMatches)) {
            msg = msg + ", did you mean " + (potentialMatches.size() == 1 ? "[" + potentialMatches.get(0) + "]" : "any of " + potentialMatches.toString()) + "?";
        }
        return msg;
    }

    @Override
    protected int innerHashCode(boolean ignoreIds) {
        return Objects.hash(super.innerHashCode(ignoreIds), this.resolutionMetadata, this.unresolvedMsg);
    }

    @Override
    protected boolean innerEquals(Object o, boolean ignoreIds) {
        UnresolvedAttribute other = (UnresolvedAttribute)o;
        return super.innerEquals(o, ignoreIds) && Objects.equals(this.resolutionMetadata, other.resolutionMetadata) && Objects.equals(this.unresolvedMsg, other.unresolvedMsg);
    }
}

