/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.type;

import java.io.IOException;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlock;
import org.elasticsearch.compute.data.AggregateMetricDoubleBlockBuilder;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.geometry.utils.Geohash;
import org.elasticsearch.h3.H3;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.bucket.geogrid.GeoTileUtils;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.esql.core.InvalidArgumentException;
import org.elasticsearch.xpack.esql.core.QlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.FoldContext;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.Converter;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.type.DataTypeConverter;
import org.elasticsearch.xpack.esql.core.util.NumericUtils;
import org.elasticsearch.xpack.esql.core.util.SpatialCoordinateTypes;
import org.elasticsearch.xpack.esql.core.util.StringUtils;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToAggregateMetricDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToBoolean;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToCartesianShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDateNanos;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatePeriod;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDatetime;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDenseVector;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToDouble;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoPoint;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeoShape;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeohash;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeohex;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToGeotile;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToInteger;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToIpLeadingZerosRejected;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToTimeDuration;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToUnsignedLong;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToVersion;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohash;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeohex;
import org.elasticsearch.xpack.esql.expression.function.scalar.spatial.StGeotile;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.versionfield.Version;

public class EsqlDataTypeConverter {
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern((String)"strict_date_optional_time");
    public static final DateFormatter DEFAULT_DATE_NANOS_FORMATTER = DateFormatter.forPattern((String)"strict_date_optional_time_nanos");
    public static final DateFormatter HOUR_MINUTE_SECOND = DateFormatter.forPattern((String)"strict_hour_minute_second_fraction");
    private static final Map<DataType, BiFunction<Source, Expression, AbstractConvertFunction>> TYPE_TO_CONVERTER_FUNCTION;
    public static List<INTERVALS> TIME_DURATIONS;
    public static List<INTERVALS> DATE_PERIODS;
    public static final String INVALID_INTERVAL_ERROR = "Invalid interval value in [{}], expected integer followed by one of {} but got [{}]";

    public static Converter converterFor(DataType from, DataType to) {
        Converter converter;
        if (DataType.isString((DataType)from)) {
            if (to == DataType.DATETIME) {
                return EsqlConverter.STRING_TO_DATETIME;
            }
            if (to == DataType.DATE_NANOS) {
                return EsqlConverter.STRING_TO_DATE_NANOS;
            }
            if (to == DataType.IP) {
                return EsqlConverter.STRING_TO_IP;
            }
            if (to == DataType.VERSION) {
                return EsqlConverter.STRING_TO_VERSION;
            }
            if (to == DataType.DOUBLE) {
                return EsqlConverter.STRING_TO_DOUBLE;
            }
            if (to == DataType.LONG) {
                return EsqlConverter.STRING_TO_LONG;
            }
            if (to == DataType.INTEGER) {
                return EsqlConverter.STRING_TO_INT;
            }
            if (to == DataType.BOOLEAN) {
                return EsqlConverter.STRING_TO_BOOLEAN;
            }
            if (DataType.isSpatialGeo((DataType)to)) {
                return EsqlConverter.STRING_TO_GEO;
            }
            if (DataType.isSpatial((DataType)to)) {
                return EsqlConverter.STRING_TO_SPATIAL;
            }
            if (to == DataType.GEOHASH) {
                return EsqlConverter.STRING_TO_GEOHASH;
            }
            if (to == DataType.GEOTILE) {
                return EsqlConverter.STRING_TO_GEOTILE;
            }
            if (to == DataType.GEOHEX) {
                return EsqlConverter.STRING_TO_GEOHEX;
            }
            if (to == DataType.TIME_DURATION) {
                return EsqlConverter.STRING_TO_TIME_DURATION;
            }
            if (to == DataType.DATE_PERIOD) {
                return EsqlConverter.STRING_TO_DATE_PERIOD;
            }
            if (to == DataType.DENSE_VECTOR) {
                return EsqlConverter.STRING_TO_DENSE_VECTOR;
            }
        }
        if ((converter = DataTypeConverter.converterFor((DataType)from, (DataType)to)) != null) {
            return converter;
        }
        return null;
    }

    public static TemporalAmount foldToTemporalAmount(FoldContext ctx, Expression field, String sourceText, DataType expectedType) {
        if (field.foldable()) {
            Object v = field.fold(ctx);
            if (v instanceof BytesRef) {
                BytesRef b = (BytesRef)v;
                try {
                    return EsqlDataTypeConverter.parseTemporalAmount(b.utf8ToString(), expectedType);
                }
                catch (ParsingException e) {
                    throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)INVALID_INTERVAL_ERROR, (Object[])new Object[]{sourceText, expectedType == DataType.DATE_PERIOD ? DATE_PERIODS : TIME_DURATIONS, b.utf8ToString()}));
                }
            }
            if (v instanceof TemporalAmount) {
                TemporalAmount t = (TemporalAmount)v;
                return t;
            }
        }
        throw new IllegalArgumentException(LoggerMessageFormat.format(null, (String)"argument of [{}] must be a constant, received [{}]", (Object[])new Object[]{field.sourceText(), Expressions.name((Expression)field)}));
    }

    public static TemporalAmount parseTemporalAmount(Object val, DataType expectedType) {
        Object errorMessage = "Cannot parse [{}] to {}";
        String str = String.valueOf(val);
        if (str == null) {
            return null;
        }
        StringBuilder value = new StringBuilder();
        StringBuilder temporalUnit = new StringBuilder();
        EsqlDataTypeConverter.separateValueAndTemporalUnitForTemporalAmount(str.strip(), value, temporalUnit, (String)errorMessage, expectedType.toString());
        if (!(value.isEmpty() || temporalUnit.isEmpty())) {
            try {
                TemporalAmount result = EsqlDataTypeConverter.parseTemporalAmount(Integer.parseInt(value.toString()), temporalUnit.toString(), Source.EMPTY);
                if (DataType.DATE_PERIOD == expectedType && result instanceof Period || DataType.TIME_DURATION == expectedType && result instanceof Duration) {
                    return result;
                }
                if (result instanceof Period && expectedType == DataType.TIME_DURATION) {
                    errorMessage = (String)errorMessage + ", did you mean " + String.valueOf(DataType.DATE_PERIOD) + "?";
                }
                if (result instanceof Duration && expectedType == DataType.DATE_PERIOD) {
                    errorMessage = (String)errorMessage + ", did you mean " + String.valueOf(DataType.TIME_DURATION) + "?";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParsingException(Source.EMPTY, (String)errorMessage, val, expectedType);
    }

    public static TemporalAmount maybeParseTemporalAmount(String str) {
        String errorMessage = "Cannot parse [{}] to {}";
        String expectedTypes = String.valueOf(DataType.DATE_PERIOD) + " or " + String.valueOf(DataType.TIME_DURATION);
        StringBuilder value = new StringBuilder();
        StringBuilder temporalUnit = new StringBuilder();
        EsqlDataTypeConverter.separateValueAndTemporalUnitForTemporalAmount(str, value, temporalUnit, errorMessage, expectedTypes);
        if (!(value.isEmpty() || temporalUnit.isEmpty())) {
            try {
                return EsqlDataTypeConverter.parseTemporalAmount(Integer.parseInt(value.toString()), temporalUnit.toString(), Source.EMPTY);
            }
            catch (NumberFormatException ex) {
                throw new ParsingException(Source.EMPTY, errorMessage, str, expectedTypes);
            }
        }
        return null;
    }

    private static void separateValueAndTemporalUnitForTemporalAmount(String temporalAmount, StringBuilder value, StringBuilder temporalUnit, String errorMessage, String expectedType) {
        StringBuilder nextBuffer = value;
        boolean lastWasSpace = false;
        for (char c : temporalAmount.toCharArray()) {
            if (c == ' ') {
                if (!lastWasSpace) {
                    nextBuffer = nextBuffer == value ? temporalUnit : null;
                }
                lastWasSpace = true;
                continue;
            }
            if (nextBuffer == null) {
                throw new ParsingException(Source.EMPTY, errorMessage, temporalAmount, expectedType);
            }
            nextBuffer.append(c);
            lastWasSpace = false;
        }
    }

    public static Object convert(Object value, DataType dataType) {
        DataType detectedType = DataType.fromJava((Object)value);
        if (detectedType == dataType || value == null) {
            return value;
        }
        Converter converter = EsqlDataTypeConverter.converterFor(detectedType, dataType);
        if (converter == null) {
            throw new QlIllegalArgumentException("cannot convert from [{}], type [{}] to [{}]", new Object[]{value, detectedType.typeName(), dataType.typeName()});
        }
        return converter.convert(value);
    }

    public static DataType commonType(DataType left, DataType right) {
        if (left == right) {
            return left;
        }
        if (left == DataType.NULL) {
            return right;
        }
        if (right == DataType.NULL) {
            return left;
        }
        if (DataType.isDateTimeOrNanosOrTemporal((DataType)left) || DataType.isDateTimeOrNanosOrTemporal((DataType)right)) {
            if (DataType.isDateTime((DataType)left) && DataType.isNullOrTemporalAmount((DataType)right) || DataType.isNullOrTemporalAmount((DataType)left) && DataType.isDateTime((DataType)right)) {
                return DataType.DATETIME;
            }
            if (left == DataType.DATE_NANOS && DataType.isNullOrTemporalAmount((DataType)right) || DataType.isNullOrTemporalAmount((DataType)left) && right == DataType.DATE_NANOS) {
                return DataType.DATE_NANOS;
            }
            if (DataType.isNullOrTimeDuration((DataType)left) && DataType.isNullOrTimeDuration((DataType)right)) {
                return DataType.TIME_DURATION;
            }
            if (DataType.isNullOrDatePeriod((DataType)left) && DataType.isNullOrDatePeriod((DataType)right)) {
                return DataType.DATE_PERIOD;
            }
        }
        if (DataType.isString((DataType)left) && DataType.isString((DataType)right)) {
            return DataType.KEYWORD;
        }
        if (left.isNumeric() && right.isNumeric()) {
            int lsize = left.estimatedSize();
            int rsize = right.estimatedSize();
            if (left.isWholeNumber()) {
                if (right.isWholeNumber()) {
                    if (left == DataType.UNSIGNED_LONG || right == DataType.UNSIGNED_LONG) {
                        return DataType.UNSIGNED_LONG;
                    }
                    return lsize > rsize ? left : right;
                }
                return right;
            }
            if (right.isWholeNumber()) {
                return left;
            }
            return lsize > rsize ? left : right;
        }
        return null;
    }

    public static TemporalAmount parseTemporalAmount(Number value, String temporalUnit, Source source) throws InvalidArgumentException, ArithmeticException, ParsingException {
        try {
            return switch (INTERVALS.valueOf(temporalUnit.toUpperCase(Locale.ROOT)).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0, 1, 2 -> Duration.ofMillis(DataTypeConverter.safeToLong((Number)value));
                case 3, 4, 5, 6 -> Duration.ofSeconds(DataTypeConverter.safeToLong((Number)value));
                case 7, 8, 9, 10 -> Duration.ofMinutes(DataTypeConverter.safeToLong((Number)value));
                case 11, 12, 13 -> Duration.ofHours(DataTypeConverter.safeToLong((Number)value));
                case 14, 15, 16 -> Period.ofDays(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
                case 17, 18, 19 -> Period.ofWeeks(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
                case 20, 21, 22 -> Period.ofMonths(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
                case 23, 24, 25 -> Period.ofMonths(DataTypeConverter.safeToInt((long)Math.multiplyExact(3L, DataTypeConverter.safeToLong((Number)value))));
                case 26, 27, 28, 29 -> Period.ofYears(DataTypeConverter.safeToInt((long)DataTypeConverter.safeToLong((Number)value)));
            };
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(source, "Unexpected temporal unit: '{}'", temporalUnit);
        }
    }

    private static ChronoField stringToChrono(Object field) {
        ChronoField chronoField = null;
        try {
            BytesRef br = BytesRefs.toBytesRef((Object)field);
            chronoField = ChronoField.valueOf(br.utf8ToString().toUpperCase(Locale.ROOT));
        }
        catch (Exception e) {
            return null;
        }
        return chronoField;
    }

    public static long chronoToLong(long dateTime, BytesRef chronoField, ZoneId zone) {
        ChronoField chrono = ChronoField.valueOf(chronoField.utf8ToString().toUpperCase(Locale.ROOT));
        return EsqlDataTypeConverter.chronoToLong(dateTime, chrono, zone);
    }

    public static long chronoToLong(long dateTime, ChronoField chronoField, ZoneId zone) {
        return Instant.ofEpochMilli(dateTime).atZone(zone).getLong(chronoField);
    }

    public static long chronoToLongNanos(long dateNanos, BytesRef chronoField, ZoneId zone) {
        ChronoField chrono = ChronoField.valueOf(chronoField.utf8ToString().toUpperCase(Locale.ROOT));
        return EsqlDataTypeConverter.chronoToLongNanos(dateNanos, chrono, zone);
    }

    public static long chronoToLongNanos(long dateNanos, ChronoField chronoField, ZoneId zone) {
        return DateUtils.toInstant((long)dateNanos).atZone(zone).getLong(chronoField);
    }

    public static BytesRef stringToIP(BytesRef field) {
        return StringUtils.parseIP((String)field.utf8ToString());
    }

    public static BytesRef stringToIP(String field) {
        return StringUtils.parseIP((String)field);
    }

    public static String ipToString(BytesRef field) {
        return DocValueFormat.IP.format(field);
    }

    public static BytesRef stringToVersion(BytesRef field) {
        return new Version(field.utf8ToString()).toBytesRef();
    }

    public static BytesRef stringToVersion(String field) {
        return new Version(field).toBytesRef();
    }

    public static String versionToString(BytesRef field) {
        return new Version(field).toString();
    }

    public static String versionToString(Version field) {
        return field.toString();
    }

    public static String spatialToString(BytesRef field) {
        return SpatialCoordinateTypes.UNSPECIFIED.wkbToWkt(field);
    }

    public static String geoGridToString(long field, DataType dataType) {
        return switch (dataType) {
            case DataType.GEOHASH -> Geohash.stringEncode((long)field);
            case DataType.GEOTILE -> GeoTileUtils.stringEncode((long)field);
            case DataType.GEOHEX -> H3.h3ToString((long)field);
            default -> throw new IllegalArgumentException("Unsupported data type for geo grid: " + String.valueOf(dataType));
        };
    }

    public static BytesRef geoGridToShape(long field, DataType dataType) {
        return switch (dataType) {
            case DataType.GEOHASH -> StGeohash.toBounds(field);
            case DataType.GEOTILE -> StGeotile.toBounds(field);
            case DataType.GEOHEX -> StGeohex.toBounds(field);
            default -> throw new IllegalArgumentException("Unsupported data type for geo grid: " + String.valueOf(dataType));
        };
    }

    public static BytesRef stringToGeo(String field) {
        return SpatialCoordinateTypes.GEO.wktToWkb(field);
    }

    public static BytesRef stringToSpatial(String field) {
        return SpatialCoordinateTypes.UNSPECIFIED.wktToWkb(field);
    }

    public static long dateTimeToLong(String dateTime) {
        return DEFAULT_DATE_TIME_FORMATTER.parseMillis(dateTime);
    }

    public static long dateTimeToLong(String dateTime, DateFormatter formatter) {
        return formatter == null ? EsqlDataTypeConverter.dateTimeToLong(dateTime) : formatter.parseMillis(dateTime);
    }

    public static long dateNanosToLong(String dateNano) {
        return EsqlDataTypeConverter.dateNanosToLong(dateNano, DEFAULT_DATE_NANOS_FORMATTER);
    }

    public static long dateNanosToLong(String dateNano, DateFormatter formatter) {
        Instant parsed = DateFormatters.from((TemporalAccessor)formatter.parse(dateNano)).toInstant();
        return DateUtils.toLong((Instant)parsed);
    }

    public static String dateWithTypeToString(long dateTime, DataType type) {
        if (type == DataType.DATETIME) {
            return EsqlDataTypeConverter.dateTimeToString(dateTime);
        }
        if (type == DataType.DATE_NANOS) {
            return EsqlDataTypeConverter.nanoTimeToString(dateTime);
        }
        throw new IllegalArgumentException("Unsupported data type [" + String.valueOf(type) + "]");
    }

    public static String dateTimeToString(long dateTime) {
        return DEFAULT_DATE_TIME_FORMATTER.formatMillis(dateTime);
    }

    public static String nanoTimeToString(long dateTime) {
        return DEFAULT_DATE_NANOS_FORMATTER.formatNanos(dateTime);
    }

    public static String dateTimeToString(long dateTime, DateFormatter formatter) {
        return formatter == null ? EsqlDataTypeConverter.dateTimeToString(dateTime) : formatter.formatMillis(dateTime);
    }

    public static String nanoTimeToString(long dateTime, DateFormatter formatter) {
        return formatter == null ? EsqlDataTypeConverter.nanoTimeToString(dateTime) : formatter.formatNanos(dateTime);
    }

    public static BytesRef numericBooleanToString(Object field) {
        return new BytesRef((CharSequence)String.valueOf(field));
    }

    public static boolean stringToBoolean(String field) {
        return Booleans.parseBooleanLenient((String)field, (boolean)false);
    }

    public static int stringToInt(String field) {
        try {
            return Integer.parseInt(field);
        }
        catch (NumberFormatException nfe) {
            try {
                return DataTypeConverter.safeToInt((double)EsqlDataTypeConverter.stringToDouble(field));
            }
            catch (Exception e) {
                throw new InvalidArgumentException((Throwable)nfe, "Cannot parse number [{}]", new Object[]{field});
            }
        }
    }

    public static long stringToLong(String field) {
        try {
            return StringUtils.parseLong((String)field);
        }
        catch (InvalidArgumentException iae) {
            try {
                return DataTypeConverter.safeDoubleToLong((double)EsqlDataTypeConverter.stringToDouble(field));
            }
            catch (Exception e) {
                throw new InvalidArgumentException((Throwable)iae, "Cannot parse number [{}]", new Object[]{field});
            }
        }
    }

    public static double stringToDouble(String field) {
        return StringUtils.parseDouble((String)field);
    }

    public static BytesRef unsignedLongToString(long number) {
        return new BytesRef((CharSequence)NumericUtils.unsignedLongAsNumber((long)number).toString());
    }

    public static long stringToUnsignedLong(String field) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((String)field));
    }

    public static Number stringToIntegral(String field) {
        return StringUtils.parseIntegral((String)field);
    }

    public static double unsignedLongToDouble(long number) {
        return NumericUtils.unsignedLongAsNumber((long)number).doubleValue();
    }

    public static long doubleToUnsignedLong(double number) {
        return NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Double)number));
    }

    public static int unsignedLongToInt(long number) {
        Number n = NumericUtils.unsignedLongAsNumber((long)number);
        int i = n.intValue();
        if ((long)i != n.longValue()) {
            throw new InvalidArgumentException("[{}] out of [integer] range", new Object[]{n});
        }
        return i;
    }

    public static long intToUnsignedLong(int number) {
        return EsqlDataTypeConverter.longToUnsignedLong(number, false);
    }

    public static long unsignedLongToLong(long number) {
        return DataTypeConverter.safeToLong((Number)NumericUtils.unsignedLongAsNumber((long)number));
    }

    public static long longToUnsignedLong(long number, boolean allowNegative) {
        return !allowNegative ? NumericUtils.asLongUnsigned((BigInteger)DataTypeConverter.safeToUnsignedLong((Long)number)) : NumericUtils.asLongUnsigned((long)number);
    }

    public static long bigIntegerToUnsignedLong(BigInteger field) {
        BigInteger unsignedLong = NumericUtils.asUnsignedLong((BigInteger)field);
        return NumericUtils.asLongUnsigned((BigInteger)unsignedLong);
    }

    public static BigInteger unsignedLongToBigInteger(long number) {
        return NumericUtils.unsignedLongAsBigInteger((long)number);
    }

    public static boolean unsignedLongToBoolean(long number) {
        Number n = NumericUtils.unsignedLongAsNumber((long)number);
        return n instanceof BigInteger || n.longValue() != 0L;
    }

    public static List<Float> stringToDenseVector(String field) {
        try {
            byte[] bytes = HexFormat.of().parseHex(field);
            ArrayList<Float> vector = new ArrayList<Float>(bytes.length);
            for (byte value : bytes) {
                vector.add(Float.valueOf(value));
            }
            return vector;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "%s is not a valid hex string: %s", field, e.getMessage()));
        }
    }

    public static long booleanToUnsignedLong(boolean number) {
        return number ? NumericUtils.ONE_AS_UNSIGNED_LONG : NumericUtils.ZERO_AS_UNSIGNED_LONG;
    }

    public static String aggregateMetricDoubleBlockToString(AggregateMetricDoubleBlock aggBlock, int index) {
        String string;
        block10: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.startObject();
                for (AggregateMetricDoubleBlockBuilder.Metric metric : List.of(AggregateMetricDoubleBlockBuilder.Metric.MIN, AggregateMetricDoubleBlockBuilder.Metric.MAX, AggregateMetricDoubleBlockBuilder.Metric.SUM)) {
                    Block block = aggBlock.getMetricBlock(metric.getIndex());
                    if (block.isNull(index)) continue;
                    builder.field(metric.getLabel(), ((DoubleBlock)block).getDouble(index));
                }
                Block countBlock = aggBlock.getMetricBlock(AggregateMetricDoubleBlockBuilder.Metric.COUNT.getIndex());
                if (!countBlock.isNull(index)) {
                    builder.field(AggregateMetricDoubleBlockBuilder.Metric.COUNT.getLabel(), ((IntBlock)countBlock).getInt(index));
                }
                builder.endObject();
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("error rendering aggregate metric double", e);
                }
            }
            builder.close();
        }
        return string;
    }

    public static String aggregateMetricDoubleLiteralToString(AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral aggMetric) {
        String string;
        block12: {
            XContentBuilder builder = JsonXContent.contentBuilder();
            try {
                builder.startObject();
                if (aggMetric.min() != null) {
                    builder.field(AggregateMetricDoubleBlockBuilder.Metric.MIN.getLabel(), aggMetric.min());
                }
                if (aggMetric.max() != null) {
                    builder.field(AggregateMetricDoubleBlockBuilder.Metric.MAX.getLabel(), aggMetric.max());
                }
                if (aggMetric.sum() != null) {
                    builder.field(AggregateMetricDoubleBlockBuilder.Metric.SUM.getLabel(), aggMetric.sum());
                }
                if (aggMetric.count() != null) {
                    builder.field(AggregateMetricDoubleBlockBuilder.Metric.COUNT.getLabel(), aggMetric.count());
                }
                builder.endObject();
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("error rendering aggregate metric double", e);
                }
            }
            builder.close();
        }
        return string;
    }

    public static AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral stringToAggregateMetricDoubleLiteral(String s) {
        String[] values;
        Double min = null;
        Double max = null;
        Double sum = null;
        Integer count = null;
        s = s.replace("\\,", ",");
        block16: for (String v : values = s.substring(1, s.length() - 1).split(",")) {
            String[] pair = v.split(":");
            String type = pair[0];
            String number = pair[1];
            switch (type) {
                case "min": 
                case "\"min\"": {
                    min = Double.parseDouble(number);
                    continue block16;
                }
                case "max": 
                case "\"max\"": {
                    max = Double.parseDouble(number);
                    continue block16;
                }
                case "sum": 
                case "\"sum\"": {
                    sum = Double.parseDouble(number);
                    continue block16;
                }
                case "value_count": 
                case "\"value_count\"": {
                    count = Integer.parseInt(number);
                    continue block16;
                }
                default: {
                    throw new IllegalArgumentException("Received a metric that wasn't min, max, sum, or value_count: " + type + " with value: " + number);
                }
            }
        }
        return new AggregateMetricDoubleBlockBuilder.AggregateMetricDoubleLiteral(min, max, sum, count);
    }

    public static BiFunction<Source, Expression, AbstractConvertFunction> converterFunctionFactory(DataType toType) {
        return TYPE_TO_CONVERTER_FUNCTION.get(toType);
    }

    static {
        HashMap<DataType, BiFunction<Source, Expression, AbstractConvertFunction>> typeToConverter = new HashMap<DataType, BiFunction<Source, Expression, AbstractConvertFunction>>();
        typeToConverter.put(DataType.AGGREGATE_METRIC_DOUBLE, ToAggregateMetricDouble::new);
        typeToConverter.put(DataType.BOOLEAN, ToBoolean::new);
        typeToConverter.put(DataType.CARTESIAN_POINT, ToCartesianPoint::new);
        typeToConverter.put(DataType.CARTESIAN_SHAPE, ToCartesianShape::new);
        typeToConverter.put(DataType.DATETIME, ToDatetime::new);
        typeToConverter.put(DataType.DATE_NANOS, ToDateNanos::new);
        typeToConverter.put(DataType.DENSE_VECTOR, ToDenseVector::new);
        typeToConverter.put(DataType.DOUBLE, ToDouble::new);
        typeToConverter.put(DataType.GEO_POINT, ToGeoPoint::new);
        typeToConverter.put(DataType.GEO_SHAPE, ToGeoShape::new);
        typeToConverter.put(DataType.GEOHASH, ToGeohash::new);
        typeToConverter.put(DataType.GEOTILE, ToGeotile::new);
        typeToConverter.put(DataType.GEOHEX, ToGeohex::new);
        typeToConverter.put(DataType.INTEGER, ToInteger::new);
        typeToConverter.put(DataType.IP, ToIpLeadingZerosRejected::new);
        typeToConverter.put(DataType.LONG, ToLong::new);
        typeToConverter.put(DataType.KEYWORD, ToString::new);
        typeToConverter.put(DataType.UNSIGNED_LONG, ToUnsignedLong::new);
        typeToConverter.put(DataType.VERSION, ToVersion::new);
        typeToConverter.put(DataType.DATE_PERIOD, ToDatePeriod::new);
        typeToConverter.put(DataType.TIME_DURATION, ToTimeDuration::new);
        typeToConverter.put(DataType.DENSE_VECTOR, ToDenseVector::new);
        TYPE_TO_CONVERTER_FUNCTION = Collections.unmodifiableMap(typeToConverter);
        TIME_DURATIONS = List.of(INTERVALS.MILLISECOND, INTERVALS.MILLISECONDS, INTERVALS.MS, INTERVALS.SECOND, INTERVALS.SECONDS, INTERVALS.SEC, INTERVALS.S, INTERVALS.MINUTE, INTERVALS.MINUTES, INTERVALS.MIN, INTERVALS.M, INTERVALS.HOUR, INTERVALS.HOURS, INTERVALS.H);
        DATE_PERIODS = List.of(INTERVALS.DAY, INTERVALS.DAYS, INTERVALS.D, INTERVALS.WEEK, INTERVALS.WEEKS, INTERVALS.W, INTERVALS.MONTH, INTERVALS.MONTHS, INTERVALS.MO, INTERVALS.QUARTER, INTERVALS.QUARTERS, INTERVALS.Q, INTERVALS.YEAR, INTERVALS.YEARS, INTERVALS.YR, INTERVALS.Y);
    }

    public static enum EsqlConverter implements Converter
    {
        STRING_TO_DATE_PERIOD(x -> EsqlDataTypeConverter.parseTemporalAmount(x, DataType.DATE_PERIOD)),
        STRING_TO_TIME_DURATION(x -> EsqlDataTypeConverter.parseTemporalAmount(x, DataType.TIME_DURATION)),
        STRING_TO_CHRONO_FIELD(EsqlDataTypeConverter::stringToChrono),
        STRING_TO_DATETIME(x -> EsqlDataTypeConverter.dateTimeToLong(BytesRefs.toString((Object)x))),
        STRING_TO_DATE_NANOS(x -> EsqlDataTypeConverter.dateNanosToLong(BytesRefs.toString((Object)x))),
        STRING_TO_IP(x -> EsqlDataTypeConverter.stringToIP(BytesRefs.toString((Object)x))),
        STRING_TO_VERSION(x -> EsqlDataTypeConverter.stringToVersion(BytesRefs.toString((Object)x))),
        STRING_TO_DOUBLE(x -> EsqlDataTypeConverter.stringToDouble(BytesRefs.toString((Object)x))),
        STRING_TO_LONG(x -> EsqlDataTypeConverter.stringToLong(BytesRefs.toString((Object)x))),
        STRING_TO_INT(x -> EsqlDataTypeConverter.stringToInt(BytesRefs.toString((Object)x))),
        STRING_TO_BOOLEAN(x -> EsqlDataTypeConverter.stringToBoolean(BytesRefs.toString((Object)x))),
        STRING_TO_GEO(x -> EsqlDataTypeConverter.stringToGeo(BytesRefs.toString((Object)x))),
        STRING_TO_SPATIAL(x -> EsqlDataTypeConverter.stringToSpatial(BytesRefs.toString((Object)x))),
        STRING_TO_GEOHASH(x -> Geohash.longEncode((String)BytesRefs.toString((Object)x))),
        STRING_TO_GEOTILE(x -> GeoTileUtils.longEncode((String)BytesRefs.toString((Object)x))),
        STRING_TO_GEOHEX(x -> H3.stringToH3((String)BytesRefs.toString((Object)x))),
        STRING_TO_DENSE_VECTOR(x -> EsqlDataTypeConverter.stringToDenseVector(BytesRefs.toString((Object)x)));

        private static final String NAME = "esql-converter";
        private final Function<Object, Object> converter;

        private EsqlConverter(Function<Object, Object> converter) {
            this.converter = converter;
        }

        public String getWriteableName() {
            return NAME;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum((Enum)this);
        }

        public static Converter read(StreamInput in) throws IOException {
            return (Converter)in.readEnum(EsqlConverter.class);
        }

        public Object convert(Object l) {
            if (l == null) {
                return null;
            }
            return this.converter.apply(l);
        }
    }

    public static enum INTERVALS {
        MILLISECOND,
        MILLISECONDS,
        MS,
        SECOND,
        SECONDS,
        SEC,
        S,
        MINUTE,
        MINUTES,
        MIN,
        M,
        HOUR,
        HOURS,
        H,
        DAY,
        DAYS,
        D,
        WEEK,
        WEEKS,
        W,
        MONTH,
        MONTHS,
        MO,
        QUARTER,
        QUARTERS,
        Q,
        YEAR,
        YEARS,
        YR,
        Y;

    }
}

