/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.grok.GrokBuiltinPatterns;
import org.elasticsearch.grok.GrokCaptureConfig;
import org.elasticsearch.grok.GrokCaptureType;
import org.elasticsearch.grok.PatternBank;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.NamedExpressions;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.parser.ParsingException;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.RegexExtract;
import org.elasticsearch.xpack.esql.plan.logical.UnaryPlan;

public class Grok
extends RegexExtract
implements TelemetryAware {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(LogicalPlan.class, "Grok", Grok::readFrom);
    private static final Logger logger = LogManager.getLogger(Grok.class);
    private final Parser parser;

    public static Parser pattern(Source source, String pattern) {
        try {
            PatternBank builtinPatterns = GrokBuiltinPatterns.get((boolean)true);
            org.elasticsearch.grok.Grok grok = new org.elasticsearch.grok.Grok(builtinPatterns, pattern, arg_0 -> ((Logger)logger).warn(arg_0));
            return new Parser(pattern, grok);
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(source, "Invalid pattern [{}] for grok: {}", pattern, e.getMessage());
        }
    }

    public Grok(Source source, LogicalPlan child, Expression inputExpression, Parser parser) {
        this(source, child, inputExpression, parser, parser.extractedFields());
    }

    public Grok(Source source, LogicalPlan child, Expression inputExpr, Parser parser, List<Attribute> extracted) {
        super(source, child, inputExpr, extracted);
        this.parser = parser;
    }

    private static Grok readFrom(StreamInput in) throws IOException {
        Source source = Source.readFrom((StreamInput)((PlanStreamInput)in));
        return new Grok(source, (LogicalPlan)in.readNamedWriteable(LogicalPlan.class), (Expression)in.readNamedWriteable(Expression.class), Grok.pattern(source, in.readString()), in.readNamedWriteableCollectionAsList(Attribute.class));
    }

    public void writeTo(StreamOutput out) throws IOException {
        Source.EMPTY.writeTo(out);
        out.writeNamedWriteable((NamedWriteable)this.child());
        out.writeNamedWriteable((NamedWriteable)this.input());
        out.writeString(this.parser().pattern());
        out.writeNamedWriteableCollection(this.extractedFields());
    }

    public String getWriteableName() {
        return Grok.ENTRY.name;
    }

    @Override
    public UnaryPlan replaceChild(LogicalPlan newChild) {
        return new Grok(this.source(), newChild, this.input, this.parser, this.extractedFields);
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Grok::new, (Object)((Object)this.child()), (Object)this.input, (Object)this.parser, (Object)this.extractedFields);
    }

    @Override
    public List<Attribute> output() {
        return NamedExpressions.mergeOutputAttributes(this.extractedFields, this.child().output());
    }

    @Override
    public Grok withGeneratedNames(List<String> newNames) {
        return new Grok(this.source(), this.child(), this.input, this.parser, this.renameExtractedFields(newNames));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Grok grok = (Grok)o;
        return Objects.equals(this.parser, grok.parser);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.parser);
    }

    public Parser parser() {
        return this.parser;
    }

    public record Parser(String pattern, org.elasticsearch.grok.Grok grok) {
        public List<Attribute> extractedFields() {
            return this.grok.captureConfig().stream().sorted(Comparator.comparing(GrokCaptureConfig::name)).map(x -> new ReferenceAttribute(Source.EMPTY, null, x.name(), Parser.toDataType(x.type()).widenSmallNumeric())).collect(Collectors.toList());
        }

        private static DataType toDataType(GrokCaptureType type) {
            return switch (type) {
                default -> throw new MatchException(null, null);
                case GrokCaptureType.STRING -> DataType.KEYWORD;
                case GrokCaptureType.INTEGER -> DataType.INTEGER;
                case GrokCaptureType.LONG -> DataType.LONG;
                case GrokCaptureType.FLOAT -> DataType.FLOAT;
                case GrokCaptureType.DOUBLE -> DataType.DOUBLE;
                case GrokCaptureType.BOOLEAN -> DataType.BOOLEAN;
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parser parser = (Parser)o;
            return Objects.equals(this.pattern, parser.pattern);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.pattern);
        }
    }
}

