/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.vector;

import java.io.IOException;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.vector.VectorSimilarityFunction;

public class L1Norm
extends VectorSimilarityFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "L1Norm", L1Norm::new);
    static final VectorSimilarityFunction.SimilarityEvaluatorFunction SIMILARITY_FUNCTION = L1Norm::calculateSimilarity;

    @FunctionInfo(returnType={"double"}, preview=true, description="Calculates the l1 norm between two dense_vectors.", examples={@Example(file="vector-l1-norm", tag="vector-l1-norm")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.DEVELOPMENT)})
    public L1Norm(Source source, @Param(name="left", type={"dense_vector"}, description="first dense_vector to calculate l1 norm similarity") Expression left, @Param(name="right", type={"dense_vector"}, description="second dense_vector to calculate l1 norm similarity") Expression right) {
        super(source, left, right);
    }

    private L1Norm(StreamInput in) throws IOException {
        super(in);
    }

    protected BinaryScalarFunction replaceChildren(Expression newLeft, Expression newRight) {
        return new L1Norm(this.source(), newLeft, newRight);
    }

    @Override
    protected VectorSimilarityFunction.SimilarityEvaluatorFunction getSimilarityFunction() {
        return SIMILARITY_FUNCTION;
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, L1Norm::new, (Object)this.left(), (Object)this.right());
    }

    public String getWriteableName() {
        return L1Norm.ENTRY.name;
    }

    public static float calculateSimilarity(float[] leftScratch, float[] rightScratch) {
        float result = 0.0f;
        for (int i = 0; i < leftScratch.length; ++i) {
            result += Math.abs(leftScratch[i] - rightScratch[i]);
        }
        return result;
    }
}

