/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Exp;

public final class ExpIntEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ExpIntEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator val;
    private final DriverContext driverContext;
    private Warnings warnings;

    public ExpIntEvaluator(Source source, EvalOperator.ExpressionEvaluator val, DriverContext driverContext) {
        this.source = source;
        this.val = val;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (IntBlock valBlock = (IntBlock)this.val.eval(page);){
            IntVector valVector = valBlock.asVector();
            if (valVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), valVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.val.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, IntBlock valBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            block9: for (int p = 0; p < positionCount; ++p) {
                switch (valBlock.getValueCount(p)) {
                    case 0: {
                        result.appendNull();
                        continue block9;
                    }
                    case 1: {
                        break;
                    }
                    default: {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                        result.appendNull();
                        continue block9;
                    }
                }
                int val = valBlock.getInt(valBlock.getFirstValueIndex(p));
                result.appendDouble(Exp.process(val));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, IntVector valVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int val = valVector.getInt(p);
                result.appendDouble(p, Exp.process(val));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "ExpIntEvaluator[val=" + String.valueOf(this.val) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.val);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory val;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory val) {
            this.source = source;
            this.val = val;
        }

        public ExpIntEvaluator get(DriverContext context) {
            return new ExpIntEvaluator(this.source, this.val.get(context), context);
        }

        public String toString() {
            return "ExpIntEvaluator[val=" + String.valueOf(this.val) + "]";
        }
    }
}

