/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.operator.BreakingBytesRefBuilder;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.evaluator.mapper.EvaluatorMapper;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.scalar.UnaryScalarFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.UrlEncodeEvaluator;
import org.elasticsearch.xpack.esql.expression.function.scalar.util.UrlCodecUtils;

public final class UrlEncode
extends UnaryScalarFunction {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "UrlEncode", UrlEncode::new);

    private UrlEncode(StreamInput in) throws IOException {
        super(in);
    }

    @FunctionInfo(returnType={"keyword"}, description="URL-encodes the input. All characters are {wikipedia}/Percent-encoding[percent-encoded] except for alphanumerics, `.`, `-`, `_`, and `~`. Spaces are encoded as `+`.", examples={@Example(file="string", tag="url_encode")}, appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.GA, version="9.2.0")})
    public UrlEncode(Source source, @Param(name="string", type={"keyword", "text"}, description="The URL to encode.") Expression str) {
        super(source, str);
    }

    public Expression replaceChildren(List<Expression> newChildren) {
        return new UrlEncode(this.source(), newChildren.get(0));
    }

    protected NodeInfo<? extends Expression> info() {
        return NodeInfo.create((Node)this, UrlEncode::new, (Object)this.field());
    }

    public String getWriteableName() {
        return UrlEncode.ENTRY.name;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (!this.childrenResolved()) {
            return new Expression.TypeResolution("Unresolved children");
        }
        return TypeResolutions.isString((Expression)this.field, (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.DEFAULT);
    }

    @Override
    public EvalOperator.ExpressionEvaluator.Factory toEvaluator(EvaluatorMapper.ToEvaluator toEvaluator) {
        return new UrlEncodeEvaluator.Factory(this.source(), toEvaluator.apply(this.field()), context -> new BreakingBytesRefBuilder(context.breaker(), "url_encode"));
    }

    static BytesRef process(BytesRef val, BreakingBytesRefBuilder scratch) {
        return UrlCodecUtils.urlEncode(val, scratch, true);
    }
}

