/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.convert;

import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.FloatBlock;
import org.elasticsearch.compute.data.FloatVector;
import org.elasticsearch.compute.data.Vector;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.AbstractConvertFunction;
import org.elasticsearch.xpack.esql.expression.function.scalar.convert.ToString;

public final class ToStringFromFloatEvaluator
extends AbstractConvertFunction.AbstractEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ToStringFromFloatEvaluator.class);
    private final EvalOperator.ExpressionEvaluator flt;

    public ToStringFromFloatEvaluator(Source source, EvalOperator.ExpressionEvaluator flt, DriverContext driverContext) {
        super(driverContext, source);
        this.flt = flt;
    }

    @Override
    public EvalOperator.ExpressionEvaluator next() {
        return this.flt;
    }

    @Override
    public Block evalVector(Vector v) {
        FloatVector vector = (FloatVector)v;
        int positionCount = v.getPositionCount();
        if (vector.isConstant()) {
            return this.driverContext.blockFactory().newConstantBytesRefBlockWith(this.evalValue(vector, 0), positionCount);
        }
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                builder.appendBytesRef(this.evalValue(vector, p));
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(FloatVector container, int index) {
        float value = container.getFloat(index);
        return ToString.fromFloat(value);
    }

    @Override
    public Block evalBlock(Block b) {
        FloatBlock block = (FloatBlock)b;
        int positionCount = block.getPositionCount();
        try (BytesRefBlock.Builder builder = this.driverContext.blockFactory().newBytesRefBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                int valueCount = block.getValueCount(p);
                int start = block.getFirstValueIndex(p);
                int end = start + valueCount;
                boolean positionOpened = false;
                boolean valuesAppended = false;
                for (int i = start; i < end; ++i) {
                    BytesRef value = this.evalValue(block, i);
                    if (!positionOpened && valueCount > 1) {
                        builder.beginPositionEntry();
                        positionOpened = true;
                    }
                    builder.appendBytesRef(value);
                    valuesAppended = true;
                }
                if (!valuesAppended) {
                    builder.appendNull();
                    continue;
                }
                if (!positionOpened) continue;
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private BytesRef evalValue(FloatBlock container, int index) {
        float value = container.getFloat(index);
        return ToString.fromFloat(value);
    }

    public String toString() {
        return "ToStringFromFloatEvaluator[flt=" + String.valueOf(this.flt) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.flt);
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.flt.baseRamBytesUsed();
    }

    public static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory flt;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory flt) {
            this.source = source;
            this.flt = flt;
        }

        public ToStringFromFloatEvaluator get(DriverContext context) {
            return new ToStringFromFloatEvaluator(this.source, this.flt.get(context), context);
        }

        public String toString() {
            return "ToStringFromFloatEvaluator[flt=" + String.valueOf(this.flt) + "]";
        }
    }
}

