/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.datastreams.lifecycle;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.datastreams.lifecycle.ErrorEntry;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.health.node.DslErrorInfo;
import org.elasticsearch.health.node.ProjectIndexName;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class DataStreamLifecycleErrorStore {
    public static final int MAX_ERROR_MESSAGE_LENGTH = 1000;
    private final ConcurrentMap<ProjectId, ConcurrentMap<String, ErrorEntry>> projectMap = new ConcurrentHashMap<ProjectId, ConcurrentMap<String, ErrorEntry>>();
    private final LongSupplier nowSupplier;

    public DataStreamLifecycleErrorStore(LongSupplier nowSupplier) {
        this.nowSupplier = nowSupplier;
    }

    @Nullable
    public ErrorEntry recordError(ProjectId projectId, String indexName, Exception e) {
        String exceptionToString = Strings.toString((builder, params) -> {
            ElasticsearchException.generateThrowableXContent((XContentBuilder)builder, (ToXContent.Params)ToXContent.EMPTY_PARAMS, (Throwable)e);
            return builder;
        });
        String newError = Strings.substring((String)exceptionToString, (int)0, (int)1000);
        ConcurrentMap indexNameToError = this.projectMap.computeIfAbsent(projectId, k -> new ConcurrentHashMap());
        ErrorEntry existingError = (ErrorEntry)indexNameToError.get(indexName);
        long recordedTimestamp = this.nowSupplier.getAsLong();
        if (existingError == null) {
            indexNameToError.put(indexName, new ErrorEntry(recordedTimestamp, newError, recordedTimestamp, 0));
        } else if (existingError.error().equals(newError)) {
            indexNameToError.put(indexName, ErrorEntry.incrementRetryCount((ErrorEntry)existingError, (LongSupplier)this.nowSupplier));
        } else {
            indexNameToError.put(indexName, new ErrorEntry(recordedTimestamp, newError, recordedTimestamp, 0));
        }
        return existingError;
    }

    public void clearRecordedError(ProjectId projectId, String indexName) {
        ConcurrentMap indexNameToError = (ConcurrentMap)this.projectMap.get(projectId);
        if (indexNameToError == null) {
            return;
        }
        indexNameToError.remove(indexName);
    }

    public void clearStore() {
        this.projectMap.clear();
    }

    @Nullable
    public ErrorEntry getError(ProjectId projectId, String indexName) {
        ConcurrentMap indexNameToError = (ConcurrentMap)this.projectMap.get(projectId);
        if (indexNameToError == null) {
            return null;
        }
        return (ErrorEntry)indexNameToError.get(indexName);
    }

    public Set<String> getAllIndices(ProjectId projectId) {
        ConcurrentMap indexNameToError = (ConcurrentMap)this.projectMap.get(projectId);
        if (indexNameToError == null) {
            return Set.of();
        }
        return Set.copyOf(indexNameToError.keySet());
    }

    public List<DslErrorInfo> getErrorsInfo(Predicate<ErrorEntry> errorEntryPredicate, int limit) {
        return this.projectMap.entrySet().stream().flatMap(projectToIndexError -> ((ConcurrentMap)projectToIndexError.getValue()).entrySet().stream().map(indexToError -> new Tuple((Object)new ProjectIndexName((ProjectId)projectToIndexError.getKey(), (String)indexToError.getKey()), (Object)((ErrorEntry)indexToError.getValue())))).filter(projectIndexAndError -> errorEntryPredicate.test((ErrorEntry)projectIndexAndError.v2())).sorted(Comparator.comparing(Tuple::v2)).limit(limit).map(projectIndexAndError -> new DslErrorInfo(((ProjectIndexName)projectIndexAndError.v1()).indexName(), ((ErrorEntry)projectIndexAndError.v2()).firstOccurrenceTimestamp(), ((ErrorEntry)projectIndexAndError.v2()).retryCount(), ((ProjectIndexName)projectIndexAndError.v1()).projectId())).collect(Collectors.toList());
    }

    public int getTotalErrorEntries() {
        return this.projectMap.values().stream().mapToInt(Map::size).sum();
    }
}

