/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.xpack.logsdb.patterntext.Arg;

public class PatternTextValueProcessor {
    private static final Pattern DELIMITER = Pattern.compile("[\\s\\[\\]]");
    public static final int MAX_LOG_LEN_TO_STORE_AS_DOC_VALUE = 8192;

    public static int originalSize(String template, String[] args) {
        int size = template.length();
        for (String arg : args) {
            size += arg.length();
        }
        return size;
    }

    static String templateId(String template) {
        byte[] bytes = template.getBytes(StandardCharsets.UTF_8);
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128((byte[])bytes, (int)0, (int)bytes.length, (long)0L, (MurmurHash3.Hash128)hash);
        byte[] hashBytes = new byte[8];
        ByteUtils.writeLongLE((long)hash.h1, (byte[])hashBytes, (int)0);
        return Strings.BASE_64_NO_PADDING_URL_ENCODER.encodeToString(hashBytes);
    }

    static Parts split(String text) {
        if (text.length() > 8192) {
            return PatternTextValueProcessor.splitInternal(CharBuffer.wrap(text).subSequence(0, 8192), true);
        }
        return PatternTextValueProcessor.splitInternal(text, false);
    }

    static Parts splitInternal(CharSequence text, boolean exceedsMaxLength) {
        StringBuilder template = new StringBuilder(text.length());
        ArrayList<String> args = new ArrayList<String>();
        ArrayList<Arg.Info> argsInfo = new ArrayList<Arg.Info>();
        String[] tokens = DELIMITER.split(text);
        int textIndex = 0;
        for (String token : tokens) {
            if (token.isEmpty()) {
                if (textIndex >= text.length() - 1) continue;
                template.append(text.charAt(textIndex++));
                continue;
            }
            if (Arg.isArg(token)) {
                args.add(token);
                argsInfo.add(new Arg.Info(Arg.Type.GENERIC, template.length()));
            } else {
                template.append(token);
            }
            if ((textIndex += token.length()) >= text.length()) continue;
            template.append(text.charAt(textIndex++));
        }
        while (textIndex < text.length()) {
            template.append(text.charAt(textIndex++));
        }
        return exceedsMaxLength ? Parts.lengthExceeded(text.toString()) : new Parts(template.toString(), args, argsInfo);
    }

    public static String merge(Parts parts) {
        return PatternTextValueProcessor.merge(parts.template, (String[])parts.args.toArray(String[]::new), parts.argsInfo);
    }

    static String merge(String template, String[] args, List<Arg.Info> argsInfo) {
        StringBuilder builder = new StringBuilder(PatternTextValueProcessor.originalSize(template, args));
        int numArgs = args.length;
        int nextToWrite = 0;
        for (int i = 0; i < numArgs; ++i) {
            String arg = args[i];
            Arg.Info argInfo = argsInfo.get(i);
            builder.append(template, nextToWrite, argInfo.offsetInTemplate());
            builder.append(arg);
            nextToWrite = argInfo.offsetInTemplate();
        }
        if (nextToWrite < template.length()) {
            builder.append(template, nextToWrite, template.length());
        }
        return builder.toString();
    }

    public record Parts(String template, String templateId, List<String> args, List<Arg.Info> argsInfo, boolean useStoredField) {
        Parts(String template, List<String> args, List<Arg.Info> argsInfo) {
            this(template, PatternTextValueProcessor.templateId(template), args, argsInfo, false);
        }

        static Parts lengthExceeded(String template) {
            return new Parts(template, PatternTextValueProcessor.templateId(template), null, null, true);
        }
    }
}

