/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logsdb.patterntext;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BlockDocValuesReader;
import org.elasticsearch.index.mapper.blockloader.docvalues.BytesRefsFromCustomBinaryBlockLoader;
import org.elasticsearch.xpack.logsdb.patterntext.PatternTextFieldMapper;

public class PatternTextBlockLoader
extends BlockDocValuesReader.DocValuesBlockLoader {
    private final PatternTextFieldMapper.DocValuesSupplier docValuesSupplier;

    PatternTextBlockLoader(PatternTextFieldMapper.DocValuesSupplier docValuesSupplier) {
        this.docValuesSupplier = docValuesSupplier;
    }

    public BlockLoader.BytesRefBuilder builder(BlockLoader.BlockFactory factory, int expectedCount) {
        return factory.bytesRefs(expectedCount);
    }

    public BlockLoader.AllReader reader(LeafReaderContext context) throws IOException {
        BinaryDocValues docValues = this.docValuesSupplier.get(context.reader());
        if (docValues == null) {
            return new BlockLoader.ConstantNullsReader();
        }
        return new BytesRefsFromBinary(docValues);
    }

    public static class BytesRefsFromBinary
    extends BytesRefsFromCustomBinaryBlockLoader.AbstractBytesRefsFromBinary {
        public BytesRefsFromBinary(BinaryDocValues docValues) {
            super(docValues);
        }

        public void read(int doc, BlockLoader.BytesRefBuilder builder) throws IOException {
            if (!this.docValues.advanceExact(doc)) {
                builder.appendNull();
                return;
            }
            BytesRef bytes = this.docValues.binaryValue();
            builder.appendBytesRef(bytes);
        }

        public String toString() {
            return "BlockDocValuesReader.Bytes";
        }
    }
}

