/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import org.apache.lucene.search.LongValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.LeafNumericFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedNumericLongValues;
import org.elasticsearch.index.fielddata.plain.FormattedSortedNumericDocValues;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.ToScriptFieldFactory;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.xpack.unsignedlong.UnsignedLongFieldMapper;

public class UnsignedLongLeafFieldData
implements LeafNumericFieldData {
    private final LeafNumericFieldData signedLongFD;
    protected final ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory;

    UnsignedLongLeafFieldData(LeafNumericFieldData signedLongFD, ToScriptFieldFactory<SortedNumericLongValues> toScriptFieldFactory) {
        this.signedLongFD = signedLongFD;
        this.toScriptFieldFactory = toScriptFieldFactory;
    }

    public SortedNumericLongValues getLongValues() {
        return this.signedLongFD.getLongValues();
    }

    public SortedNumericDoubleValues getDoubleValues() {
        final SortedNumericLongValues values = this.signedLongFD.getLongValues();
        final LongValues singleValues = SortedNumericLongValues.unwrapSingleton((SortedNumericLongValues)values);
        if (singleValues != null) {
            return FieldData.singleton((NumericDoubleValues)new NumericDoubleValues(this){

                public boolean advanceExact(int doc) throws IOException {
                    return singleValues.advanceExact(doc);
                }

                public double doubleValue() throws IOException {
                    return UnsignedLongLeafFieldData.convertUnsignedLongToDouble(singleValues.longValue());
                }
            });
        }
        return new SortedNumericDoubleValues(this){

            public boolean advanceExact(int target) throws IOException {
                return values.advanceExact(target);
            }

            public double nextValue() throws IOException {
                return UnsignedLongLeafFieldData.convertUnsignedLongToDouble(values.nextValue());
            }

            public int docValueCount() {
                return values.docValueCount();
            }
        };
    }

    public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        return this.toScriptFieldFactory.getScriptFieldFactory((Object)this.getLongValues(), name);
    }

    public SortedBinaryDocValues getBytesValues() {
        return FieldData.toString((SortedNumericDoubleValues)this.getDoubleValues());
    }

    public long ramBytesUsed() {
        return this.signedLongFD.ramBytesUsed();
    }

    public void close() {
        this.signedLongFD.close();
    }

    public FormattedDocValues getFormattedValues(DocValueFormat format) {
        return new FormattedSortedNumericDocValues(this.getLongValues(), format);
    }

    static double convertUnsignedLongToDouble(long value) {
        if (value < 0L) {
            return UnsignedLongFieldMapper.sortableSignedLongToUnsigned(value);
        }
        return 9.223372036854776E18 + (double)value;
    }
}

