/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.gateway.GatewayService;

class TransformClusterStateListener
implements ClusterStateListener,
Supplier<Optional<ClusterState>> {
    private static final Logger logger = LogManager.getLogger(TransformClusterStateListener.class);
    private final Client client;
    private final AtomicBoolean isIndexCreationInProgress = new AtomicBoolean(false);
    private final AtomicReference<ClusterState> clusterState = new AtomicReference();

    TransformClusterStateListener(ClusterService clusterService, Client client) {
        this.client = client;
        clusterService.addListener((ClusterStateListener)this);
        logger.debug("Created TransformClusterStateListener");
    }

    public void clusterChanged(ClusterChangedEvent event) {
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            return;
        }
        this.clusterState.set(event.state());
    }

    @Override
    public Optional<ClusterState> get() {
        return Optional.ofNullable(this.clusterState.get());
    }
}

