/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.percolator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.sandbox.search.CoveringQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.hash.MurmurHash3;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.BinaryFieldMapper;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.IndexType;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.LuceneDocument;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.index.mapper.NumberFieldMapper;
import org.elasticsearch.index.mapper.RangeFieldMapper;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.FilteredSearchExecutionContext;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.percolator.BinaryRange;
import org.elasticsearch.percolator.PercolateQuery;
import org.elasticsearch.percolator.QueryAnalyzer;
import org.elasticsearch.xcontent.XContentParser;

public class PercolatorFieldMapper
extends FieldMapper {
    static final Setting<Boolean> INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING = Setting.boolSetting((String)"index.percolator.map_unmapped_fields_as_text", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope});
    static final String CONTENT_TYPE = "percolator";
    static final byte FIELD_VALUE_SEPARATOR = 0;
    static final String EXTRACTION_COMPLETE = "complete";
    static final String EXTRACTION_PARTIAL = "partial";
    static final String EXTRACTION_FAILED = "failed";
    static final String EXTRACTED_TERMS_FIELD_NAME = "extracted_terms";
    static final String EXTRACTION_RESULT_FIELD_NAME = "extraction_result";
    static final String QUERY_BUILDER_FIELD_NAME = "query_builder_field";
    static final String RANGE_FIELD_NAME = "range_field";
    static final String MINIMUM_SHOULD_MATCH_FIELD_NAME = "minimum_should_match_field";
    private final Supplier<SearchExecutionContext> searchExecutionContext;
    private final KeywordFieldMapper queryTermsField;
    private final KeywordFieldMapper extractionResultField;
    private final BinaryFieldMapper queryBuilderField;
    private final NumberFieldMapper minimumShouldMatchFieldMapper;
    private final RangeFieldMapper rangeFieldMapper;
    private final boolean mapUnmappedFieldsAsText;
    private final IndexVersion indexCreatedVersion;
    private final Supplier<TransportVersion> clusterTransportVersion;

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.searchExecutionContext, this.mapUnmappedFieldsAsText, this.indexCreatedVersion, this.clusterTransportVersion).init(this);
    }

    private static boolean getMapUnmappedFieldAsText(Settings indexSettings) {
        return (Boolean)INDEX_MAP_UNMAPPED_FIELDS_AS_TEXT_SETTING.get(indexSettings);
    }

    PercolatorFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, Supplier<SearchExecutionContext> searchExecutionContext, KeywordFieldMapper queryTermsField, KeywordFieldMapper extractionResultField, BinaryFieldMapper queryBuilderField, RangeFieldMapper rangeFieldMapper, NumberFieldMapper minimumShouldMatchFieldMapper, boolean mapUnmappedFieldsAsText, IndexVersion indexCreatedVersion, Supplier<TransportVersion> clusterTransportVersion) {
        super(simpleName, mappedFieldType, builderParams);
        this.searchExecutionContext = searchExecutionContext;
        this.queryTermsField = queryTermsField;
        this.extractionResultField = extractionResultField;
        this.queryBuilderField = queryBuilderField;
        this.minimumShouldMatchFieldMapper = minimumShouldMatchFieldMapper;
        this.rangeFieldMapper = rangeFieldMapper;
        this.mapUnmappedFieldsAsText = mapUnmappedFieldsAsText;
        this.indexCreatedVersion = indexCreatedVersion;
        this.clusterTransportVersion = clusterTransportVersion;
    }

    protected boolean supportsParsingObject() {
        return true;
    }

    public void parse(DocumentParserContext context) throws IOException {
        SearchExecutionContext executionContext = this.searchExecutionContext.get();
        if (context.doc().getField(this.queryBuilderField.fullPath()) != null) {
            throw new IllegalArgumentException("a document can only contain one percolator query");
        }
        executionContext = PercolatorFieldMapper.configureContext(executionContext, this.isMapUnmappedFieldAsText());
        QueryBuilder queryBuilder = PercolatorFieldMapper.parseQueryBuilder(context);
        PlainActionFuture future = new PlainActionFuture();
        Rewriteable.rewriteAndFetch((Rewriteable)queryBuilder, (QueryRewriteContext)executionContext, (ActionListener)future);
        queryBuilder = (QueryBuilder)future.actionGet();
        IndexVersion indexVersion = context.indexSettings().getIndexVersionCreated();
        PercolatorFieldMapper.createQueryBuilderField(indexVersion, this.clusterTransportVersion.get(), this.queryBuilderField, queryBuilder, context);
        QueryBuilder queryBuilderForProcessing = queryBuilder.rewrite((QueryRewriteContext)new SearchExecutionContext(executionContext));
        Query query = queryBuilderForProcessing.toQuery(executionContext);
        this.processQuery(query, context);
    }

    static QueryBuilder parseQueryBuilder(DocumentParserContext context) {
        XContentParser parser = context.parser();
        try {
            context.path().setWithinLeafObject(true);
            QueryBuilder queryBuilder = AbstractQueryBuilder.parseTopLevelQuery((XContentParser)parser, queryName -> {
                if (queryName.equals("has_child")) {
                    throw new IllegalArgumentException("the [has_child] query is unsupported inside a percolator query");
                }
                if (queryName.equals("has_parent")) {
                    throw new IllegalArgumentException("the [has_parent] query is unsupported inside a percolator query");
                }
                if (queryName.equals("knn")) {
                    throw new IllegalArgumentException("the [knn] query is unsupported inside a percolator query");
                }
            });
            return queryBuilder;
        }
        catch (IOException e) {
            throw new ParsingException(parser.getTokenLocation(), "Failed to parse", (Throwable)e, new Object[0]);
        }
        finally {
            context.path().setWithinLeafObject(false);
        }
    }

    static void createQueryBuilderField(IndexVersion indexVersion, TransportVersion clusterTransportVersion, BinaryFieldMapper qbField, QueryBuilder queryBuilder, DocumentParserContext context) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();
             OutputStreamStreamOutput out = new OutputStreamStreamOutput((OutputStream)stream);){
            if (indexVersion.before((VersionId)IndexVersions.V_8_8_0)) {
                out.setTransportVersion(TransportVersion.fromId((int)indexVersion.id()));
            } else {
                TransportVersion.writeVersion((TransportVersion)clusterTransportVersion, (StreamOutput)out);
                out.setTransportVersion(clusterTransportVersion);
            }
            out.writeNamedWriteable((NamedWriteable)queryBuilder);
            qbField.indexValue(context, stream.toByteArray());
        }
    }

    void processQuery(Query query, DocumentParserContext context) {
        LuceneDocument doc = context.doc();
        PercolatorFieldType pft = (PercolatorFieldType)this.fieldType();
        QueryAnalyzer.Result result = QueryAnalyzer.analyze(query);
        if (result == QueryAnalyzer.Result.UNKNOWN) {
            doc.add((IndexableField)new StringField(pft.extractionResultField.name(), EXTRACTION_FAILED, Field.Store.NO));
            return;
        }
        for (QueryAnalyzer.QueryExtraction extraction : result.extractions) {
            if (extraction.term != null) {
                BytesRefBuilder builder = new BytesRefBuilder();
                builder.append(new BytesRef((CharSequence)extraction.field()));
                builder.append((byte)0);
                builder.append(extraction.bytes());
                doc.add((IndexableField)new StringField(this.queryTermsField.fullPath(), builder.toBytesRef(), Field.Store.NO));
                continue;
            }
            if (extraction.range == null) continue;
            byte[] min = extraction.range.lowerPoint;
            byte[] max = extraction.range.upperPoint;
            doc.add((IndexableField)new BinaryRange(this.rangeFieldMapper.fullPath(), PercolatorFieldMapper.encodeRange(extraction.range.fieldName, min, max)));
        }
        if (result.matchAllDocs) {
            doc.add((IndexableField)new StringField(this.extractionResultField.fullPath(), EXTRACTION_FAILED, Field.Store.NO));
            if (result.verified) {
                doc.add((IndexableField)new StringField(this.extractionResultField.fullPath(), EXTRACTION_COMPLETE, Field.Store.NO));
            }
        } else if (result.verified) {
            doc.add((IndexableField)new StringField(this.extractionResultField.fullPath(), EXTRACTION_COMPLETE, Field.Store.NO));
        } else {
            doc.add((IndexableField)new StringField(this.extractionResultField.fullPath(), EXTRACTION_PARTIAL, Field.Store.NO));
        }
        context.addToFieldNames(this.fieldType().name());
        doc.add((IndexableField)new NumericDocValuesField(this.minimumShouldMatchFieldMapper.fullPath(), (long)result.minimumShouldMatch));
    }

    static SearchExecutionContext configureContext(SearchExecutionContext context, boolean mapUnmappedFieldsAsString) {
        SearchExecutionContext wrapped = PercolatorFieldMapper.wrapAllEmptyTextFields(context);
        wrapped.setAllowUnmappedFields(false);
        wrapped.setMapUnmappedFieldAsString(mapUnmappedFieldsAsString);
        wrapped.setRewriteToNamedQueries();
        return wrapped;
    }

    public Iterator<Mapper> iterator() {
        return Arrays.asList(this.queryTermsField, this.extractionResultField, this.queryBuilderField, this.minimumShouldMatchFieldMapper, this.rangeFieldMapper).iterator();
    }

    protected void parseCreateField(DocumentParserContext context) {
        throw new UnsupportedOperationException("should not be invoked");
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    boolean isMapUnmappedFieldAsText() {
        return this.mapUnmappedFieldsAsText;
    }

    static byte[] encodeRange(String rangeFieldName, byte[] minEncoded, byte[] maxEncoded) {
        assert (minEncoded.length == maxEncoded.length);
        byte[] bytes = new byte[32];
        BytesRef fieldAsBytesRef = new BytesRef((CharSequence)rangeFieldName);
        MurmurHash3.Hash128 hash = new MurmurHash3.Hash128();
        MurmurHash3.hash128((byte[])fieldAsBytesRef.bytes, (int)fieldAsBytesRef.offset, (int)fieldAsBytesRef.length, (long)0L, (MurmurHash3.Hash128)hash);
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.putLong(hash.h1).putLong(hash.h2).putLong(hash.h1).putLong(hash.h2);
        assert (bb.position() == bb.limit());
        int offset = 16 - minEncoded.length;
        System.arraycopy(minEncoded, 0, bytes, offset, minEncoded.length);
        System.arraycopy(maxEncoded, 0, bytes, 16 + offset, maxEncoded.length);
        return bytes;
    }

    static SearchExecutionContext wrapAllEmptyTextFields(SearchExecutionContext searchExecutionContext) {
        return new FilteredSearchExecutionContext(searchExecutionContext){

            public boolean fieldExistsInIndex(String fieldname) {
                return true;
            }
        };
    }

    static class Builder
    extends FieldMapper.Builder {
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final Supplier<SearchExecutionContext> searchExecutionContext;
        private final boolean mapUnmappedFieldsAsText;
        private final IndexVersion indexCreatedVersion;
        private final Supplier<TransportVersion> clusterTransportVersion;

        Builder(String fieldName, Supplier<SearchExecutionContext> searchExecutionContext, boolean mapUnmappedFieldsAsText, IndexVersion indexCreatedVersion, Supplier<TransportVersion> clusterTransportVersion) {
            super(fieldName);
            this.searchExecutionContext = searchExecutionContext;
            this.mapUnmappedFieldsAsText = mapUnmappedFieldsAsText;
            this.indexCreatedVersion = Objects.requireNonNull(indexCreatedVersion);
            this.clusterTransportVersion = clusterTransportVersion;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        public PercolatorFieldMapper build(MapperBuilderContext context) {
            PercolatorFieldType fieldType = new PercolatorFieldType(context.buildFullName(this.leafName()), (Map)this.meta.getValue());
            context = context.createChildContext(this.leafName(), null);
            KeywordFieldMapper extractedTermsField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTED_TERMS_FIELD_NAME, context, this.indexCreatedVersion);
            fieldType.queryTermsField = extractedTermsField.fieldType();
            KeywordFieldMapper extractionResultField = Builder.createExtractQueryFieldBuilder(PercolatorFieldMapper.EXTRACTION_RESULT_FIELD_NAME, context, this.indexCreatedVersion);
            fieldType.extractionResultField = extractionResultField.fieldType();
            BinaryFieldMapper queryBuilderField = Builder.createQueryBuilderFieldBuilder(context);
            fieldType.queryBuilderField = queryBuilderField.fieldType();
            RangeFieldMapper rangeFieldMapper = Builder.createExtractedRangeFieldBuilder(PercolatorFieldMapper.RANGE_FIELD_NAME, RangeType.IP, context);
            fieldType.rangeField = rangeFieldMapper.fieldType();
            NumberFieldMapper minimumShouldMatchFieldMapper = Builder.createMinimumShouldMatchField(context, this.indexCreatedVersion);
            fieldType.minimumShouldMatchField = minimumShouldMatchFieldMapper.fieldType();
            fieldType.mapUnmappedFieldsAsText = this.mapUnmappedFieldsAsText;
            return new PercolatorFieldMapper(this.leafName(), fieldType, this.builderParams((Mapper.Builder)this, context), this.searchExecutionContext, extractedTermsField, extractionResultField, queryBuilderField, rangeFieldMapper, minimumShouldMatchFieldMapper, this.mapUnmappedFieldsAsText, this.indexCreatedVersion, this.clusterTransportVersion);
        }

        static KeywordFieldMapper createExtractQueryFieldBuilder(String name, MapperBuilderContext context, IndexVersion indexCreatedVersion) {
            KeywordFieldMapper.Builder queryMetadataFieldBuilder = new KeywordFieldMapper.Builder(name, indexCreatedVersion);
            queryMetadataFieldBuilder.docValues(false);
            return queryMetadataFieldBuilder.build(context);
        }

        static BinaryFieldMapper createQueryBuilderFieldBuilder(MapperBuilderContext context) {
            BinaryFieldMapper.Builder builder = new BinaryFieldMapper.Builder(PercolatorFieldMapper.QUERY_BUILDER_FIELD_NAME, context.isSourceSynthetic()).docValues(true);
            return builder.build(context);
        }

        static RangeFieldMapper createExtractedRangeFieldBuilder(String name, RangeType rangeType, MapperBuilderContext context) {
            RangeFieldMapper.Builder builder = new RangeFieldMapper.Builder(name, rangeType, true);
            builder.docValues(false);
            return builder.build(context);
        }

        static NumberFieldMapper createMinimumShouldMatchField(MapperBuilderContext context, IndexVersion indexCreatedVersion) {
            NumberFieldMapper.Builder builder = NumberFieldMapper.Builder.docValuesOnly((String)PercolatorFieldMapper.MINIMUM_SHOULD_MATCH_FIELD_NAME, (NumberFieldMapper.NumberType)NumberFieldMapper.NumberType.INTEGER, (IndexVersion)indexCreatedVersion);
            return builder.build(context);
        }
    }

    static class PercolatorFieldType
    extends MappedFieldType {
        MappedFieldType queryTermsField;
        MappedFieldType extractionResultField;
        MappedFieldType queryBuilderField;
        MappedFieldType minimumShouldMatchField;
        RangeFieldMapper.RangeFieldType rangeField;
        boolean mapUnmappedFieldsAsText;

        private PercolatorFieldType(String name, Map<String, String> meta) {
            super(name, IndexType.NONE, false, meta);
        }

        public String typeName() {
            return PercolatorFieldMapper.CONTENT_TYPE;
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            throw new QueryShardException((QueryRewriteContext)context, "Percolator fields are not searchable directly, use a percolate query instead", new Object[0]);
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.identity((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        Query percolateQuery(String name, PercolateQuery.QueryStore queryStore, List<BytesReference> documents, IndexSearcher searcher, boolean excludeNestedDocuments, IndexVersion indexVersion) throws IOException {
            IndexReader indexReader = searcher.getIndexReader();
            Tuple<BooleanQuery, Boolean> t = this.createCandidateQuery(indexReader);
            Query candidateQuery = (Query)t.v1();
            boolean canUseMinimumShouldMatchField = (Boolean)t.v2();
            Object verifiedMatchesQuery = canUseMinimumShouldMatchField && indexReader.maxDoc() == 1 ? new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_COMPLETE)) : new MatchNoDocsQuery("multiple or nested docs or CoveringQuery could not be used");
            Query filter = null;
            if (excludeNestedDocuments) {
                filter = Queries.newNonNestedFilter((IndexVersion)indexVersion);
            }
            return new PercolateQuery(name, queryStore, documents, candidateQuery, searcher, filter, (Query)verifiedMatchesQuery);
        }

        Tuple<BooleanQuery, Boolean> createCandidateQuery(IndexReader indexReader) throws IOException {
            Tuple<List<BytesRef>, Map<String, List<byte[]>>> t = PercolatorFieldType.extractTermsAndRanges(indexReader);
            List extractedTerms = (List)t.v1();
            Map encodedPointValuesByField = (Map)t.v2();
            boolean canUseMinimumShouldMatchField = 1 + extractedTerms.size() + encodedPointValuesByField.size() <= IndexSearcher.getMaxClauseCount();
            ArrayList<Object> subQueries = new ArrayList<Object>();
            for (Map.Entry entry : encodedPointValuesByField.entrySet()) {
                String string = (String)entry.getKey();
                List encodedPointValues = (List)entry.getValue();
                byte[] min = (byte[])encodedPointValues.get(0);
                byte[] max = (byte[])encodedPointValues.get(1);
                Query query = BinaryRange.newIntersectsQuery(this.rangeField.name(), PercolatorFieldMapper.encodeRange(string, min, max));
                subQueries.add(query);
            }
            BooleanQuery.Builder candidateQuery = new BooleanQuery.Builder();
            if (canUseMinimumShouldMatchField) {
                LongValuesSource valuesSource = LongValuesSource.fromIntField((String)this.minimumShouldMatchField.name());
                for (BytesRef extractedTerm : extractedTerms) {
                    subQueries.add(new TermQuery(new Term(this.queryTermsField.name(), extractedTerm)));
                }
                candidateQuery.add((Query)new CoveringQuery(subQueries, valuesSource), BooleanClause.Occur.SHOULD);
            } else {
                candidateQuery.add((Query)new TermInSetQuery(this.queryTermsField.name(), (Collection)extractedTerms), BooleanClause.Occur.SHOULD);
                for (Query query : subQueries) {
                    candidateQuery.add(query, BooleanClause.Occur.SHOULD);
                }
            }
            candidateQuery.add((Query)new TermQuery(new Term(this.extractionResultField.name(), PercolatorFieldMapper.EXTRACTION_FAILED)), BooleanClause.Occur.SHOULD);
            return new Tuple((Object)candidateQuery.build(), (Object)canUseMinimumShouldMatchField);
        }

        static Tuple<List<BytesRef>, Map<String, List<byte[]>>> extractTermsAndRanges(IndexReader indexReader) throws IOException {
            ArrayList<BytesRef> extractedTerms = new ArrayList<BytesRef>();
            HashMap encodedPointValuesByField = new HashMap();
            LeafReader reader = ((LeafReaderContext)indexReader.leaves().get(0)).reader();
            for (FieldInfo info : reader.getFieldInfos()) {
                Terms terms = reader.terms(info.name);
                if (terms != null) {
                    BytesRef fieldBr = new BytesRef((CharSequence)info.name);
                    TermsEnum tenum = terms.iterator();
                    BytesRef term = tenum.next();
                    while (term != null) {
                        BytesRefBuilder builder = new BytesRefBuilder();
                        builder.append(fieldBr);
                        builder.append((byte)0);
                        builder.append(term);
                        extractedTerms.add(builder.toBytesRef());
                        term = tenum.next();
                    }
                }
                if (info.getPointIndexDimensionCount() != 1) continue;
                PointValues values = reader.getPointValues(info.name);
                ArrayList<byte[]> encodedPointValues = new ArrayList<byte[]>();
                encodedPointValues.add((byte[])values.getMinPackedValue().clone());
                encodedPointValues.add((byte[])values.getMaxPackedValue().clone());
                encodedPointValuesByField.put(info.name, encodedPointValues);
            }
            return new Tuple(extractedTerms, encodedPointValuesByField);
        }
    }

    static class TypeParser
    implements Mapper.TypeParser {
        TypeParser() {
        }

        public Builder parse(String name, Map<String, Object> node, MappingParserContext parserContext) throws MapperParsingException {
            return new Builder(name, parserContext.searchExecutionContext(), PercolatorFieldMapper.getMapUnmappedFieldAsText(parserContext.getSettings()), parserContext.indexVersionCreated(), parserContext.clusterTransportVersion());
        }
    }
}

