/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.telemetry.apm.internal.tracing;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapGetter;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.RegExp;
import org.elasticsearch.Build;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.lucene.util.automaton.MinimizationOperations;
import org.elasticsearch.telemetry.apm.internal.APMAgentSettings;
import org.elasticsearch.telemetry.tracing.TraceContext;
import org.elasticsearch.telemetry.tracing.Traceable;
import org.elasticsearch.telemetry.tracing.Tracer;

public class APMTracer
extends AbstractLifecycleComponent
implements Tracer {
    private static final Logger logger = LogManager.getLogger(APMTracer.class);
    private final Map<String, Context> spans = ConcurrentCollections.newConcurrentMap();
    private volatile boolean enabled;
    private volatile APMServices services;
    private List<String> includeNames;
    private List<String> excludeNames;
    private List<String> labelFilters;
    private volatile CharacterRunAutomaton filterAutomaton;
    private volatile CharacterRunAutomaton labelFilterAutomaton;
    private String clusterName;
    private String nodeName;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public APMTracer(Settings settings) {
        this.includeNames = (List)APMAgentSettings.TELEMETRY_TRACING_NAMES_INCLUDE_SETTING.get(settings);
        this.excludeNames = (List)APMAgentSettings.TELEMETRY_TRACING_NAMES_EXCLUDE_SETTING.get(settings);
        this.labelFilters = (List)APMAgentSettings.TELEMETRY_TRACING_SANITIZE_FIELD_NAMES.get(settings);
        this.filterAutomaton = APMTracer.buildAutomaton(this.includeNames, this.excludeNames);
        this.labelFilterAutomaton = APMTracer.buildAutomaton(this.labelFilters, List.of());
        this.enabled = (Boolean)APMAgentSettings.TELEMETRY_TRACING_ENABLED_SETTING.get(settings);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.services = this.createApmServices();
        } else {
            this.destroyApmServices();
        }
    }

    public void setIncludeNames(List<String> includeNames) {
        this.includeNames = includeNames;
        this.filterAutomaton = APMTracer.buildAutomaton(includeNames, this.excludeNames);
    }

    public void setExcludeNames(List<String> excludeNames) {
        this.excludeNames = excludeNames;
        this.filterAutomaton = APMTracer.buildAutomaton(this.includeNames, excludeNames);
    }

    public void setLabelFilters(List<String> labelFilters) {
        this.labelFilters = labelFilters;
        this.labelFilterAutomaton = APMTracer.buildAutomaton(labelFilters, List.of());
    }

    CharacterRunAutomaton getLabelFilterAutomaton() {
        return this.labelFilterAutomaton;
    }

    protected void doStart() {
        if (this.enabled) {
            this.services = this.createApmServices();
        }
    }

    protected void doStop() {
        this.destroyApmServices();
    }

    protected void doClose() {
    }

    APMServices createApmServices() {
        assert (this.enabled);
        assert (this.services == null);
        OpenTelemetry openTelemetry = GlobalOpenTelemetry.get();
        io.opentelemetry.api.trace.Tracer tracer = openTelemetry.getTracer("elasticsearch", Build.current().version());
        return new APMServices(tracer, openTelemetry);
    }

    private void destroyApmServices() {
        this.services = null;
        this.spans.clear();
    }

    public void startTrace(TraceContext traceContext, Traceable traceable, String spanName, @Nullable Map<String, Object> attributes) {
        assert (traceContext != null);
        String spanId = traceable.getSpanId();
        assert (spanId != null);
        assert (spanName != null);
        APMServices services = this.services;
        if (services == null) {
            return;
        }
        if (!this.filterAutomaton.run(spanName)) {
            logger.trace("Skipping tracing [{}] [{}] as it has been filtered out", (Object)spanId, (Object)spanName);
            return;
        }
        this.spans.computeIfAbsent(spanId, _spanId -> {
            logger.trace("Tracing [{}] [{}]", (Object)spanId, (Object)spanName);
            SpanBuilder spanBuilder = services.tracer.spanBuilder(spanName);
            Context parentContext = this.getParentContext(traceContext);
            if (parentContext != null) {
                spanBuilder.setParent(parentContext);
            }
            this.setSpanAttributes(traceContext, attributes, spanBuilder);
            Instant startTime = (Instant)traceContext.getTransient("trace.starttime");
            if (startTime != null) {
                spanBuilder.setStartTimestamp(startTime);
            }
            Span span = spanBuilder.startSpan();
            Context contextForNewSpan = Context.current().with((ImplicitContextKeyed)span);
            APMTracer.updateThreadContext(traceContext, services, contextForNewSpan);
            return contextForNewSpan;
        });
    }

    public void startTrace(String name, Map<String, Object> attributes) {
        APMServices services = this.services;
        if (services == null) {
            return;
        }
        SpanBuilder spanBuilder = services.tracer.spanBuilder(name);
        this.setSpanAttributes(attributes, spanBuilder);
        spanBuilder.startSpan();
    }

    private static void updateThreadContext(TraceContext traceContext, APMServices services, Context context) {
        traceContext.putTransient("apm.local.context", (Object)context);
        services.openTelemetry.getPropagators().getTextMapPropagator().inject(context, (Object)traceContext, (tc, key, value) -> {
            if (APMTracer.isSupportedContextKey(key)) {
                tc.putHeader(key, value);
            }
        });
    }

    private Context getParentContext(TraceContext traceContext) {
        Context parentContext = (Context)traceContext.getTransient("parent_apm.local.context");
        if (parentContext == null) {
            String traceParentHeader = (String)traceContext.getTransient("parent_traceparent");
            String traceStateHeader = (String)traceContext.getTransient("parent_tracestate");
            if (traceParentHeader != null) {
                Map traceContextMap = Maps.newMapWithExpectedSize((int)2);
                traceContextMap.put("traceparent", traceParentHeader);
                if (traceStateHeader != null) {
                    traceContextMap.put("tracestate", traceStateHeader);
                }
                parentContext = this.services.openTelemetry.getPropagators().getTextMapPropagator().extract(Context.current(), (Object)traceContextMap, (TextMapGetter)new MapKeyGetter());
            }
        }
        return parentContext;
    }

    public Releasable withScope(Traceable traceable) {
        Context context = this.spans.get(traceable.getSpanId());
        if (context != null) {
            return () -> ((Scope)context.makeCurrent()).close();
        }
        return () -> {};
    }

    private void setSpanAttributes(@Nullable Map<String, Object> spanAttributes, SpanBuilder spanBuilder) {
        if (spanAttributes != null) {
            for (Map.Entry<String, Object> entry : spanAttributes.entrySet()) {
                String key2 = entry.getKey();
                Object value = entry.getValue();
                if (this.labelFilterAutomaton.run(key2)) {
                    spanBuilder.setAttribute(key2, "[REDACTED]");
                    continue;
                }
                if (value instanceof String) {
                    spanBuilder.setAttribute(key2, (String)value);
                    continue;
                }
                if (value instanceof Long) {
                    spanBuilder.setAttribute(key2, ((Long)value).longValue());
                    continue;
                }
                if (value instanceof Integer) {
                    spanBuilder.setAttribute(key2, (long)((Integer)value).intValue());
                    continue;
                }
                if (value instanceof Double) {
                    spanBuilder.setAttribute(key2, ((Double)value).doubleValue());
                    continue;
                }
                if (value instanceof Boolean) {
                    spanBuilder.setAttribute(key2, ((Boolean)value).booleanValue());
                    continue;
                }
                if (value == null) {
                    throw new IllegalArgumentException("span attributes cannot have a null value");
                }
                throw new IllegalArgumentException("span attributes do not support value type of [" + value.getClass().getCanonicalName() + "]");
            }
            boolean isHttpSpan = spanAttributes.keySet().stream().anyMatch(key -> key.startsWith("http."));
            spanBuilder.setSpanKind(isHttpSpan ? SpanKind.SERVER : SpanKind.INTERNAL);
        } else {
            spanBuilder.setSpanKind(SpanKind.INTERNAL);
        }
        spanBuilder.setAttribute("es.node.name", this.nodeName);
        spanBuilder.setAttribute("es.cluster.name", this.clusterName);
    }

    private void setSpanAttributes(TraceContext traceContext, @Nullable Map<String, Object> spanAttributes, SpanBuilder spanBuilder) {
        this.setSpanAttributes(spanAttributes, spanBuilder);
        String xOpaqueId = traceContext.getHeader("X-Opaque-Id");
        if (xOpaqueId != null) {
            spanBuilder.setAttribute("es.x-opaque-id", xOpaqueId);
        }
    }

    public void addError(Traceable traceable, Throwable throwable) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.recordException(throwable);
        }
    }

    public void setAttribute(Traceable traceable, String key, boolean value) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.setAttribute(key, value);
        }
    }

    public void setAttribute(Traceable traceable, String key, double value) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.setAttribute(key, value);
        }
    }

    public void setAttribute(Traceable traceable, String key, long value) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.setAttribute(key, value);
        }
    }

    public void setAttribute(Traceable traceable, String key, String value) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.setAttribute(key, value);
        }
    }

    public void stopTrace(Traceable traceable) {
        Span span = Span.fromContextOrNull((Context)this.spans.remove(traceable.getSpanId()));
        if (span != null) {
            logger.trace("Finishing trace [{}]", (Object)traceable);
            span.end();
        }
    }

    public void stopTrace() {
        Span.current().end();
    }

    public void addEvent(Traceable traceable, String eventName) {
        Span span = Span.fromContextOrNull((Context)this.spans.get(traceable.getSpanId()));
        if (span != null) {
            span.addEvent(eventName);
        }
    }

    private static boolean isSupportedContextKey(String key) {
        return "traceparent".equals(key) || "tracestate".equals(key);
    }

    Map<String, Context> getSpans() {
        return this.spans;
    }

    private static CharacterRunAutomaton buildAutomaton(List<String> includePatterns, List<String> excludePatterns) {
        Automaton includeAutomaton = APMTracer.patternsToAutomaton(includePatterns);
        Automaton excludeAutomaton = APMTracer.patternsToAutomaton(excludePatterns);
        if (includeAutomaton == null) {
            includeAutomaton = Automata.makeAnyString();
        }
        Automaton finalAutomaton = excludeAutomaton == null ? includeAutomaton : Operations.minus((Automaton)includeAutomaton, (Automaton)excludeAutomaton, (int)10000);
        return new CharacterRunAutomaton(MinimizationOperations.minimize((Automaton)finalAutomaton, (int)10000));
    }

    private static Automaton patternsToAutomaton(List<String> patterns) {
        List<Automaton> automata = patterns.stream().map(s -> {
            String regex = s.replace(".", "\\.").replace("*", ".*");
            return new RegExp(regex, 65791).toAutomaton();
        }).toList();
        if (automata.isEmpty()) {
            return null;
        }
        if (automata.size() == 1) {
            return automata.get(0);
        }
        return Operations.union(automata);
    }

    record APMServices(io.opentelemetry.api.trace.Tracer tracer, OpenTelemetry openTelemetry) {
    }

    private static class MapKeyGetter
    implements TextMapGetter<Map<String, String>> {
        private MapKeyGetter() {
        }

        public Iterable<String> keys(Map<String, String> carrier) {
            return carrier.keySet().stream().filter(APMTracer::isSupportedContextKey).collect(Collectors.toSet());
        }

        public String get(Map<String, String> carrier, String key) {
            return carrier.get(key);
        }
    }
}

