/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalLong;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.exponentialhistogram.AbstractExponentialHistogram;
import org.elasticsearch.exponentialhistogram.BucketArrayIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.RamEstimationUtil;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

final class FixedCapacityExponentialHistogram
extends AbstractExponentialHistogram
implements ReleasableExponentialHistogram {
    static final long BASE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FixedCapacityExponentialHistogram.class) + ZeroBucket.SHALLOW_SIZE + 2L * Buckets.SHALLOW_SIZE;
    private final long[] bucketIndices;
    private final long[] bucketCounts;
    private int bucketScale;
    private final Buckets negativeBuckets = new Buckets(false);
    private ZeroBucket zeroBucket;
    private final Buckets positiveBuckets = new Buckets(true);
    private double sum;
    private double min;
    private double max;
    private final ExponentialHistogramCircuitBreaker circuitBreaker;
    private boolean closed = false;

    static FixedCapacityExponentialHistogram create(int bucketCapacity, ExponentialHistogramCircuitBreaker circuitBreaker) {
        circuitBreaker.adjustBreaker(FixedCapacityExponentialHistogram.estimateSize(bucketCapacity));
        return new FixedCapacityExponentialHistogram(bucketCapacity, circuitBreaker);
    }

    private FixedCapacityExponentialHistogram(int bucketCapacity, ExponentialHistogramCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        this.bucketIndices = new long[bucketCapacity];
        this.bucketCounts = new long[bucketCapacity];
        this.reset();
    }

    int getCapacity() {
        return this.bucketIndices.length;
    }

    void reset() {
        this.sum = 0.0;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.setZeroBucket(ZeroBucket.minimalEmpty());
        this.resetBuckets(38);
    }

    void resetBuckets(int scale) {
        this.setScale(scale);
        this.negativeBuckets.reset();
        this.positiveBuckets.reset();
    }

    @Override
    public ZeroBucket zeroBucket() {
        return this.zeroBucket;
    }

    void setZeroBucket(ZeroBucket zeroBucket) {
        this.zeroBucket = zeroBucket;
    }

    @Override
    public double sum() {
        return this.sum;
    }

    void setSum(double sum) {
        this.sum = sum;
    }

    @Override
    public double min() {
        return this.min;
    }

    void setMin(double min) {
        this.min = min;
    }

    @Override
    public double max() {
        return this.max;
    }

    void setMax(double max) {
        this.max = max;
    }

    boolean tryAddBucket(long index, long count, boolean isPositive) {
        assert (index >= -4611686018427387903L && index <= 0x3FFFFFFFFFFFFFFFL) : "index must be in range [-4611686018427387903..4611686018427387903]";
        assert (isPositive || this.positiveBuckets.numBuckets == 0) : "Cannot add negative buckets after a positive bucket has been added";
        assert (count > 0L) : "Cannot add a bucket with empty or negative count";
        if (isPositive) {
            return this.positiveBuckets.tryAddBucket(index, count);
        }
        return this.negativeBuckets.tryAddBucket(index, count);
    }

    @Override
    public int scale() {
        return this.bucketScale;
    }

    void setScale(int scale) {
        assert (scale >= -11 && scale <= 38) : "scale must be in range [-11..38]";
        this.bucketScale = scale;
    }

    @Override
    public ExponentialHistogram.Buckets negativeBuckets() {
        return this.negativeBuckets;
    }

    @Override
    public ExponentialHistogram.Buckets positiveBuckets() {
        return this.positiveBuckets;
    }

    long getLastAddedBucketIndex() {
        if (this.positiveBuckets.numBuckets + this.negativeBuckets.numBuckets > 0) {
            return this.bucketIndices[this.negativeBuckets.numBuckets + this.positiveBuckets.numBuckets - 1];
        }
        return Long.MIN_VALUE;
    }

    boolean wasLastAddedBucketPositive() {
        return this.positiveBuckets.numBuckets > 0;
    }

    public void close() {
        if (this.closed) {
            assert (false) : "FixedCapacityExponentialHistogram closed multiple times";
        } else {
            this.closed = true;
            this.circuitBreaker.adjustBreaker(-this.ramBytesUsed());
        }
    }

    static long estimateSize(int bucketCapacity) {
        return BASE_SIZE + 2L * RamEstimationUtil.estimateLongArray(bucketCapacity);
    }

    public long ramBytesUsed() {
        return FixedCapacityExponentialHistogram.estimateSize(this.bucketIndices.length);
    }

    private class Buckets
    implements ExponentialHistogram.Buckets {
        static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(Buckets.class);
        private final boolean isPositive;
        private int numBuckets;
        private int cachedValueSumForNumBuckets;
        private long cachedValueSum;

        Buckets(boolean isPositive) {
            this.isPositive = isPositive;
            this.reset();
        }

        int startSlot() {
            return this.isPositive ? FixedCapacityExponentialHistogram.this.negativeBuckets.numBuckets : 0;
        }

        final void reset() {
            this.numBuckets = 0;
            this.cachedValueSumForNumBuckets = 0;
            this.cachedValueSum = 0L;
        }

        boolean tryAddBucket(long index, long count) {
            int slot = this.startSlot() + this.numBuckets;
            assert (this.numBuckets == 0 || FixedCapacityExponentialHistogram.this.bucketIndices[slot - 1] < index) : "Histogram buckets must be added with their indices in ascending order";
            if (slot >= FixedCapacityExponentialHistogram.this.bucketCounts.length) {
                return false;
            }
            FixedCapacityExponentialHistogram.this.bucketIndices[slot] = index;
            FixedCapacityExponentialHistogram.this.bucketCounts[slot] = count;
            ++this.numBuckets;
            return true;
        }

        @Override
        public CopyableBucketIterator iterator() {
            int start = this.startSlot();
            return new BucketArrayIterator(FixedCapacityExponentialHistogram.this.bucketScale, FixedCapacityExponentialHistogram.this.bucketCounts, FixedCapacityExponentialHistogram.this.bucketIndices, start, start + this.numBuckets);
        }

        @Override
        public OptionalLong maxBucketIndex() {
            if (this.numBuckets == 0) {
                return OptionalLong.empty();
            }
            return OptionalLong.of(FixedCapacityExponentialHistogram.this.bucketIndices[this.startSlot() + this.numBuckets - 1]);
        }

        @Override
        public long valueCount() {
            int startSlot = this.startSlot();
            while (this.cachedValueSumForNumBuckets < this.numBuckets) {
                this.cachedValueSum += FixedCapacityExponentialHistogram.this.bucketCounts[startSlot + this.cachedValueSumForNumBuckets];
                ++this.cachedValueSumForNumBuckets;
            }
            return this.cachedValueSum;
        }

        @Override
        public int bucketCount() {
            return this.numBuckets;
        }
    }
}

