/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.io.IOException;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExponentialHistogramXContent {
    public static final String SCALE_FIELD = "scale";
    public static final String SUM_FIELD = "sum";
    public static final String MIN_FIELD = "min";
    public static final String MAX_FIELD = "max";
    public static final String ZERO_FIELD = "zero";
    public static final String ZERO_COUNT_FIELD = "count";
    public static final String ZERO_THRESHOLD_FIELD = "threshold";
    public static final String POSITIVE_FIELD = "positive";
    public static final String NEGATIVE_FIELD = "negative";
    public static final String BUCKET_INDICES_FIELD = "indices";
    public static final String BUCKET_COUNTS_FIELD = "counts";

    public static void serialize(XContentBuilder builder, ExponentialHistogram histogram) throws IOException {
        builder.startObject();
        builder.field(SCALE_FIELD, histogram.scale());
        builder.field(SUM_FIELD, histogram.sum());
        if (!Double.isNaN(histogram.min())) {
            builder.field(MIN_FIELD, histogram.min());
        }
        if (!Double.isNaN(histogram.max())) {
            builder.field(MAX_FIELD, histogram.max());
        }
        double zeroThreshold = histogram.zeroBucket().zeroThreshold();
        long zeroCount = histogram.zeroBucket().count();
        if (zeroCount != 0L || zeroThreshold != 0.0) {
            builder.startObject(ZERO_FIELD);
            if (zeroCount != 0L) {
                builder.field(ZERO_COUNT_FIELD, zeroCount);
            }
            if (zeroThreshold != 0.0) {
                builder.field(ZERO_THRESHOLD_FIELD, zeroThreshold);
            }
            builder.endObject();
        }
        ExponentialHistogramXContent.writeBuckets(builder, POSITIVE_FIELD, histogram.positiveBuckets());
        ExponentialHistogramXContent.writeBuckets(builder, NEGATIVE_FIELD, histogram.negativeBuckets());
        builder.endObject();
    }

    private static void writeBuckets(XContentBuilder b, String fieldName, ExponentialHistogram.Buckets buckets) throws IOException {
        if (!buckets.iterator().hasNext()) {
            return;
        }
        b.startObject(fieldName);
        CopyableBucketIterator it = buckets.iterator();
        b.startArray(BUCKET_INDICES_FIELD);
        while (it.hasNext()) {
            b.value(it.peekIndex());
            it.advance();
        }
        b.endArray();
        it = buckets.iterator();
        b.startArray(BUCKET_COUNTS_FIELD);
        while (it.hasNext()) {
            b.value(it.peekCount());
            it.advance();
        }
        b.endArray();
        b.endObject();
    }
}

