/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalDouble;
import java.util.OptionalLong;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.exponentialhistogram.MergingBucketIterator;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramUtils {
    public static double estimateSum(BucketIterator negativeBuckets, BucketIterator positiveBuckets) {
        assert (negativeBuckets.scale() == positiveBuckets.scale());
        MergingBucketIterator it = new MergingBucketIterator(positiveBuckets, negativeBuckets, positiveBuckets.scale(), (positiveCount, negativeCount) -> positiveCount - negativeCount);
        double sum = 0.0;
        while (it.hasNext()) {
            long countWithSign = it.peekCount();
            double bucketMidPoint = ExponentialScaleUtils.getPointOfLeastRelativeError(it.peekIndex(), it.scale());
            if (countWithSign != 0L) {
                double toAdd = bucketMidPoint * (double)countWithSign;
                sum = Double.isFinite(toAdd) ? (sum += toAdd) : toAdd;
            }
            it.advance();
        }
        return sum;
    }

    public static OptionalDouble estimateMin(ZeroBucket zeroBucket, ExponentialHistogram.Buckets negativeBuckets, ExponentialHistogram.Buckets positiveBuckets) {
        int scale = negativeBuckets.iterator().scale();
        assert (scale == positiveBuckets.iterator().scale());
        OptionalLong negativeMaxIndex = negativeBuckets.maxBucketIndex();
        if (negativeMaxIndex.isPresent()) {
            return OptionalDouble.of(-ExponentialScaleUtils.getUpperBucketBoundary(negativeMaxIndex.getAsLong(), scale));
        }
        if (zeroBucket.count() > 0L) {
            if (zeroBucket.zeroThreshold() == 0.0) {
                return OptionalDouble.of(0.0);
            }
            return OptionalDouble.of(-zeroBucket.zeroThreshold());
        }
        CopyableBucketIterator positiveBucketsIt = positiveBuckets.iterator();
        if (positiveBucketsIt.hasNext()) {
            return OptionalDouble.of(ExponentialScaleUtils.getLowerBucketBoundary(positiveBucketsIt.peekIndex(), scale));
        }
        return OptionalDouble.empty();
    }

    public static OptionalDouble estimateMax(ZeroBucket zeroBucket, ExponentialHistogram.Buckets negativeBuckets, ExponentialHistogram.Buckets positiveBuckets) {
        int scale = negativeBuckets.iterator().scale();
        assert (scale == positiveBuckets.iterator().scale());
        OptionalLong positiveMaxIndex = positiveBuckets.maxBucketIndex();
        if (positiveMaxIndex.isPresent()) {
            return OptionalDouble.of(ExponentialScaleUtils.getUpperBucketBoundary(positiveMaxIndex.getAsLong(), scale));
        }
        if (zeroBucket.count() > 0L) {
            return OptionalDouble.of(zeroBucket.zeroThreshold());
        }
        CopyableBucketIterator negativeBucketsIt = negativeBuckets.iterator();
        if (negativeBucketsIt.hasNext()) {
            return OptionalDouble.of(-ExponentialScaleUtils.getLowerBucketBoundary(negativeBucketsIt.peekIndex(), scale));
        }
        return OptionalDouble.empty();
    }
}

