/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.util.OptionalLong;
import java.util.function.DoubleBinaryOperator;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.exponentialhistogram.BucketIterator;
import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;
import org.elasticsearch.exponentialhistogram.DownscaleStats;
import org.elasticsearch.exponentialhistogram.ExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ExponentialHistogramCircuitBreaker;
import org.elasticsearch.exponentialhistogram.ExponentialScaleUtils;
import org.elasticsearch.exponentialhistogram.FixedCapacityExponentialHistogram;
import org.elasticsearch.exponentialhistogram.MergingBucketIterator;
import org.elasticsearch.exponentialhistogram.ReleasableExponentialHistogram;
import org.elasticsearch.exponentialhistogram.ZeroBucket;

public class ExponentialHistogramMerger
implements Accountable,
Releasable {
    private static final long BASE_SIZE = RamUsageEstimator.shallowSizeOfInstance(ExponentialHistogramMerger.class) + DownscaleStats.SIZE;
    @Nullable
    private FixedCapacityExponentialHistogram result;
    @Nullable
    private FixedCapacityExponentialHistogram buffer;
    private final int bucketLimit;
    private final int maxScale;
    private final DownscaleStats downscaleStats;
    private final ExponentialHistogramCircuitBreaker circuitBreaker;
    private boolean closed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExponentialHistogramMerger create(int bucketLimit, ExponentialHistogramCircuitBreaker circuitBreaker) {
        circuitBreaker.adjustBreaker(BASE_SIZE);
        boolean success = false;
        try {
            ExponentialHistogramMerger result = new ExponentialHistogramMerger(bucketLimit, circuitBreaker);
            success = true;
            ExponentialHistogramMerger exponentialHistogramMerger = result;
            return exponentialHistogramMerger;
        }
        finally {
            if (!success) {
                circuitBreaker.adjustBreaker(-BASE_SIZE);
            }
        }
    }

    private ExponentialHistogramMerger(int bucketLimit, ExponentialHistogramCircuitBreaker circuitBreaker) {
        this(bucketLimit, 38, circuitBreaker);
    }

    private ExponentialHistogramMerger(int bucketLimit, int maxScale, ExponentialHistogramCircuitBreaker circuitBreaker) {
        if (bucketLimit < 4) {
            throw new IllegalArgumentException("The bucket limit must be at least 4");
        }
        this.bucketLimit = bucketLimit;
        this.maxScale = maxScale;
        this.circuitBreaker = circuitBreaker;
        this.downscaleStats = new DownscaleStats();
    }

    public static ExponentialHistogramMerger createWithMaxScale(int bucketLimit, int maxScale, ExponentialHistogramCircuitBreaker circuitBreaker) {
        circuitBreaker.adjustBreaker(BASE_SIZE);
        return new ExponentialHistogramMerger(bucketLimit, maxScale, circuitBreaker);
    }

    public void close() {
        if (this.closed) {
            assert (false) : "ExponentialHistogramMerger closed multiple times";
        } else {
            this.closed = true;
            if (this.result != null) {
                this.result.close();
                this.result = null;
            }
            if (this.buffer != null) {
                this.buffer.close();
                this.buffer = null;
            }
            this.circuitBreaker.adjustBreaker(-BASE_SIZE);
        }
    }

    public long ramBytesUsed() {
        long size = BASE_SIZE;
        if (this.result != null) {
            size += this.result.ramBytesUsed();
        }
        if (this.buffer != null) {
            size += this.buffer.ramBytesUsed();
        }
        return size;
    }

    public ReleasableExponentialHistogram getAndClear() {
        assert (!this.closed) : "ExponentialHistogramMerger already closed";
        ReleasableExponentialHistogram retVal = this.result == null ? ReleasableExponentialHistogram.empty() : this.result;
        this.result = null;
        return retVal;
    }

    public ExponentialHistogram get() {
        assert (!this.closed) : "ExponentialHistogramMerger already closed";
        return this.result == null ? ExponentialHistogram.empty() : this.result;
    }

    public void add(ExponentialHistogram toAdd) {
        ExponentialHistogram a = this.result == null ? ExponentialHistogram.empty() : this.result;
        ExponentialHistogram b = toAdd;
        CopyableBucketIterator posBucketsA = a.positiveBuckets().iterator();
        CopyableBucketIterator negBucketsA = a.negativeBuckets().iterator();
        CopyableBucketIterator posBucketsB = b.positiveBuckets().iterator();
        CopyableBucketIterator negBucketsB = b.negativeBuckets().iterator();
        ZeroBucket zeroBucket = a.zeroBucket().merge(b.zeroBucket());
        zeroBucket = zeroBucket.collapseOverlappingBucketsForAll(posBucketsA, negBucketsA, posBucketsB, negBucketsB);
        if (this.buffer == null) {
            this.buffer = FixedCapacityExponentialHistogram.create(this.bucketLimit, this.circuitBreaker);
        }
        this.buffer.setZeroBucket(zeroBucket);
        this.buffer.setSum(a.sum() + b.sum());
        this.buffer.setMin(ExponentialHistogramMerger.nanAwareAggregate(a.min(), b.min(), Math::min));
        this.buffer.setMax(ExponentialHistogramMerger.nanAwareAggregate(a.max(), b.max(), Math::max));
        int targetScale = Math.min(this.maxScale, a.scale());
        if (targetScale > b.scale()) {
            int maxScaleIncrease;
            OptionalLong maximumIndex;
            long smallestIndex;
            if (negBucketsB.hasNext()) {
                smallestIndex = negBucketsB.peekIndex();
                maximumIndex = b.negativeBuckets().maxBucketIndex();
                assert (maximumIndex.isPresent()) : "We checked that the negative bucket range is not empty, therefore the maximum index should be present";
                maxScaleIncrease = Math.min(ExponentialScaleUtils.getMaximumScaleIncrease(smallestIndex), ExponentialScaleUtils.getMaximumScaleIncrease(maximumIndex.getAsLong()));
                targetScale = Math.min(targetScale, b.scale() + maxScaleIncrease);
            }
            if (posBucketsB.hasNext()) {
                smallestIndex = posBucketsB.peekIndex();
                maximumIndex = b.positiveBuckets().maxBucketIndex();
                assert (maximumIndex.isPresent()) : "We checked that the positive bucket range is not empty, therefore the maximum index should be present";
                maxScaleIncrease = Math.min(ExponentialScaleUtils.getMaximumScaleIncrease(smallestIndex), ExponentialScaleUtils.getMaximumScaleIncrease(maximumIndex.getAsLong()));
                targetScale = Math.min(targetScale, b.scale() + maxScaleIncrease);
            }
        }
        MergingBucketIterator positiveMerged = new MergingBucketIterator(posBucketsA.copy(), posBucketsB.copy(), targetScale);
        MergingBucketIterator negativeMerged = new MergingBucketIterator(negBucketsA.copy(), negBucketsB.copy(), targetScale);
        this.buffer.resetBuckets(targetScale);
        this.downscaleStats.reset();
        int overflowCount = ExponentialHistogramMerger.putBuckets(this.buffer, negativeMerged, false, this.downscaleStats);
        if ((overflowCount += ExponentialHistogramMerger.putBuckets(this.buffer, positiveMerged, true, this.downscaleStats)) > 0) {
            int reduction = this.downscaleStats.getRequiredScaleReductionToReduceBucketCountBy(overflowCount);
            this.buffer.resetBuckets(targetScale -= reduction);
            positiveMerged = new MergingBucketIterator(posBucketsA, posBucketsB, targetScale);
            negativeMerged = new MergingBucketIterator(negBucketsA, negBucketsB, targetScale);
            overflowCount = ExponentialHistogramMerger.putBuckets(this.buffer, negativeMerged, false, null);
            assert ((overflowCount += ExponentialHistogramMerger.putBuckets(this.buffer, positiveMerged, true, null)) == 0) : "Should never happen, the histogram should have had enough space";
        }
        FixedCapacityExponentialHistogram temp = this.result;
        this.result = this.buffer;
        this.buffer = temp;
    }

    private static int putBuckets(FixedCapacityExponentialHistogram output, BucketIterator buckets, boolean isPositive, DownscaleStats downscaleStats) {
        boolean collectDownScaleStatsOnNext = false;
        long prevIndex = 0L;
        int overflowCount = 0;
        while (buckets.hasNext()) {
            long idx = buckets.peekIndex();
            if (collectDownScaleStatsOnNext) {
                downscaleStats.add(prevIndex, idx);
            } else {
                boolean bl = collectDownScaleStatsOnNext = downscaleStats != null;
            }
            if (!output.tryAddBucket(idx, buckets.peekCount(), isPositive)) {
                ++overflowCount;
            }
            prevIndex = idx;
            buckets.advance();
        }
        return overflowCount;
    }

    private static double nanAwareAggregate(double a, double b, DoubleBinaryOperator aggregator) {
        if (Double.isNaN(a)) {
            return b;
        }
        if (Double.isNaN(b)) {
            return a;
        }
        return aggregator.applyAsDouble(a, b);
    }
}

