/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.exponentialhistogram.BucketIterator;

final class CompressedHistogramData {
    static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(CompressedHistogramData.class);
    private static final int SCALE_OFFSET = 11;
    private static final int HAS_NEGATIVE_BUCKETS_FLAG = 64;
    private static final int SCALE_MASK = 63;
    private int scale;
    private byte[] encodedData;
    private int negativeBucketsStart;
    private int negativeBucketsLength;
    private int positiveBucketsLength;

    CompressedHistogramData() {
    }

    void decode(BytesRef data) {
        this.encodedData = data.bytes;
        AccessibleByteArrayStreamInput input = new AccessibleByteArrayStreamInput(data.bytes, data.offset, data.length);
        int scaleWithFlags = input.read();
        this.scale = (scaleWithFlags & 0x3F) - 11;
        boolean hasNegativeBuckets = (scaleWithFlags & 0x40) != 0;
        this.negativeBucketsLength = 0;
        if (hasNegativeBuckets) {
            this.negativeBucketsLength = (int)input.readVLong();
        }
        this.negativeBucketsStart = input.getPosition();
        input.skip(this.negativeBucketsLength);
        this.positiveBucketsLength = input.available();
    }

    static void write(OutputStream output, int scale, BucketIterator negativeBuckets, BucketIterator positiveBuckets) throws IOException {
        assert (scale >= -11 && scale <= 38) : "scale must be in range [-11, 38]";
        boolean hasNegativeBuckets = negativeBuckets.hasNext();
        int scaleWithFlags = scale + 11;
        assert (scaleWithFlags >= 0 && scaleWithFlags <= 63);
        if (hasNegativeBuckets) {
            scaleWithFlags |= 0x40;
        }
        output.write((byte)scaleWithFlags);
        if (hasNegativeBuckets) {
            ByteArrayOutputStream temp = new ByteArrayOutputStream();
            BucketsDecoder.serializeBuckets(temp, negativeBuckets);
            byte[] data = temp.toByteArray();
            CompressedHistogramData.writeVLong(data.length, output);
            output.write(data);
        }
        BucketsDecoder.serializeBuckets(output, positiveBuckets);
    }

    int scale() {
        return this.scale;
    }

    BucketsDecoder negativeBucketsDecoder() {
        return new BucketsDecoder(this.negativeBucketsStart, this.negativeBucketsLength);
    }

    BucketsDecoder positiveBucketsDecoder() {
        return new BucketsDecoder(this.negativeBucketsStart + this.negativeBucketsLength, this.positiveBucketsLength);
    }

    private static void writeZLong(long i, OutputStream output) throws IOException {
        CompressedHistogramData.writeVLong(BitUtil.zigZagEncode((long)i), output);
    }

    private static void writeVLong(long i, OutputStream output) throws IOException {
        while ((i & 0xFFFFFFFFFFFFFF80L) != 0L) {
            output.write((byte)(i & 0x7FL | 0x80L));
            i >>>= 7;
        }
        output.write((byte)i);
    }

    private static class AccessibleByteArrayStreamInput
    extends ByteArrayInputStream {
        AccessibleByteArrayStreamInput(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        int getPosition() {
            return this.pos;
        }

        int getLimit() {
            return this.count;
        }

        long readZLong() {
            return BitUtil.zigZagDecode((long)this.readVLong());
        }

        long readVLong() {
            byte b = (byte)this.read();
            long i = (long)b & 0x7FL;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 7;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 14;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 21;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 28;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 35;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 42;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 49;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            i |= ((long)b & 0x7FL) << 56;
            if ((b & 0x80) == 0) {
                return i;
            }
            b = (byte)this.read();
            if (b != 0 && b != 1) {
                throw new IllegalStateException("Broken VLong detected");
            }
            return i |= (long)b << 63;
        }
    }

    final class BucketsDecoder {
        private long currentIndex;
        private long currentCount;
        private final AccessibleByteArrayStreamInput bucketsStreamInput;

        private BucketsDecoder(int encodedBucketsStartOffset, int length) {
            if (length > 0) {
                this.bucketsStreamInput = new AccessibleByteArrayStreamInput(CompressedHistogramData.this.encodedData, encodedBucketsStartOffset, length);
                this.currentIndex = this.bucketsStreamInput.readZLong() - 1L;
                this.currentCount = 0L;
                this.advance();
            } else {
                this.bucketsStreamInput = null;
                this.markEndReached();
            }
        }

        private BucketsDecoder(BucketsDecoder toCopy) {
            if (toCopy.bucketsStreamInput != null) {
                int position = toCopy.bucketsStreamInput.getPosition();
                this.bucketsStreamInput = new AccessibleByteArrayStreamInput(CompressedHistogramData.this.encodedData, position, toCopy.bucketsStreamInput.getLimit() - position);
            } else {
                this.bucketsStreamInput = null;
            }
            this.currentCount = toCopy.currentCount;
            this.currentIndex = toCopy.currentIndex;
        }

        BucketsDecoder copy() {
            return new BucketsDecoder(this);
        }

        private void markEndReached() {
            this.currentCount = -1L;
        }

        boolean hasNext() {
            return this.currentCount != -1L;
        }

        long peekCount() {
            assert (this.currentCount != -1L) : "End has already been reached";
            return this.currentCount;
        }

        long peekIndex() {
            assert (this.currentCount != -1L) : "End has already been reached";
            return this.currentIndex;
        }

        void advance() {
            assert (this.currentCount != -1L) : "End has already been reached";
            if (this.bucketsStreamInput.available() > 0) {
                ++this.currentIndex;
                long countOrNumEmptyBuckets = this.bucketsStreamInput.readZLong();
                if (countOrNumEmptyBuckets < 0L) {
                    long numEmptyBuckets = -countOrNumEmptyBuckets;
                    this.currentIndex += numEmptyBuckets;
                    this.currentCount = this.bucketsStreamInput.readZLong();
                } else {
                    this.currentCount = countOrNumEmptyBuckets;
                }
                assert (this.currentCount > 0L);
            } else {
                this.markEndReached();
            }
        }

        private static void serializeBuckets(OutputStream out, BucketIterator buckets) throws IOException {
            if (!buckets.hasNext()) {
                return;
            }
            long firstIndex = buckets.peekIndex();
            CompressedHistogramData.writeZLong(firstIndex, out);
            CompressedHistogramData.writeZLong(buckets.peekCount(), out);
            buckets.advance();
            long prevIndex = firstIndex;
            while (buckets.hasNext()) {
                long index = buckets.peekIndex();
                long count = buckets.peekCount();
                long indexDelta = index - prevIndex;
                assert (indexDelta > 0L);
                assert (count > 0L);
                long numEmptyBucketsInBetween = indexDelta - 1L;
                if (numEmptyBucketsInBetween > 0L) {
                    CompressedHistogramData.writeZLong(-numEmptyBucketsInBetween, out);
                }
                CompressedHistogramData.writeZLong(count, out);
                buckets.advance();
                prevIndex = index;
            }
        }
    }
}

