/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.exponentialhistogram;

import org.elasticsearch.exponentialhistogram.CopyableBucketIterator;

class BucketArrayIterator
implements CopyableBucketIterator {
    private final int scale;
    private final long[] bucketCounts;
    private final long[] bucketIndices;
    private int currentSlot;
    private final int limit;

    BucketArrayIterator(int scale, long[] bucketCounts, long[] bucketIndices, int startSlot, int limit) {
        this.scale = scale;
        this.bucketCounts = bucketCounts;
        this.bucketIndices = bucketIndices;
        this.currentSlot = startSlot;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        return this.currentSlot < this.limit;
    }

    @Override
    public long peekCount() {
        this.ensureEndNotReached();
        return this.bucketCounts[this.currentSlot];
    }

    @Override
    public long peekIndex() {
        this.ensureEndNotReached();
        return this.bucketIndices[this.currentSlot];
    }

    @Override
    public void advance() {
        this.ensureEndNotReached();
        ++this.currentSlot;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public CopyableBucketIterator copy() {
        return new BucketArrayIterator(this.scale, this.bucketCounts, this.bucketIndices, this.currentSlot, this.limit);
    }

    private void ensureEndNotReached() {
        if (!this.hasNext()) {
            throw new IllegalStateException("Iterator has no more buckets");
        }
    }
}

