/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.SerializationWriter;
import com.microsoft.kiota.serialization.ValuedEnum;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class TextSerializationWriter
implements SerializationWriter {
    private static final String NO_STRUCTURED_DATA_MESSAGE = "text does not support structured data";
    private final ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private final OutputStreamWriter writer;
    private boolean written;
    private Consumer<Parsable> onBeforeObjectSerialization;
    private Consumer<Parsable> onAfterObjectSerialization;
    private BiConsumer<Parsable, SerializationWriter> onStartObjectSerialization;

    public TextSerializationWriter() {
        try {
            this.writer = new OutputStreamWriter((OutputStream)this.stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void writeStringValue(@Nullable String key, @Nullable String value) {
        if (key != null && !key.isEmpty()) {
            throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
        }
        if (value != null && !value.isEmpty()) {
            if (this.written) {
                throw new UnsupportedOperationException("a value was already written for this serialization writer, text content only supports a single value");
            }
            this.written = true;
            try {
                this.writer.write(value);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void writeBooleanValue(@Nullable String key, @Nullable Boolean value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeShortValue(@Nullable String key, @Nullable Short value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeByteValue(@Nullable String key, @Nullable Byte value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeBigDecimalValue(@Nullable String key, @Nullable BigDecimal value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeIntegerValue(@Nullable String key, @Nullable Integer value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeFloatValue(@Nullable String key, @Nullable Float value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeDoubleValue(@Nullable String key, @Nullable Double value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeLongValue(@Nullable String key, @Nullable Long value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeUUIDValue(@Nullable String key, @Nullable UUID value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public void writeOffsetDateTimeValue(@Nullable String key, @Nullable OffsetDateTime value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }
    }

    @Override
    public void writeLocalDateValue(@Nullable String key, @Nullable LocalDate value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_LOCAL_DATE));
        }
    }

    @Override
    public void writeLocalTimeValue(@Nullable String key, @Nullable LocalTime value) {
        if (value != null) {
            this.writeStringValue(key, value.format(DateTimeFormatter.ISO_LOCAL_TIME));
        }
    }

    @Override
    public void writePeriodAndDurationValue(@Nullable String key, @Nullable PeriodAndDuration value) {
        if (value != null) {
            this.writeStringValue(key, value.toString());
        }
    }

    @Override
    public <T> void writeCollectionOfPrimitiveValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    public <T extends Parsable> void writeCollectionOfObjectValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    public <T extends Enum<T>> void writeCollectionOfEnumValues(@Nullable String key, @Nullable Iterable<T> values) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    public <T extends Parsable> void writeObjectValue(@Nullable String key, @Nullable T value, Parsable ... additionalValuesToMerge) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    public <T extends Enum<T>> void writeEnumSetValue(@Nullable String key, @Nullable EnumSet<T> values) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    public <T extends Enum<T>> void writeEnumValue(@Nullable String key, @Nullable T value) {
        if (value != null) {
            this.writeStringValue(key, this.getStringValueFromValuedEnum(value));
        }
    }

    @Override
    public void writeNullValue(@Nullable String key) {
        this.writeStringValue(null, "null");
    }

    private <T extends Enum<T>> String getStringValueFromValuedEnum(T value) {
        if (value instanceof ValuedEnum) {
            ValuedEnum valued = (ValuedEnum)((Object)value);
            return valued.getValue();
        }
        return null;
    }

    @Override
    @Nonnull
    public InputStream getSerializedContent() {
        try {
            this.writer.flush();
            return new ByteArrayInputStream(this.stream.toByteArray());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        this.stream.close();
    }

    @Override
    public void writeAdditionalData(@Nonnull Map<String, Object> value) {
        throw new UnsupportedOperationException(NO_STRUCTURED_DATA_MESSAGE);
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeObjectSerialization() {
        return this.onBeforeObjectSerialization;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterObjectSerialization() {
        return this.onAfterObjectSerialization;
    }

    @Override
    @Nullable
    public BiConsumer<Parsable, SerializationWriter> getOnStartObjectSerialization() {
        return this.onStartObjectSerialization;
    }

    @Override
    public void setOnBeforeObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onBeforeObjectSerialization = value;
    }

    @Override
    public void setOnAfterObjectSerialization(@Nullable Consumer<Parsable> value) {
        this.onAfterObjectSerialization = value;
    }

    @Override
    public void setOnStartObjectSerialization(@Nullable BiConsumer<Parsable, SerializationWriter> value) {
        this.onStartObjectSerialization = value;
    }

    @Override
    public void writeByteArrayValue(@Nullable String key, @Nonnull byte[] value) {
        if (value != null) {
            this.writeStringValue(key, Base64.getEncoder().encodeToString(value));
        }
    }
}

