/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.serialization;

import com.microsoft.kiota.PeriodAndDuration;
import com.microsoft.kiota.serialization.AdditionalDataHolder;
import com.microsoft.kiota.serialization.Parsable;
import com.microsoft.kiota.serialization.ParsableFactory;
import com.microsoft.kiota.serialization.ParseNode;
import com.microsoft.kiota.serialization.ValuedEnumParser;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;

public class FormParseNode
implements ParseNode {
    private final String rawStringValue;
    private final String encoding = StandardCharsets.UTF_8.name();
    private final HashMap<String, String> fields = new HashMap();
    private Consumer<Parsable> onBeforeAssignFieldValues;
    private Consumer<Parsable> onAfterAssignFieldValues;

    public FormParseNode(@Nonnull String rawString) {
        Objects.requireNonNull(rawString, "parameter node cannot be null");
        this.rawStringValue = rawString;
        for (String kv : rawString.split("&")) {
            String[] split = kv.split("=");
            String key = this.sanitizeKey(split[0]);
            if (split.length != 2) continue;
            if (this.fields.containsKey(key)) {
                this.fields.put(key, this.fields.get(key).concat("," + split[1].trim()));
                continue;
            }
            this.fields.put(key, split[1].trim());
        }
    }

    protected final void finalize() throws Throwable {
    }

    private String sanitizeKey(@Nonnull String key) {
        Objects.requireNonNull(key);
        try {
            return URLDecoder.decode(key, this.encoding).trim();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported encoding", e);
        }
    }

    @Override
    @Nullable
    public ParseNode getChildNode(@Nonnull String identifier) {
        Objects.requireNonNull(identifier, "identifier parameter is required");
        String key = this.sanitizeKey(identifier);
        if (this.fields.containsKey(key)) {
            Consumer<Parsable> onBefore = this.onBeforeAssignFieldValues;
            Consumer<Parsable> onAfter = this.onAfterAssignFieldValues;
            FormParseNode result = new FormParseNode(this.fields.get(key));
            result.setOnBeforeAssignFieldValues(onBefore);
            result.setOnAfterAssignFieldValues(onAfter);
            return result;
        }
        return null;
    }

    @Override
    @Nullable
    public String getStringValue() {
        try {
            String decoded = URLDecoder.decode(this.rawStringValue, this.encoding);
            if (decoded.equalsIgnoreCase("null")) {
                return null;
            }
            return decoded;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public Boolean getBooleanValue() {
        switch (this.getStringValue().toLowerCase(Locale.ROOT)) {
            case "true": 
            case "1": {
                return true;
            }
            case "false": 
            case "0": {
                return false;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Byte getByteValue() {
        try {
            return Byte.parseByte(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public Short getShortValue() {
        try {
            return Short.parseShort(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public BigDecimal getBigDecimalValue() {
        try {
            return new BigDecimal(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public Integer getIntegerValue() {
        try {
            return Integer.parseInt(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public Float getFloatValue() {
        try {
            return Float.valueOf(Float.parseFloat(this.getStringValue()));
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public Double getDoubleValue() {
        try {
            return Double.parseDouble(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public Long getLongValue() {
        try {
            return Long.parseLong(this.getStringValue());
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Override
    @Nullable
    public UUID getUUIDValue() {
        String stringValue = this.getStringValue();
        if (stringValue == null) {
            return null;
        }
        return UUID.fromString(stringValue);
    }

    @Override
    @Nullable
    public OffsetDateTime getOffsetDateTimeValue() {
        String stringValue = this.getStringValue();
        if (stringValue == null) {
            return null;
        }
        try {
            return OffsetDateTime.parse(stringValue);
        }
        catch (DateTimeParseException ex) {
            try {
                LocalDateTime localDateTime = LocalDateTime.parse(stringValue);
                return localDateTime.atOffset(ZoneOffset.UTC);
            }
            catch (DateTimeParseException ex2) {
                throw ex;
            }
        }
    }

    @Override
    @Nullable
    public LocalDate getLocalDateValue() {
        String stringValue = this.getStringValue();
        if (stringValue == null) {
            return null;
        }
        return LocalDate.parse(stringValue);
    }

    @Override
    @Nullable
    public LocalTime getLocalTimeValue() {
        String stringValue = this.getStringValue();
        if (stringValue == null) {
            return null;
        }
        return LocalTime.parse(stringValue);
    }

    @Override
    @Nullable
    public PeriodAndDuration getPeriodAndDurationValue() {
        String stringValue = this.getStringValue();
        if (stringValue == null) {
            return null;
        }
        return PeriodAndDuration.parse(stringValue);
    }

    @Override
    @Nullable
    public <T> List<T> getCollectionOfPrimitiveValues(final @Nonnull Class<T> targetClass) {
        List<String> primitiveStringCollection = Arrays.asList(this.getStringValue().split(","));
        final Iterator<String> sourceIterator = primitiveStringCollection.iterator();
        final FormParseNode _this = this;
        ArrayList result = new ArrayList();
        Iterable iterable = new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return sourceIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        String item = (String)sourceIterator.next();
                        final Consumer<Parsable> onBefore = _this.getOnBeforeAssignFieldValues();
                        final Consumer<Parsable> onAfter = _this.getOnAfterAssignFieldValues();
                        FormParseNode itemNode = new FormParseNode(item){
                            {
                                super(rawString);
                                this.setOnBeforeAssignFieldValues(onBefore);
                                this.setOnAfterAssignFieldValues(onAfter);
                            }
                        };
                        if (targetClass == Boolean.class) {
                            return itemNode.getBooleanValue();
                        }
                        if (targetClass == Short.class) {
                            return itemNode.getShortValue();
                        }
                        if (targetClass == Byte.class) {
                            return itemNode.getByteValue();
                        }
                        if (targetClass == BigDecimal.class) {
                            return itemNode.getBigDecimalValue();
                        }
                        if (targetClass == String.class) {
                            return itemNode.getStringValue();
                        }
                        if (targetClass == Integer.class) {
                            return itemNode.getIntegerValue();
                        }
                        if (targetClass == Float.class) {
                            return itemNode.getFloatValue();
                        }
                        if (targetClass == Long.class) {
                            return itemNode.getLongValue();
                        }
                        if (targetClass == UUID.class) {
                            return itemNode.getUUIDValue();
                        }
                        if (targetClass == OffsetDateTime.class) {
                            return itemNode.getOffsetDateTimeValue();
                        }
                        if (targetClass == LocalDate.class) {
                            return itemNode.getLocalDateValue();
                        }
                        if (targetClass == LocalTime.class) {
                            return itemNode.getLocalTimeValue();
                        }
                        if (targetClass == PeriodAndDuration.class) {
                            return itemNode.getPeriodAndDurationValue();
                        }
                        throw new RuntimeException("unknown type to deserialize " + targetClass.getName());
                    }
                };
            }
        };
        for (Object elem : iterable) {
            result.add(elem);
        }
        return result;
    }

    @Override
    @Nullable
    public <T extends Parsable> List<T> getCollectionOfObjectValues(@Nonnull ParsableFactory<T> factory) {
        throw new RuntimeException("deserialization of collections of is not supported with form encoding");
    }

    @Override
    @Nullable
    public <T extends Enum<T>> List<T> getCollectionOfEnumValues(@Nonnull ValuedEnumParser<T> enumParser) {
        Objects.requireNonNull(enumParser, "parameter enumParser cannot be null");
        String stringValue = this.getStringValue();
        if (stringValue == null || stringValue.isEmpty()) {
            return null;
        }
        String[] array = stringValue.split(",");
        ArrayList<T> result = new ArrayList<T>();
        for (String item : array) {
            result.add(enumParser.forValue(item));
        }
        return result;
    }

    @Override
    @Nonnull
    public <T extends Parsable> T getObjectValue(@Nonnull ParsableFactory<T> factory) {
        Objects.requireNonNull(factory, "parameter factory cannot be null");
        T item = factory.create(this);
        this.assignFieldValues(item, item.getFieldDeserializers());
        return item;
    }

    @Override
    @Nullable
    public <T extends Enum<T>> T getEnumValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        return enumParser.forValue(rawValue);
    }

    @Override
    @Nullable
    public <T extends Enum<T>> EnumSet<T> getEnumSetValue(@Nonnull ValuedEnumParser<T> enumParser) {
        String[] rawValues;
        String rawValue = this.getStringValue();
        if (rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        for (String rawValueItem : rawValues = rawValue.split(",")) {
            T value = enumParser.forValue(rawValueItem);
            if (value == null) continue;
            result.add(value);
        }
        return EnumSet.copyOf(result);
    }

    private <T extends Parsable> void assignFieldValues(T item, Map<String, Consumer<ParseNode>> fieldDeserializers) {
        if (!this.fields.isEmpty()) {
            if (this.onBeforeAssignFieldValues != null) {
                this.onBeforeAssignFieldValues.accept(item);
            }
            Map<String, Object> itemAdditionalData = null;
            if (item instanceof AdditionalDataHolder) {
                itemAdditionalData = ((AdditionalDataHolder)((Object)item)).getAdditionalData();
            }
            for (Map.Entry<String, String> fieldEntry : this.fields.entrySet()) {
                String fieldKey = fieldEntry.getKey();
                Consumer<ParseNode> fieldDeserializer = fieldDeserializers.get(fieldKey);
                String fieldValue = fieldEntry.getValue();
                if (fieldValue == null) continue;
                if (fieldDeserializer != null) {
                    final Consumer<Parsable> onBefore = this.onBeforeAssignFieldValues;
                    final Consumer<Parsable> onAfter = this.onAfterAssignFieldValues;
                    fieldDeserializer.accept(new FormParseNode(fieldValue){
                        {
                            super(rawString);
                            this.setOnBeforeAssignFieldValues(onBefore);
                            this.setOnAfterAssignFieldValues(onAfter);
                        }
                    });
                    continue;
                }
                if (itemAdditionalData == null) continue;
                itemAdditionalData.put(fieldKey, fieldValue);
            }
            if (this.onAfterAssignFieldValues != null) {
                this.onAfterAssignFieldValues.accept(item);
            }
        }
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnBeforeAssignFieldValues() {
        return this.onBeforeAssignFieldValues;
    }

    @Override
    @Nullable
    public Consumer<Parsable> getOnAfterAssignFieldValues() {
        return this.onAfterAssignFieldValues;
    }

    @Override
    public void setOnBeforeAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onBeforeAssignFieldValues = value;
    }

    @Override
    public void setOnAfterAssignFieldValues(@Nullable Consumer<Parsable> value) {
        this.onAfterAssignFieldValues = value;
    }

    @Override
    @Nullable
    public byte[] getByteArrayValue() {
        String base64 = this.getStringValue();
        if (base64 == null || base64.isEmpty()) {
            return null;
        }
        return Base64.getDecoder().decode(base64);
    }
}

