/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import com.microsoft.kiota.http.middleware.options.UserAgentHandlerOption;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Objects;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class UserAgentHandler
implements Interceptor {
    @Nonnull
    private final UserAgentHandlerOption _userAgentOption;
    private static final String USER_AGENT_HEADER_NAME = "User-Agent";

    public UserAgentHandler() {
        this(null);
    }

    public UserAgentHandler(@Nullable UserAgentHandlerOption userAgentHandlerOption) {
        this._userAgentOption = userAgentHandlerOption == null ? new UserAgentHandlerOption() : userAgentHandlerOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Objects.requireNonNull(chain, "parameter chain cannot be null");
        Request request = chain.request();
        UserAgentHandlerOption userAgentHandlerOption = (UserAgentHandlerOption)request.tag(UserAgentHandlerOption.class);
        if (userAgentHandlerOption == null) {
            userAgentHandlerOption = this._userAgentOption;
        }
        if (!userAgentHandlerOption.getEnabled()) {
            return chain.proceed(request);
        }
        Span span = ObservabilityHelper.getSpanForRequest(request, "UserAgentHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.useragent.enable", true);
        }
        Request.Builder builder = request.newBuilder();
        try {
            String currentValue = request.headers().get(USER_AGENT_HEADER_NAME);
            String valueToAppend = userAgentHandlerOption.getProductName() + "/" + userAgentHandlerOption.getProductVersion();
            if (currentValue == null || currentValue.isEmpty()) {
                builder.header(USER_AGENT_HEADER_NAME, valueToAppend);
            } else if (!currentValue.contains(valueToAppend)) {
                builder.header(USER_AGENT_HEADER_NAME, currentValue + " " + valueToAppend);
            }
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
        return chain.proceed(builder.build());
    }
}

