/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.kiota.http.middleware;

import com.microsoft.kiota.http.middleware.ObservabilityHelper;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class ChaosHandler
implements Interceptor {
    private static final String RETRY_AFTER = "Retry-After";
    private static final int failureRate = 3;
    private static final String retryAfterValue = "10";
    private static final String responseBody = "{\"error\": {\"code\": \"TooManyRequests\",\"innerError\": {\"code\": \"429\",\"date\": \"2020-08-18T12:51:51\",\"message\": \"Please retry after\",\"request-id\": \"94fb3b52-452a-4535-a601-69e0a90e3aa2\",\"status\": \"429\"},\"message\": \"Please retry again later.\"}}";
    public static final int MSClientErrorCodeTooManyRequests = 429;
    public static final String chaosHandlerTriggeredEventKey = "com.microsoft.kiota.chaos_handler_triggered";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Response intercept(@Nonnull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        Span span = ObservabilityHelper.getSpanForRequest(request, "ChaosHandler_Intercept");
        Scope scope = null;
        if (span != null) {
            scope = span.makeCurrent();
            span.setAttribute("com.microsoft.kiota.handler.chaos.enable", true);
        }
        try {
            int dice = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
            if (dice % 3 == 0) {
                span.addEvent(chaosHandlerTriggeredEventKey);
                Response response = new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(429).message("Too Many Requests").addHeader(RETRY_AFTER, retryAfterValue).body(ResponseBody.create((String)responseBody, (MediaType)MediaType.get((String)"application/json"))).build();
                return response;
            }
            if (span != null) {
                request = request.newBuilder().tag(Span.class, (Object)span).build();
            }
            Response response = chain.proceed(request);
            return response;
        }
        finally {
            if (scope != null) {
                scope.close();
            }
            if (span != null) {
                span.end();
            }
        }
    }
}

