/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz.microsoft;

import com.azure.core.credential.TokenCredential;
import com.azure.core.http.okhttp.OkHttpAsyncHttpClientBuilder;
import com.azure.identity.ClientSecretCredential;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.microsoft.graph.core.requests.BaseGraphRequestAdapter;
import com.microsoft.graph.core.requests.IBaseClient;
import com.microsoft.graph.core.tasks.PageIterator;
import com.microsoft.graph.models.GroupCollectionResponse;
import com.microsoft.graph.serviceclient.GraphServiceClient;
import com.microsoft.kiota.RequestAdapter;
import com.microsoft.kiota.authentication.AuthenticationProvider;
import com.microsoft.kiota.authentication.AzureIdentityAuthenticationProvider;
import com.microsoft.kiota.http.middleware.RetryHandler;
import com.microsoft.kiota.serialization.Parsable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.LicensedFeature;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.UserRoleMapper;
import org.elasticsearch.xpack.core.security.support.CancellableRunnable;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.microsoft.MicrosoftGraphAuthzRealmSettings;

public class MicrosoftGraphAuthzRealm
extends Realm {
    private static final Logger logger = LogManager.getLogger(MicrosoftGraphAuthzRealm.class);
    private static final int PAGE_SIZE = 999;
    private static final boolean DISABLE_INSTANCE_DISCOVERY = System.getProperty("tests.azure.credentials.disable_instance_discovery", "false").equals("true");
    static final LicensedFeature.Momentary MICROSOFT_GRAPH_FEATURE = LicensedFeature.momentary((String)"security-realms", (String)"microsoft_graph", (License.OperationMode)License.OperationMode.PLATINUM);
    private final RealmConfig config;
    private final UserRoleMapper roleMapper;
    private final GraphServiceClient client;
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final TimeValue executionTimeout;

    public MicrosoftGraphAuthzRealm(UserRoleMapper roleMapper, RealmConfig config, ThreadPool threadPool) {
        this(roleMapper, config, MicrosoftGraphAuthzRealm.buildClient(config), XPackPlugin.getSharedLicenseState(), threadPool);
    }

    MicrosoftGraphAuthzRealm(UserRoleMapper roleMapper, RealmConfig config, GraphServiceClient client, XPackLicenseState licenseState, ThreadPool threadPool) {
        super(config);
        MicrosoftGraphAuthzRealm.validate(config);
        this.config = config;
        this.roleMapper = roleMapper;
        this.client = client;
        this.licenseState = licenseState;
        this.threadPool = threadPool;
        this.executionTimeout = (TimeValue)config.getSetting(MicrosoftGraphAuthzRealmSettings.EXECUTION_TIMEOUT);
    }

    private static void validate(RealmConfig config) {
        MicrosoftGraphAuthzRealm.require(config, MicrosoftGraphAuthzRealmSettings.CLIENT_ID);
        MicrosoftGraphAuthzRealm.require(config, MicrosoftGraphAuthzRealmSettings.CLIENT_SECRET);
        MicrosoftGraphAuthzRealm.require(config, MicrosoftGraphAuthzRealmSettings.TENANT_ID);
    }

    private static <T extends CharSequence> void require(RealmConfig config, Setting.AffixSetting<T> setting) {
        CharSequence value = (CharSequence)config.getSetting(setting);
        if (value.isEmpty()) {
            throw new SettingsException("The configuration setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, setting) + "] is required");
        }
    }

    public boolean supports(AuthenticationToken token) {
        return false;
    }

    public AuthenticationToken token(ThreadContext context) {
        return null;
    }

    public void authenticate(AuthenticationToken token, ActionListener<AuthenticationResult<User>> listener) {
        listener.onResponse((Object)AuthenticationResult.notHandled());
    }

    public void lookupUser(String principal, ActionListener<User> listener) {
        if (!MICROSOFT_GRAPH_FEATURE.check(this.licenseState)) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)MICROSOFT_GRAPH_FEATURE.getName()));
            return;
        }
        CancellableRunnable runnable = new CancellableRunnable(listener, ex -> null, () -> this.doLookupUser(principal, listener), logger);
        this.threadPool.generic().execute((Runnable)runnable);
        this.threadPool.schedule(() -> ((CancellableRunnable)runnable).maybeTimeout(), this.executionTimeout, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
    }

    private void doLookupUser(String principal, ActionListener<User> listener) {
        try {
            Tuple<String, String> userProperties = this.fetchUserProperties(this.client, principal);
            List<String> groups = this.fetchGroupMembership(this.client, principal);
            UserRoleMapper.UserData userData = new UserRoleMapper.UserData(principal, null, groups, Map.of(), this.config);
            this.roleMapper.resolveRoles(userData, listener.delegateFailureAndWrap((l, roles) -> {
                User user = new User(principal, roles.toArray(Strings.EMPTY_ARRAY), (String)userProperties.v1(), (String)userProperties.v2(), Map.of(), true);
                logger.trace("Authorized user from Microsoft Graph {}", (Object)user);
                l.onResponse((Object)user);
            }));
        }
        catch (Exception e) {
            logger.error(Strings.format((String)"Failed to authorize [%s] with MS Graph realm", (Object[])new Object[]{principal}), (Throwable)e);
            listener.onFailure(e);
        }
    }

    private static GraphServiceClient buildClient(RealmConfig config) {
        SecureString clientSecret = (SecureString)config.getSetting(MicrosoftGraphAuthzRealmSettings.CLIENT_SECRET);
        TimeValue timeout = (TimeValue)config.getSetting(MicrosoftGraphAuthzRealmSettings.HTTP_REQUEST_TIMEOUT);
        OkHttpClient httpClient = new OkHttpClient.Builder().callTimeout(Duration.ofSeconds(timeout.seconds())).addInterceptor((Interceptor)new RetryHandler()).build();
        ClientSecretCredentialBuilder credentialProviderBuilder = (ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().clientId((String)config.getSetting(MicrosoftGraphAuthzRealmSettings.CLIENT_ID))).clientSecret(clientSecret.toString()).tenantId((String)config.getSetting(MicrosoftGraphAuthzRealmSettings.TENANT_ID))).authorityHost((String)config.getSetting(MicrosoftGraphAuthzRealmSettings.ACCESS_TOKEN_HOST))).httpClient(new OkHttpAsyncHttpClientBuilder(httpClient).build())).enableUnsafeSupportLogging()).enableAccountIdentifierLogging();
        if (DISABLE_INSTANCE_DISCOVERY) {
            credentialProviderBuilder.disableInstanceDiscovery();
        }
        ClientSecretCredential credentialProvider = credentialProviderBuilder.build();
        return new GraphServiceClient((RequestAdapter)new BaseGraphRequestAdapter((AuthenticationProvider)new AzureIdentityAuthenticationProvider((TokenCredential)credentialProvider, Strings.EMPTY_ARRAY, new String[]{"https://graph.microsoft.com/.default"}), (String)config.getSetting(MicrosoftGraphAuthzRealmSettings.API_HOST), httpClient));
    }

    private Tuple<String, String> fetchUserProperties(GraphServiceClient client, String userId) {
        com.microsoft.graph.models.User response = client.users().byUserId(userId).get(requestConfig -> {
            requestConfig.queryParameters.select = new String[]{"displayName", "mail"};
        });
        logger.trace("Fetched user with name [{}] and email [{}] from Microsoft Graph", (Object)response.getDisplayName(), (Object)response.getMail());
        return Tuple.tuple((Object)response.getDisplayName(), (Object)response.getMail());
    }

    private List<String> fetchGroupMembership(GraphServiceClient client, String userId) throws ReflectiveOperationException {
        ArrayList<String> groups = new ArrayList<String>();
        GroupCollectionResponse groupMembership = client.users().byUserId(userId).transitiveMemberOf().graphGroup().get(requestConfig -> {
            requestConfig.queryParameters.select = new String[]{"id"};
            requestConfig.queryParameters.top = 999;
        });
        PageIterator pageIterator = new PageIterator.Builder().client((IBaseClient)client).collectionPage((Parsable)groupMembership).collectionPageFactory(GroupCollectionResponse::createFromDiscriminatorValue).requestConfigurator(requestInfo -> {
            requestInfo.addQueryParameter("%24select", (Object)new String[]{"id"});
            requestInfo.addQueryParameter("%24top", (Object)String.valueOf(999));
            return requestInfo;
        }).processPageItemCallback(group -> {
            groups.add(group.getId());
            return true;
        }).build();
        pageIterator.iterate();
        if (logger.isTraceEnabled()) {
            logger.trace("Fetched [{}] groups from Microsoft Graph: [{}]", (Object)groups.size(), (Object)String.join((CharSequence)", ", groups));
        }
        return groups;
    }
}

