/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.OperatorRequest;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateVolumeRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateVolumeRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(CreateVolumeRequest.getter(CreateVolumeRequest::availabilityZone)).setter(CreateVolumeRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(CreateVolumeRequest.getter(CreateVolumeRequest::encrypted)).setter(CreateVolumeRequest.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").unmarshallLocationName("encrypted").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(CreateVolumeRequest.getter(CreateVolumeRequest::iops)).setter(CreateVolumeRequest.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").unmarshallLocationName("Iops").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(CreateVolumeRequest.getter(CreateVolumeRequest::kmsKeyId)).setter(CreateVolumeRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").unmarshallLocationName("KmsKeyId").build()}).build();
    private static final SdkField<String> OUTPOST_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutpostArn").getter(CreateVolumeRequest.getter(CreateVolumeRequest::outpostArn)).setter(CreateVolumeRequest.setter(Builder::outpostArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutpostArn").unmarshallLocationName("OutpostArn").build()}).build();
    private static final SdkField<Integer> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Size").getter(CreateVolumeRequest.getter(CreateVolumeRequest::size)).setter(CreateVolumeRequest.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").unmarshallLocationName("Size").build()}).build();
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotId").getter(CreateVolumeRequest.getter(CreateVolumeRequest::snapshotId)).setter(CreateVolumeRequest.setter(Builder::snapshotId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").unmarshallLocationName("SnapshotId").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(CreateVolumeRequest.getter(CreateVolumeRequest::volumeTypeAsString)).setter(CreateVolumeRequest.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").unmarshallLocationName("VolumeType").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateVolumeRequest.getter(CreateVolumeRequest::tagSpecifications)).setter(CreateVolumeRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MULTI_ATTACH_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAttachEnabled").getter(CreateVolumeRequest.getter(CreateVolumeRequest::multiAttachEnabled)).setter(CreateVolumeRequest.setter(Builder::multiAttachEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAttachEnabled").unmarshallLocationName("MultiAttachEnabled").build()}).build();
    private static final SdkField<Integer> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Throughput").getter(CreateVolumeRequest.getter(CreateVolumeRequest::throughput)).setter(CreateVolumeRequest.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Throughput").unmarshallLocationName("Throughput").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateVolumeRequest.getter(CreateVolumeRequest::clientToken)).setter(CreateVolumeRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> VOLUME_INITIALIZATION_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeInitializationRate").getter(CreateVolumeRequest.getter(CreateVolumeRequest::volumeInitializationRate)).setter(CreateVolumeRequest.setter(Builder::volumeInitializationRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeInitializationRate").unmarshallLocationName("VolumeInitializationRate").build()}).build();
    private static final SdkField<OperatorRequest> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Operator").getter(CreateVolumeRequest.getter(CreateVolumeRequest::operator)).setter(CreateVolumeRequest.setter(Builder::operator)).constructor(OperatorRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").unmarshallLocationName("Operator").build()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateVolumeRequest.getter(CreateVolumeRequest::dryRun)).setter(CreateVolumeRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("dryRun").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, ENCRYPTED_FIELD, IOPS_FIELD, KMS_KEY_ID_FIELD, OUTPOST_ARN_FIELD, SIZE_FIELD, SNAPSHOT_ID_FIELD, VOLUME_TYPE_FIELD, TAG_SPECIFICATIONS_FIELD, MULTI_ATTACH_ENABLED_FIELD, THROUGHPUT_FIELD, CLIENT_TOKEN_FIELD, VOLUME_INITIALIZATION_RATE_FIELD, OPERATOR_FIELD, DRY_RUN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateVolumeRequest.memberNameToFieldInitializer();
    private final String availabilityZone;
    private final Boolean encrypted;
    private final Integer iops;
    private final String kmsKeyId;
    private final String outpostArn;
    private final Integer size;
    private final String snapshotId;
    private final String volumeType;
    private final List<TagSpecification> tagSpecifications;
    private final Boolean multiAttachEnabled;
    private final Integer throughput;
    private final String clientToken;
    private final Integer volumeInitializationRate;
    private final OperatorRequest operator;
    private final Boolean dryRun;

    private CreateVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.encrypted = builder.encrypted;
        this.iops = builder.iops;
        this.kmsKeyId = builder.kmsKeyId;
        this.outpostArn = builder.outpostArn;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.volumeType = builder.volumeType;
        this.tagSpecifications = builder.tagSpecifications;
        this.multiAttachEnabled = builder.multiAttachEnabled;
        this.throughput = builder.throughput;
        this.clientToken = builder.clientToken;
        this.volumeInitializationRate = builder.volumeInitializationRate;
        this.operator = builder.operator;
        this.dryRun = builder.dryRun;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String outpostArn() {
        return this.outpostArn;
    }

    public final Integer size() {
        return this.size;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    public final Boolean multiAttachEnabled() {
        return this.multiAttachEnabled;
    }

    public final Integer throughput() {
        return this.throughput;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer volumeInitializationRate() {
        return this.volumeInitializationRate;
    }

    public final OperatorRequest operator() {
        return this.operator;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outpostArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAttachEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeInitializationRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.operator());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.outpostArn(), other.outpostArn()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications()) && Objects.equals(this.multiAttachEnabled(), other.multiAttachEnabled()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.volumeInitializationRate(), other.volumeInitializationRate()) && Objects.equals(this.operator(), other.operator()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public final String toString() {
        return ToString.builder((String)"CreateVolumeRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Encrypted", (Object)this.encrypted()).add("Iops", (Object)this.iops()).add("KmsKeyId", (Object)this.kmsKeyId()).add("OutpostArn", (Object)this.outpostArn()).add("Size", (Object)this.size()).add("SnapshotId", (Object)this.snapshotId()).add("VolumeType", (Object)this.volumeTypeAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).add("MultiAttachEnabled", (Object)this.multiAttachEnabled()).add("Throughput", (Object)this.throughput()).add("ClientToken", (Object)this.clientToken()).add("VolumeInitializationRate", (Object)this.volumeInitializationRate()).add("Operator", (Object)this.operator()).add("DryRun", (Object)this.dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "OutpostArn": {
                return Optional.ofNullable(clazz.cast(this.outpostArn()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
            case "SnapshotId": {
                return Optional.ofNullable(clazz.cast(this.snapshotId()));
            }
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
            case "MultiAttachEnabled": {
                return Optional.ofNullable(clazz.cast(this.multiAttachEnabled()));
            }
            case "Throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "VolumeInitializationRate": {
                return Optional.ofNullable(clazz.cast(this.volumeInitializationRate()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operator()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("Encrypted", ENCRYPTED_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("OutpostArn", OUTPOST_ARN_FIELD);
        map.put("Size", SIZE_FIELD);
        map.put("SnapshotId", SNAPSHOT_ID_FIELD);
        map.put("VolumeType", VOLUME_TYPE_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        map.put("MultiAttachEnabled", MULTI_ATTACH_ENABLED_FIELD);
        map.put("Throughput", THROUGHPUT_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("VolumeInitializationRate", VOLUME_INITIALIZATION_RATE_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateVolumeRequest, T> g) {
        return obj -> g.apply((CreateVolumeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private Boolean encrypted;
        private Integer iops;
        private String kmsKeyId;
        private String outpostArn;
        private Integer size;
        private String snapshotId;
        private String volumeType;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();
        private Boolean multiAttachEnabled;
        private Integer throughput;
        private String clientToken;
        private Integer volumeInitializationRate;
        private OperatorRequest operator;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVolumeRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.encrypted(model.encrypted);
            this.iops(model.iops);
            this.kmsKeyId(model.kmsKeyId);
            this.outpostArn(model.outpostArn);
            this.size(model.size);
            this.snapshotId(model.snapshotId);
            this.volumeType(model.volumeType);
            this.tagSpecifications(model.tagSpecifications);
            this.multiAttachEnabled(model.multiAttachEnabled);
            this.throughput(model.throughput);
            this.clientToken(model.clientToken);
            this.volumeInitializationRate(model.volumeInitializationRate);
            this.operator(model.operator);
            this.dryRun(model.dryRun);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getOutpostArn() {
            return this.outpostArn;
        }

        public final void setOutpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
        }

        @Override
        public final Builder outpostArn(String outpostArn) {
            this.outpostArn = outpostArn;
            return this;
        }

        public final Integer getSize() {
            return this.size;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAttachEnabled() {
            return this.multiAttachEnabled;
        }

        public final void setMultiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
        }

        @Override
        public final Builder multiAttachEnabled(Boolean multiAttachEnabled) {
            this.multiAttachEnabled = multiAttachEnabled;
            return this;
        }

        public final Integer getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Integer throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Integer throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getVolumeInitializationRate() {
            return this.volumeInitializationRate;
        }

        public final void setVolumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
        }

        @Override
        public final Builder volumeInitializationRate(Integer volumeInitializationRate) {
            this.volumeInitializationRate = volumeInitializationRate;
            return this;
        }

        public final OperatorRequest.Builder getOperator() {
            return this.operator != null ? this.operator.toBuilder() : null;
        }

        public final void setOperator(OperatorRequest.BuilderImpl operator) {
            this.operator = operator != null ? operator.build() : null;
        }

        @Override
        public final Builder operator(OperatorRequest operator) {
            this.operator = operator;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateVolumeRequest build() {
            return new CreateVolumeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateVolumeRequest> {
        public Builder availabilityZone(String var1);

        public Builder encrypted(Boolean var1);

        public Builder iops(Integer var1);

        public Builder kmsKeyId(String var1);

        public Builder outpostArn(String var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder multiAttachEnabled(Boolean var1);

        public Builder throughput(Integer var1);

        public Builder clientToken(String var1);

        public Builder volumeInitializationRate(Integer var1);

        public Builder operator(OperatorRequest var1);

        default public Builder operator(Consumer<OperatorRequest.Builder> operator) {
            return this.operator((OperatorRequest)((OperatorRequest.Builder)OperatorRequest.builder().applyMutation(operator)).build());
        }

        public Builder dryRun(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

