/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugin.analysis.icu;

import com.ibm.icu.text.Normalizer2;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.icu.ICUFoldingFilter;
import org.apache.lucene.analysis.icu.ICUNormalizer2Filter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.elasticsearch.index.analysis.NormalizingTokenFilterFactory;
import org.elasticsearch.plugin.analysis.icu.IcuNormalizerTokenFilterFactory;

public class IcuFoldingTokenFilterFactory
extends AbstractTokenFilterFactory
implements NormalizingTokenFilterFactory {
    private static final Normalizer2 ICU_FOLDING_NORMALIZER = ICUFoldingFilter.NORMALIZER;
    private final Normalizer2 normalizer;

    public IcuFoldingTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(name);
        this.normalizer = IcuNormalizerTokenFilterFactory.wrapWithUnicodeSetFilter(ICU_FOLDING_NORMALIZER, settings);
    }

    public TokenStream create(TokenStream tokenStream) {
        return new ICUNormalizer2Filter(tokenStream, this.normalizer);
    }
}

