/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import scala.Option;
import scala.Predef$;
import scala.collection.LinearSeqOptimized;
import scala.collection.immutable.StringOps;
import scala.util.matching.Regex;

public final class StructuredStreamingVersionLock$ {
    public static StructuredStreamingVersionLock$ MODULE$;
    private final Log LOG;
    private final Regex supported;

    static {
        new StructuredStreamingVersionLock$();
    }

    public void checkCompatibility(SparkSession session) {
        block5: {
            try {
                String string = session.version();
                Option option = this.supported.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                    String version = (String)((LinearSeqOptimized)option.get()).apply(0);
                    if (this.LOG.isDebugEnabled()) {
                        this.LOG.debug((Object)new StringBuilder(45).append("Running against supported version of Spark [").append(version).append("]").toString());
                    }
                    break block5;
                }
                throw new EsHadoopIllegalArgumentException(new StringBuilder(201).append("Spark version mismatch. Expected at least Spark version [2.2.0] ").append("but found [").append(session.version()).append("]. Spark Structured Streaming is a feature that is only supported on Spark ").append("[2.2.0] and up for this version of ES-Hadoop/Spark.").toString());
            }
            catch (EsHadoopException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new EsHadoopIllegalArgumentException("Could not determine the version of Spark for compatibility", t);
            }
        }
    }

    private StructuredStreamingVersionLock$() {
        MODULE$ = this;
        this.LOG = LogFactory.getLog(this.getClass());
        this.supported = new StringOps(Predef$.MODULE$.augmentString("(2.[2-9].[0-9]|[3-9].[0-9].[0-9]).*")).r();
    }
}

