/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.request;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.rest.request.RequestBuilder;
import org.elasticsearch.hadoop.serialization.dto.IndicesAliases;
import org.elasticsearch.hadoop.util.StringUtils;

public class GetAliasesRequestBuilder
extends RequestBuilder<Response> {
    private final List<String> indices = new ArrayList<String>();
    private final List<String> aliases = new ArrayList<String>();

    public GetAliasesRequestBuilder(RestClient client) {
        super(client);
    }

    public GetAliasesRequestBuilder aliases(String ... values) {
        Collections.addAll(this.aliases, values);
        return this;
    }

    public GetAliasesRequestBuilder indices(String ... values) {
        Collections.addAll(this.indices, values);
        return this;
    }

    @Override
    public Response execute() {
        StringBuilder path = new StringBuilder();
        if (this.indices.size() > 0) {
            path.append(StringUtils.concatenate(this.indices));
        } else {
            path.append("_all");
        }
        path.append("/_alias");
        if (this.aliases.size() > 0) {
            path.append("/").append(StringUtils.concatenate(this.aliases));
        }
        return new Response((Map)this.client.get(path.toString(), null));
    }

    public static class Response
    implements RequestBuilder.Response {
        private final IndicesAliases indicesAliases;

        public Response(Map<String, Object> map) {
            this.indicesAliases = IndicesAliases.parse(map);
        }

        public IndicesAliases getIndices() {
            return this.indicesAliases;
        }

        public boolean hasAliases() {
            return this.indicesAliases.getAll().size() > 0;
        }
    }
}

