/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.cfg.SparkSettings;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.sql.EsDataFrameWriter;
import scala.;
import scala.$less$colon$less$;
import scala.Function2;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public final class EsSparkSQL$ {
    public static final EsSparkSQL$ MODULE$ = new EsSparkSQL$();
    private static final Class<?> init = ObjectUtils.loadClass("org.elasticsearch.spark.rdd.CompatUtils", ObjectUtils.class.getClassLoader());
    private static final transient Log LOG = LogFactory.getLog(MODULE$.getClass());

    private Class<?> init() {
        return init;
    }

    public Dataset<Row> esDF(SQLContext sc) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }

    public Dataset<Row> esDF(SQLContext sc, String resource) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, String query) {
        return this.esDF(sc, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public Dataset<Row> esDF(SQLContext sc, Map<String, String> cfg) {
        Settings esConf = new SparkSettingsManager().load(sc.sparkContext().getConf()).copy();
        esConf.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        return sc.read().format("org.elasticsearch.spark.sql").options((Map)((IterableOnceOps)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(esConf.asProperties()).asScala()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).load();
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, String query, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query), (Seq)Nil$.MODULE$)));
    }

    public Dataset<Row> esDF(SQLContext sc, String resource, Map<String, String> cfg) {
        return this.esDF(sc, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource))));
    }

    public Dataset<Row> esDF(SparkSession ss) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.empty()));
    }

    public Dataset<Row> esDF(SparkSession ss, String resource) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource)}))));
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, String query) {
        return this.esDF(ss.sqlContext(), (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.read"), (Object)resource), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.query"), (Object)query)}))));
    }

    public Dataset<Row> esDF(SparkSession ss, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), cfg);
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, String query, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), resource, query, cfg);
    }

    public Dataset<Row> esDF(SparkSession ss, String resource, Map<String, String> cfg) {
        return this.esDF(ss.sqlContext(), resource, cfg);
    }

    public void saveToEs(Dataset<?> srdd, String resource) {
        this.saveToEs(srdd, (Map<String, String>)((Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource)}))));
    }

    public void saveToEs(Dataset<?> srdd, String resource, Map<String, String> cfg) {
        this.saveToEs(srdd, (Map<String, String>)((Map)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource.write"), (Object)resource))));
    }

    public void saveToEs(Dataset<?> srdd, Map<String, String> cfg) {
        if (srdd != null) {
            if (srdd.isStreaming()) {
                throw new EsHadoopIllegalArgumentException("Streaming Datasets should not be saved with 'saveToEs()'. Instead, use the 'writeStream().format(\"es\").save()' methods.");
            }
            SparkContext sparkCtx = srdd.sqlContext().sparkContext();
            SparkSettings sparkCfg = new SparkSettingsManager().load(sparkCtx.getConf());
            Settings esCfg = new PropertiesSettings().load(sparkCfg.save());
            esCfg.merge((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
            InitializationUtils.setUserProviderIfNotSet(esCfg, HadoopUserProvider.class, LOG);
            InitializationUtils.discoverClusterInfo(esCfg, LOG);
            InitializationUtils.checkIdForOperation(esCfg);
            InitializationUtils.checkIndexExistence(esCfg);
            EsDataFrameWriter esDataFrameWriter = new EsDataFrameWriter(srdd.schema(), esCfg.save());
            sparkCtx.runJob(srdd.toDF().rdd(), (Function2 & Serializable)(taskContext, data) -> {
                esDataFrameWriter.write(taskContext, data);
                return BoxedUnit.UNIT;
            }, (ClassTag)ClassTag$.MODULE$.Unit());
            return;
        }
    }

    private EsSparkSQL$() {
    }
}

