/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.Sink;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.sources.StreamSinkProvider;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.types.StructType;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.util.Version;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.sql.ElasticsearchRelation;
import org.elasticsearch.spark.sql.ElasticsearchRelation$;
import org.elasticsearch.spark.sql.streaming.EsSparkSqlStreamingSink;
import org.elasticsearch.spark.sql.streaming.SparkSqlStreamingConfigs$;
import org.elasticsearch.spark.sql.streaming.StructuredStreamingVersionLock$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Growable;
import scala.collection.mutable.Map$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005]c!\u0002\u0005\n\u0001%\t\u0002\"B\u0016\u0001\t\u0003i\u0003\"\u0002\u0019\u0001\t\u0003\n\u0004\"\u0002\u0019\u0001\t\u0003z\u0005\"\u0002\u0019\u0001\t\u0003Z\u0006\"B;\u0001\t\u00032\b\u0002CA\u0013\u0001\u0011\u0005\u0011\"a\n\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002J\tiA)\u001a4bk2$8k\\;sG\u0016T!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003A\t1a\u001c:h'\u0019\u0001!\u0003\u0007\u0012&QA\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u0004\"!\u0007\u0011\u000e\u0003iQ!a\u0007\u000f\u0002\u000fM|WO]2fg*\u0011!\"\b\u0006\u0003\u0019yQ!aH\b\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t#D\u0001\tSK2\fG/[8o!J|g/\u001b3feB\u0011\u0011dI\u0005\u0003Ii\u0011acU2iK6\f'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u00033\u0019J!a\n\u000e\u00033\r\u0013X-\u0019;bE2,'+\u001a7bi&|g\u000e\u0015:pm&$WM\u001d\t\u00033%J!A\u000b\u000e\u0003%M#(/Z1n'&t7\u000e\u0015:pm&$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\ta\u0006\u0005\u00020\u00015\t\u0011\"\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\u0007I*t\b\u0005\u0002\u001ag%\u0011AG\u0007\u0002\r\u0005\u0006\u001cXMU3mCRLwN\u001c\u0005\u0006m\t\u0001\raN\u0001\u000bgFd7i\u001c8uKb$\bC\u0001\u001d:\u001b\u0005a\u0012B\u0001\u001e\u001d\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0015\u0003kq\u0002\"aE\u001f\n\u0005y\"\"!\u0003;sC:\u001c\u0018.\u001a8u\u0011\u0015\u0001%\u00011\u0001B\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0005&cEJ\u0004\u0002D\u000fB\u0011A\tF\u0007\u0002\u000b*\u0011a\tL\u0001\u0007yI|w\u000e\u001e \n\u0005!#\u0012A\u0002)sK\u0012,g-\u0003\u0002K\u0017\n\u0019Q*\u00199\u000b\u0005!#\u0002C\u0001\"N\u0013\tq5J\u0001\u0004TiJLgn\u001a\u000b\u0005eA\u00136\u000bC\u00037\u0007\u0001\u0007q\u0007\u000b\u0002Qy!)\u0001i\u0001a\u0001\u0003\")Ak\u0001a\u0001+\u000611o\u00195f[\u0006\u0004\"AV-\u000e\u0003]S!\u0001\u0017\u000f\u0002\u000bQL\b/Z:\n\u0005i;&AC*ueV\u001cG\u000fV=qKR)!\u0007\u00180dI\")a\u0007\u0002a\u0001o!\u0012A\f\u0010\u0005\u0006?\u0012\u0001\r\u0001Y\u0001\u0005[>$W\r\u0005\u00029C&\u0011!\r\b\u0002\t'\u00064X-T8eK\")\u0001\t\u0002a\u0001\u0003\")Q\r\u0002a\u0001M\u0006!A-\u0019;b!\t9'O\u0004\u0002ia:\u0011\u0011n\u001c\b\u0003U:t!a[7\u000f\u0005\u0011c\u0017\"\u0001\t\n\u0005}y\u0011B\u0001\u0007\u001f\u0013\tQQ$\u0003\u0002r9\u00059\u0001/Y2lC\u001e,\u0017BA:u\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0002r9\u0005Q1M]3bi\u0016\u001c\u0016N\\6\u0015\u0011]|\u0018\u0011AA\u0002\u0003/\u0001\"\u0001_?\u000e\u0003eT!A_>\u0002\u0013M$(/Z1nS:<'B\u0001?\u001d\u0003%)\u00070Z2vi&|g.\u0003\u0002\u007fs\n!1+\u001b8l\u0011\u00151T\u00011\u00018\u0011\u0015\u0001U\u00011\u0001B\u0011\u001d\t)!\u0002a\u0001\u0003\u000f\t\u0001\u0003]1si&$\u0018n\u001c8D_2,XN\\:\u0011\u000b\u0005%\u0011\u0011\u0003'\u000f\t\u0005-\u0011q\u0002\b\u0004\t\u00065\u0011\"A\u000b\n\u0005E$\u0012\u0002BA\n\u0003+\u00111aU3r\u0015\t\tH\u0003C\u0004\u0002\u001a\u0015\u0001\r!a\u0007\u0002\u0015=,H\u000f];u\u001b>$W\r\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\tQH$\u0003\u0003\u0002$\u0005}!AC(viB,H/T8eK\u00061\u0001/\u0019:b[N$B!!\u000b\u0002FA9\u00111FA\u001b\u0003oaUBAA\u0017\u0015\u0011\ty#!\r\u0002\u0013%lW.\u001e;bE2,'bAA\u001a)\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0007)\u000bi\u0003\u0005\u0003\u0002:\u0005\rSBAA\u001e\u0015\u0011\ti$a\u0010\u0002\t1\fgn\u001a\u0006\u0003\u0003\u0003\nAA[1wC&\u0019a*a\u000f\t\u000b\u00013\u0001\u0019A!\u0002\u0019M$(/Z1n!\u0006\u0014\u0018-\\:\u0015\r\u0005%\u00121JA'\u0011\u0015\u0001u\u00011\u0001B\u0011\u001d\tye\u0002a\u0001\u0003#\nAb\u001d9be.\u001cVm]:j_:\u00042\u0001OA*\u0013\r\t)\u0006\b\u0002\r'B\f'o[*fgNLwN\u001c")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider,
StreamSinkProvider {
    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters) {
        return new ElasticsearchRelation(this.params(parameters), sqlContext, ElasticsearchRelation$.MODULE$.apply$default$3());
    }

    public BaseRelation createRelation(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, StructType schema) {
        return new ElasticsearchRelation(this.params(parameters), sqlContext, (Option<StructType>)new Some((Object)schema));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, scala.collection.immutable.Map<String, String> parameters, Dataset<Row> data) {
        ElasticsearchRelation relation = new ElasticsearchRelation(this.params(parameters), sqlContext, (Option<StructType>)new Some((Object)data.schema()));
        SaveMode saveMode = mode;
        if (SaveMode.Append.equals(saveMode)) {
            relation.insert(data, false);
            return relation;
        } else if (SaveMode.Overwrite.equals(saveMode)) {
            relation.insert(data, true);
            return relation;
        } else if (SaveMode.ErrorIfExists.equals(saveMode)) {
            if (!relation.isEmpty()) throw new EsHadoopIllegalStateException(new StringBuilder(100).append("SaveMode is set to ErrorIfExists and ").append("index ").append(relation.cfg().getResourceWrite()).append(" exists and contains data. Consider changing the SaveMode").toString());
            relation.insert(data, false);
            return relation;
        } else {
            if (!SaveMode.Ignore.equals(saveMode)) throw new MatchError((Object)saveMode);
            if (!relation.isEmpty()) return relation;
            relation.insert(data, false);
        }
        return relation;
    }

    public Sink createSink(SQLContext sqlContext, scala.collection.immutable.Map<String, String> parameters, Seq<String> partitionColumns, OutputMode outputMode) {
        SparkSession sparkSession = sqlContext.sparkSession();
        StructuredStreamingVersionLock$.MODULE$.checkCompatibility(sparkSession);
        Seq<String> seq = partitionColumns;
        Nil$ nil$ = Nil$.MODULE$;
        if (seq == null ? nil$ != null : !seq.equals((Object)nil$)) {
            throw new EsHadoopIllegalArgumentException("Partition columns are not supported for Elasticsearch. If you need to partition your data by column values on Elasticsearch, please use an index pattern instead.");
        }
        scala.collection.mutable.Map mapConfig = (scala.collection.mutable.Map)((Growable)Map$.MODULE$.apply(parameters.toSeq())).$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.internal.transport.pooling.key"), (Object)UUID.randomUUID().toString()));
        Settings jobSettings = new SparkSettingsManager().load(sqlContext.sparkContext().getConf()).merge((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.streamParams((scala.collection.immutable.Map<String, String>)mapConfig.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), sparkSession)).asJava());
        OutputMode outputMode2 = outputMode;
        OutputMode outputMode3 = OutputMode.Update();
        if (!(outputMode2 != null ? !outputMode2.equals(outputMode3) : outputMode3 != null)) {
            String writeOperation = jobSettings.getProperty("es.write.operation");
            if (writeOperation == null) {
                jobSettings.setProperty("es.write.operation", "upsert");
            } else {
                String string = writeOperation;
                String string2 = "upsert";
                if (string == null ? string2 != null : !string.equals(string2)) {
                    throw new EsHadoopIllegalArgumentException("Output mode update is only supported if es.write.operation is unset or set to upsert");
                }
            }
        } else {
            OutputMode outputMode4 = outputMode;
            OutputMode outputMode5 = OutputMode.Append();
            if (outputMode4 == null ? outputMode5 != null : !outputMode4.equals(outputMode5)) {
                throw new EsHadoopIllegalArgumentException(new StringBuilder(96).append("Append and update are the only supported OutputModes for Elasticsearch. ").append("Cannot continue with [").append(outputMode).append("].").toString());
            }
        }
        InitializationUtils.setUserProviderIfNotSet(jobSettings, HadoopUserProvider.class, LogFactory.getLog(DefaultSource.class));
        InitializationUtils.discoverClusterInfo(jobSettings, LogFactory.getLog(DefaultSource.class));
        InitializationUtils.checkIdForOperation(jobSettings);
        InitializationUtils.checkIndexExistence(jobSettings);
        return new EsSparkSqlStreamingSink(sparkSession, jobSettings);
    }

    public scala.collection.immutable.Map<String, String> params(scala.collection.immutable.Map<String, String> parameters) {
        scala.collection.immutable.Map map;
        scala.collection.immutable.Map dottedParams = (scala.collection.immutable.Map)parameters.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.replace('_', '.'), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        Option preferredResource = dottedParams.get((Object)"es.resource").orElse((Function0 & Serializable)() -> dottedParams.get((Object)"resource")).orElse((Function0 & Serializable)() -> dottedParams.get((Object)"path"));
        scala.collection.immutable.Map processedParams = (scala.collection.immutable.Map)dottedParams.map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k.startsWith("es.")) {
                    return new Tuple2((Object)k, (Object)v);
                }
                String string = k;
                String string2 = "path";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return new Tuple2((Object)"es.resource", (Object)v);
                }
                String string3 = k;
                String string4 = "pushdown";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return new Tuple2((Object)"es.internal.spark.sql.pushdown", (Object)v);
                }
                String string5 = k;
                String string6 = "strict";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return new Tuple2((Object)"es.internal.spark.sql.pushdown.strict", (Object)v);
                }
                String string7 = k;
                String string8 = "double.filtering";
                if (!(string7 != null ? !string7.equals(string8) : string8 != null)) {
                    return new Tuple2((Object)"es.internal.spark.sql.pushdown.keep.handled.filters", (Object)v);
                }
                return new Tuple2((Object)new StringBuilder(3).append("es.").append(k).toString(), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        });
        Option option = preferredResource;
        if (option instanceof Some) {
            Some some = (Some)option;
            String resource = (String)some.value();
            map = (scala.collection.immutable.Map)processedParams.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"es.resource"), (Object)resource));
        } else if (None$.MODULE$.equals(option)) {
            map = processedParams;
        } else {
            throw new MatchError((Object)option);
        }
        scala.collection.immutable.Map finalParams = map;
        finalParams.getOrElse((Object)"es.resource.read", (Function0 & Serializable)() -> (String)finalParams.getOrElse((Object)"es.resource", (Function0 & Serializable)() -> {
            throw new EsHadoopIllegalArgumentException("resource must be specified for Elasticsearch resources.");
        }));
        return finalParams;
    }

    private scala.collection.immutable.Map<String, String> streamParams(scala.collection.immutable.Map<String, String> parameters, SparkSession sparkSession) {
        ObjectRef params = ObjectRef.create((Object)((scala.collection.immutable.Map)((MapOps)parameters.map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k.replace('_', '.'), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (k.startsWith("es.")) {
                    return new Tuple2((Object)k, (Object)v);
                }
                String string = k;
                String string2 = "path";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return new Tuple2((Object)"es.resource", (Object)v);
                }
                String string3 = k;
                String string4 = "queryname";
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    return new Tuple2((Object)SparkSqlStreamingConfigs$.MODULE$.ES_INTERNAL_QUERY_NAME(), (Object)v);
                }
                String string5 = k;
                String string6 = "checkpointlocation";
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    return new Tuple2((Object)SparkSqlStreamingConfigs$.MODULE$.ES_INTERNAL_USER_CHECKPOINT_LOCATION(), (Object)v);
                }
                return new Tuple2((Object)new StringBuilder(3).append("es.").append(k).toString(), (Object)v);
            }
            throw new MatchError((Object)tuple2);
        })));
        params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.ES_INTERNAL_APP_NAME()), (Object)sparkSession.sparkContext().appName()));
        params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.ES_INTERNAL_APP_ID()), (Object)sparkSession.sparkContext().applicationId()));
        sparkSession.conf().getOption(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).foreach((Function1 & Serializable)loc -> {
            params.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)params.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)SparkSqlStreamingConfigs$.MODULE$.ES_INTERNAL_SESSION_CHECKPOINT_LOCATION()), (Object)loc));
            return BoxedUnit.UNIT;
        });
        ((scala.collection.immutable.Map)params.elem).getOrElse((Object)"es.resource.write", (Function0 & Serializable)() -> (String)((scala.collection.immutable.Map)params$1.elem).getOrElse((Object)"es.resource", (Function0 & Serializable)() -> {
            throw new EsHadoopIllegalArgumentException("resource must be specified for Elasticsearch resources.");
        }));
        return (scala.collection.immutable.Map)params.elem;
    }

    public DefaultSource() {
        Version.logVersion();
    }
}

