/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.security;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum AuthenticationMethod {
    SIMPLE("simple"),
    BASIC("basic"),
    PKI("pki"),
    KERBEROS("kerberos");

    private static final Map<String, AuthenticationMethod> REGISTRY;
    private final String value;

    public static AuthenticationMethod get(String value) {
        return REGISTRY.get(value);
    }

    public static List<String> getAvailableMethods() {
        return Arrays.asList(AuthenticationMethod.SIMPLE.value, AuthenticationMethod.BASIC.value, AuthenticationMethod.PKI.value, AuthenticationMethod.KERBEROS.value);
    }

    private AuthenticationMethod(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    static {
        REGISTRY = new HashMap<String, AuthenticationMethod>(4);
        REGISTRY.put(AuthenticationMethod.SIMPLE.value, SIMPLE);
        REGISTRY.put(AuthenticationMethod.BASIC.value, BASIC);
        REGISTRY.put(AuthenticationMethod.PKI.value, PKI);
        REGISTRY.put(AuthenticationMethod.KERBEROS.value, KERBEROS);
    }
}

