/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.List;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;

public class ChainedFieldExtractor
implements FieldExtractor {
    private final List<FieldExtractor> chain;
    private final NoValueHandler notFoundResponse;

    public ChainedFieldExtractor(List<FieldExtractor> chain) {
        this(chain, NoValueHandler.NOT_FOUND);
    }

    public ChainedFieldExtractor(List<FieldExtractor> chain, NoValueHandler notFoundResponse) {
        this.chain = chain;
        this.notFoundResponse = notFoundResponse;
    }

    @Override
    public Object field(Object target) {
        if (this.chain.isEmpty()) {
            return this.notFoundResponse.returnValue;
        }
        for (FieldExtractor fieldExtractor : this.chain) {
            Object extracted;
            if (fieldExtractor == null || (extracted = fieldExtractor.field(target)) == NOT_FOUND) continue;
            return extracted;
        }
        return this.notFoundResponse.returnValue;
    }

    public static enum NoValueHandler {
        NOT_FOUND(FieldExtractor.NOT_FOUND),
        SKIP(FieldExtractor.SKIP);

        private Object returnValue;

        private NoValueHandler(Object returnValue) {
            this.returnValue = returnValue;
        }
    }
}

