/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.rest.commonshttp.auth.bearer;

import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.thirdparty.apache.commons.httpclient.Credentials;
import org.elasticsearch.hadoop.util.Assert;

public class EsApiKeyCredentials
implements Credentials {
    private final UserProvider userProvider;
    private final EsToken providedToken;
    private final String clusterName;

    public EsApiKeyCredentials(UserProvider userProvider, String clusterName) {
        Assert.notNull(userProvider, "userProvider must not be null");
        Assert.notNull(clusterName, "clusterName must not be null");
        this.userProvider = userProvider;
        this.providedToken = null;
        this.clusterName = clusterName;
    }

    public EsApiKeyCredentials(EsToken providedToken) {
        Assert.notNull(providedToken, "providedToken must not be null");
        this.userProvider = null;
        this.providedToken = providedToken;
        this.clusterName = null;
    }

    public EsToken getToken() {
        EsToken esToken = null;
        if (this.providedToken != null) {
            esToken = this.providedToken;
        } else {
            User user = this.userProvider.getUser();
            if (user != null) {
                esToken = user.getEsToken(this.clusterName);
            }
        }
        return esToken;
    }
}

