/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import java.io.Serializable;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.TaskContext;
import org.apache.spark.util.TaskCompletionListener;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestService;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.hadoop.serialization.BytesConverter;
import org.elasticsearch.hadoop.serialization.JdkBytesConverter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.spark.rdd.EsRDDWriter$;
import org.elasticsearch.spark.serialization.ScalaMapFieldExtractor;
import org.elasticsearch.spark.serialization.ScalaMetadataExtractor;
import org.elasticsearch.spark.serialization.ScalaValueWriter;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005mh!\u0002\f\u0018\u0001ey\u0002\u0002\u0003\u001b\u0001\u0005\u000b\u0007I\u0011A\u001b\t\u0011y\u0002!\u0011!Q\u0001\nYB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\t\u0001B\u0002B\u0003-a\tC\u0003X\u0001\u0011\u0005\u0001\f\u0003\u0005`\u0001!\u0015\r\u0011\"\u0005a\u0011!y\u0007\u0001#b\u0001\n\u0003\u0001\b\u0002C=\u0001\u0011\u000b\u0007I\u0011\u0001>\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n!9\u0011\u0011\u0006\u0001\u0005\u0012\u0005-\u0002bBA*\u0001\u0011E\u0011Q\u000b\u0005\b\u0003W\u0002A\u0011CA7\u0011\u001d\t9\t\u0001C\t\u0003\u0013Cq!a&\u0001\t#\tI\nC\u0004\u00024\u0002!\t\"!.\b\u0015\u0005ev#!A\t\u0002e\tYLB\u0005\u0017/\u0005\u0005\t\u0012A\r\u0002>\"1qK\u0005C\u0001\u0003\u001bD\u0011\"a4\u0013#\u0003%\t!!5\t\u0013\u0005-(#!A\u0005\n\u00055(aC#t%\u0012#uK]5uKJT!\u0001G\r\u0002\u0007I$GM\u0003\u0002\u001b7\u0005)1\u000f]1sW*\u0011A$H\u0001\u000eK2\f7\u000f^5dg\u0016\f'o\u00195\u000b\u0003y\t1a\u001c:h+\t\u0001cjE\u0002\u0001C\u001d\u0002\"AI\u0013\u000e\u0003\rR\u0011\u0001J\u0001\u0006g\u000e\fG.Y\u0005\u0003M\r\u0012a!\u00118z%\u00164\u0007C\u0001\u00152\u001d\tIsF\u0004\u0002+]5\t1F\u0003\u0002-[\u00051AH]8piz\u001a\u0001!C\u0001%\u0013\t\u00014%A\u0004qC\u000e\\\u0017mZ3\n\u0005I\u001a$\u0001D*fe&\fG.\u001b>bE2,'B\u0001\u0019$\u0003I\u0019XM]5bY&TX\rZ*fiRLgnZ:\u0016\u0003Y\u0002\"aN\u001e\u000f\u0005aJ\u0004C\u0001\u0016$\u0013\tQ4%\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e$\u0003M\u0019XM]5bY&TX\rZ*fiRLgnZ:!\u0003=\u0011XO\u001c;j[\u0016lU\r^1eCR\fW#A!\u0011\u0005\t\u0012\u0015BA\"$\u0005\u001d\u0011un\u001c7fC:\f\u0001C];oi&lW-T3uC\u0012\fG/\u0019\u0011\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002H\u00152k\u0011\u0001\u0013\u0006\u0003\u0013\u000e\nqA]3gY\u0016\u001cG/\u0003\u0002L\u0011\nA1\t\\1tgR\u000bw\r\u0005\u0002N\u001d2\u0001A!B(\u0001\u0005\u0004\u0001&!\u0001+\u0012\u0005E#\u0006C\u0001\u0012S\u0013\t\u00196EA\u0004O_RD\u0017N\\4\u0011\u0005\t*\u0016B\u0001,$\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007ekf\f\u0006\u0002[9B\u00191\f\u0001'\u000e\u0003]AQ!\u0012\u0004A\u0004\u0019CQ\u0001\u000e\u0004A\u0002YBqa\u0010\u0004\u0011\u0002\u0003\u0007\u0011)A\u0002m_\u001e,\u0012!\u0019\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\fq\u0001\\8hO&twM\u0003\u0002gO\u000691m\\7n_:\u001c(B\u00015\u001e\u0003\u0019\t\u0007/Y2iK&\u0011!n\u0019\u0002\u0004\u0019><\u0007FA\u0004m!\t\u0011S.\u0003\u0002oG\tIAO]1og&,g\u000e^\u0001\tg\u0016$H/\u001b8hgV\t\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006\u00191MZ4\u000b\u0005Y\\\u0012A\u00025bI>|\u0007/\u0003\u0002yg\nA1+\u001a;uS:<7/A\u0007nKR\fW\t\u001f;sC\u000e$xN]\u000b\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\t\t,Hn\u001b\u0006\u0004\u0003\u0003)\u0018!D:fe&\fG.\u001b>bi&|g.C\u0002\u0002\u0006u\u0014\u0011#T3uC\u0012\fG/Y#yiJ\f7\r^8s\u0003\u00159(/\u001b;f)\u0019\tY!!\u0005\u0002 A\u0019!%!\u0004\n\u0007\u0005=1E\u0001\u0003V]&$\bbBA\n\u0015\u0001\u0007\u0011QC\u0001\fi\u0006\u001c8nQ8oi\u0016DH\u000f\u0005\u0003\u0002\u0018\u0005mQBAA\r\u0015\tQr-\u0003\u0003\u0002\u001e\u0005e!a\u0003+bg.\u001cuN\u001c;fqRDq!!\t\u000b\u0001\u0004\t\u0019#\u0001\u0003eCR\f\u0007\u0003\u0002\u0015\u0002&1K1!a\n4\u0005!IE/\u001a:bi>\u0014\u0018a\u0003<bYV,wK]5uKJ,\"!!\f1\t\u0005=\u0012q\u0007\t\u0006o\u0005E\u0012QG\u0005\u0004\u0003gi$!B\"mCN\u001c\bcA'\u00028\u0011Y\u0011\u0011H\u0006\u0002\u0002\u0003\u0005)\u0011AA\u001e\u0005\ryF%M\t\u0004#\u0006u\u0002\u0007BA \u0003\u001b\u0002b!!\u0011\u0002H\u0005-SBAA\"\u0015\r\t)e`\u0001\bEVLG\u000eZ3s\u0013\u0011\tI%a\u0011\u0003\u0017Y\u000bG.^3Xe&$XM\u001d\t\u0004\u001b\u00065CaCA(\u0003#\n\t\u0011!A\u0003\u0002A\u00131a\u0018\u00133\t-\tIdCA\u0001\u0004\u0003\u0015\t!a\u000f\u0002\u001d\tLH/Z:D_:4XM\u001d;feV\u0011\u0011q\u000b\u0019\u0005\u00033\ni\u0006E\u00038\u0003c\tY\u0006E\u0002N\u0003;\"1\"a\u0018\r\u0003\u0003\u0005\tQ!\u0001\u0002b\t\u0019q\fJ\u001a\u0012\u0007E\u000b\u0019\u0007\u0005\u0003\u0002f\u0005\u001dT\"A@\n\u0007\u0005%tP\u0001\bCsR,7oQ8om\u0016\u0014H/\u001a:\u0002\u001d\u0019LW\r\u001c3FqR\u0014\u0018m\u0019;peV\u0011\u0011q\u000e\u0019\u0005\u0003c\n)\bE\u00038\u0003c\t\u0019\bE\u0002N\u0003k\"1\"a\u001e\u000e\u0003\u0003\u0005\tQ!\u0001\u0002z\t\u0019q\f\n\u001b\u0012\u0007E\u000bY\b\u0005\u0003\u0002~\u0005\rUBAA@\u0015\r\t\ti`\u0001\u0006M&,G\u000eZ\u0005\u0005\u0003\u000b\u000byH\u0001\bGS\u0016dG-\u0012=ue\u0006\u001cGo\u001c:\u0002#5,G/\u00193bi\u0006,\u0005\u0010\u001e:bGR|'/\u0006\u0002\u0002\fB\"\u0011QRAI!\u00159\u0014\u0011GAH!\ri\u0015\u0011\u0013\u0003\f\u0003's\u0011\u0011!A\u0001\u0006\u0003\t)JA\u0002`IU\n\"!U>\u0002\u0019U\u001cXM\u001d)s_ZLG-\u001a:\u0016\u0005\u0005m\u0005\u0007BAO\u0003C\u0003RaNA\u0019\u0003?\u00032!TAQ\t-\t\u0019kDA\u0001\u0002\u0003\u0015\t!!*\u0003\u0007}#c'E\u0002R\u0003O\u0003B!!+\u000206\u0011\u00111\u0016\u0006\u0004\u0003[+\u0018\u0001C:fGV\u0014\u0018\u000e^=\n\t\u0005E\u00161\u0016\u0002\r+N,'\u000f\u0015:pm&$WM]\u0001\faJ|7-Z:t\t\u0006$\u0018\rF\u0002U\u0003oCq!!\t\u0011\u0001\u0004\t\u0019#A\u0006FgJ#Ei\u0016:ji\u0016\u0014\bCA.\u0013'\u0011\u0011\u0012%a0\u0011\t\u0005\u0005\u00171Z\u0007\u0003\u0003\u0007TA!!2\u0002H\u0006\u0011\u0011n\u001c\u0006\u0003\u0003\u0013\fAA[1wC&\u0019!'a1\u0015\u0005\u0005m\u0016a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$#'\u0006\u0003\u0002T\u0006%XCAAkU\r\t\u0015q[\u0016\u0003\u00033\u0004B!a7\u0002f6\u0011\u0011Q\u001c\u0006\u0005\u0003?\f\t/A\u0005v]\u000eDWmY6fI*\u0019\u00111]\u0012\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002h\u0006u'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0012)q\n\u0006b\u0001!\u0006aqO]5uKJ+\u0007\u000f\\1dKR\u0011\u0011q\u001e\t\u0005\u0003c\f90\u0004\u0002\u0002t*!\u0011Q_Ad\u0003\u0011a\u0017M\\4\n\t\u0005e\u00181\u001f\u0002\u0007\u001f\nTWm\u0019;")
public class EsRDDWriter<T>
implements Serializable {
    private transient Log log;
    private Settings settings;
    private MetadataExtractor metaExtractor;
    private final String serializedSettings;
    private final boolean runtimeMetadata;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static <T> boolean $lessinit$greater$default$2() {
        return EsRDDWriter$.MODULE$.$lessinit$greater$default$2();
    }

    public String serializedSettings() {
        return this.serializedSettings;
    }

    public boolean runtimeMetadata() {
        return this.runtimeMetadata;
    }

    private Log log$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if (!this.bitmap$trans$0) {
                this.log = LogFactory.getLog(this.getClass());
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    public Log log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    /*
     * WARNING - void declaration
     */
    private Settings settings$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                Settings settings = new PropertiesSettings().load(this.serializedSettings());
                InitializationUtils.setValueWriterIfNotSet(settings, this.valueWriter(), this.log());
                InitializationUtils.setBytesConverterIfNeeded(settings, this.bytesConverter(), this.log());
                InitializationUtils.setFieldExtractorIfNotSet(settings, this.fieldExtractor(), this.log());
                InitializationUtils.setMetadataExtractorIfNotSet(settings, this.metadataExtractor(), this.log());
                InitializationUtils.setUserProviderIfNotSet(settings, this.userProvider(), this.log());
                this.settings = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.settings;
    }

    public Settings settings() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.settings$lzycompute();
        }
        return this.settings;
    }

    private MetadataExtractor metaExtractor$lzycompute() {
        EsRDDWriter esRDDWriter = this;
        synchronized (esRDDWriter) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.metaExtractor = (MetadataExtractor)ObjectUtils.instantiate(this.settings().getMappingMetadataExtractorClassName(), this.settings());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.metaExtractor;
    }

    public MetadataExtractor metaExtractor() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.metaExtractor$lzycompute();
        }
        return this.metaExtractor;
    }

    public void write(TaskContext taskContext, Iterator<T> data) {
        Object object = this.settings().getOpaqueId() != null && !this.settings().getOpaqueId().contains("] [task attempt ") ? this.settings().setOpaqueId(String.format(Locale.ROOT, "%s [stage %s] [task attempt %s]", this.settings().getOpaqueId(), Integer.toString(taskContext.stageId()), Long.toString(taskContext.taskAttemptId()))) : BoxedUnit.UNIT;
        RestService.PartitionWriter writer = RestService.createWriter(this.settings(), taskContext.partitionId(), -1, this.log());
        TaskCompletionListener listener = new TaskCompletionListener(null, writer){
            private final RestService.PartitionWriter writer$1;

            public void onTaskCompletion(TaskContext context) {
                this.writer$1.close();
            }
            {
                this.writer$1 = writer$1;
            }
        };
        taskContext.addTaskCompletionListener(listener);
        if (this.runtimeMetadata()) {
            writer.repository.addRuntimeFieldExtractor(this.metaExtractor());
        }
        while (data.hasNext()) {
            writer.repository.writeToIndex(this.processData(data));
        }
    }

    public Class<? extends ValueWriter<?>> valueWriter() {
        return ScalaValueWriter.class;
    }

    public Class<? extends BytesConverter> bytesConverter() {
        return JdkBytesConverter.class;
    }

    public Class<? extends FieldExtractor> fieldExtractor() {
        return ScalaMapFieldExtractor.class;
    }

    public Class<? extends MetadataExtractor> metadataExtractor() {
        return ScalaMetadataExtractor.class;
    }

    public Class<? extends UserProvider> userProvider() {
        return HadoopUserProvider.class;
    }

    public Object processData(Iterator<T> data) {
        Object next = data.next();
        if (this.runtimeMetadata()) {
            Object object = next;
            if (!(object instanceof Tuple2)) {
                throw new MatchError(object);
            }
            Tuple2 tuple2 = (Tuple2)object;
            Object key = tuple2._1();
            Object value = tuple2._2();
            Tuple2 tuple22 = new Tuple2(key, value);
            Object key2 = tuple22._1();
            Object value2 = tuple22._2();
            this.metaExtractor().setObject(key2);
            return value2;
        }
        return next;
    }

    public EsRDDWriter(String serializedSettings, boolean runtimeMetadata, ClassTag<T> evidence$1) {
        this.serializedSettings = serializedSettings;
        this.runtimeMetadata = runtimeMetadata;
    }
}

