/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.instrument.metrics.timer;

import co.elastic.logstash.api.TimerMetric;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.LongSupplier;
import org.logstash.instrument.metrics.AbstractMetric;
import org.logstash.instrument.metrics.timer.TimerMetric;
import org.logstash.instrument.metrics.timer.Util;

public class ConcurrentLiveTimerMetric
extends AbstractMetric<Long>
implements TimerMetric {
    private final LongAdder untrackedMillis = new LongAdder();
    private final AtomicReference<TrackedMillisState> trackedMillisState;
    private final LongSupplier nanoTimeSupplier;

    protected ConcurrentLiveTimerMetric(String name) {
        this(name, System::nanoTime);
    }

    ConcurrentLiveTimerMetric(String name, LongSupplier nanoTimeSupplier) {
        super(name);
        this.nanoTimeSupplier = Objects.requireNonNullElse(nanoTimeSupplier, System::nanoTime);
        this.trackedMillisState = new AtomicReference<StaticTrackedMillisState>(new StaticTrackedMillisState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Throwable> T time(TimerMetric.ExceptionalSupplier<T, E> exceptionalSupplier) throws E {
        try {
            this.trackedMillisState.getAndUpdate(existing -> existing.withIncrementedConcurrency(this.nanoTimeSupplier.getAsLong()));
            T t = exceptionalSupplier.get();
            return t;
        }
        finally {
            long endTime = this.nanoTimeSupplier.getAsLong();
            this.trackedMillisState.getAndUpdate(existing -> existing.withDecrementedConcurrency(endTime));
        }
    }

    @Override
    public void reportUntrackedMillis(long untrackedMillis) {
        this.untrackedMillis.add(untrackedMillis);
    }

    @Override
    public Long getValue() {
        return Math.addExact(this.getUntrackedMillis(), this.getTrackedMillis());
    }

    private long getUntrackedMillis() {
        return this.untrackedMillis.longValue();
    }

    private long getTrackedMillis() {
        return this.trackedMillisState.getAcquire().getValue(this.nanoTimeSupplier.getAsLong());
    }

    private class StaticTrackedMillisState
    implements TrackedMillisState {
        private final long cumulativeMillis;
        private final int excessNanos;

        StaticTrackedMillisState(long cumulativeMillis, int excessNanos) {
            this.cumulativeMillis = cumulativeMillis;
            this.excessNanos = excessNanos;
        }

        public StaticTrackedMillisState() {
            this(0L, 0);
        }

        @Override
        public TrackedMillisState withIncrementedConcurrency(long asOfNanoTime) {
            return new DynamicTrackedMillisState(asOfNanoTime, this.cumulativeMillis, this.excessNanos, 1);
        }

        @Override
        public TrackedMillisState withDecrementedConcurrency(long asOfNanoTime) {
            throw new IllegalStateException("TimerMetrics cannot track negative concurrency");
        }

        @Override
        public long getValue(long asOfNanoTime) {
            return this.cumulativeMillis;
        }
    }

    static interface TrackedMillisState {
        public TrackedMillisState withIncrementedConcurrency(long var1);

        public TrackedMillisState withDecrementedConcurrency(long var1);

        public long getValue(long var1);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum Vector {
        INCREMENT{

            @Override
            int value() {
                return 1;
            }
        }
        ,
        DECREMENT{

            @Override
            int value() {
                return -1;
            }
        };


        abstract int value();
    }

    private class DynamicTrackedMillisState
    implements TrackedMillisState {
        private final long checkpointNanoTime;
        private final long millisAtCheckpoint;
        private final int excessNanosAtCheckpoint;
        private final int concurrencySinceCheckpoint;

        DynamicTrackedMillisState(long checkpointNanoTime, long millisAtCheckpoint, int excessNanosAtCheckpoint, int concurrencySinceCheckpoint) {
            this.checkpointNanoTime = checkpointNanoTime;
            this.millisAtCheckpoint = millisAtCheckpoint;
            this.excessNanosAtCheckpoint = excessNanosAtCheckpoint;
            this.concurrencySinceCheckpoint = concurrencySinceCheckpoint;
        }

        @Override
        public TrackedMillisState withIncrementedConcurrency(long asOfNanoTime) {
            return this.withAdjustedConcurrency(asOfNanoTime, Vector.INCREMENT);
        }

        @Override
        public TrackedMillisState withDecrementedConcurrency(long asOfNanoTime) {
            return this.withAdjustedConcurrency(asOfNanoTime, Vector.DECREMENT);
        }

        @Override
        public long getValue(long asOfNanoTime) {
            long nanoAdjustment = this.getNanoAdjustment(asOfNanoTime);
            long milliAdjustment = Util.wholeMillisFromNanos(nanoAdjustment);
            return Math.addExact(this.millisAtCheckpoint, milliAdjustment);
        }

        private TrackedMillisState withAdjustedConcurrency(long asOfNanoTime, Vector concurrencyAdjustmentVector) {
            int newConcurrency = Math.addExact(this.concurrencySinceCheckpoint, concurrencyAdjustmentVector.value());
            long newCheckpointNanoTime = asOfNanoTime;
            long totalNanoAdjustment = this.getNanoAdjustment(newCheckpointNanoTime);
            long newCheckpointMillis = Math.addExact(this.millisAtCheckpoint, Util.wholeMillisFromNanos(totalNanoAdjustment));
            int newCheckpointExcessNanos = Util.subMilliExcessNanos(totalNanoAdjustment);
            if (newConcurrency <= 0) {
                return new StaticTrackedMillisState(newCheckpointMillis, newCheckpointExcessNanos);
            }
            return new DynamicTrackedMillisState(newCheckpointNanoTime, newCheckpointMillis, newCheckpointExcessNanos, newConcurrency);
        }

        private long getNanoAdjustment(long checkpointNanoTime) {
            long deltaNanoTime = Math.subtractExact(checkpointNanoTime, this.checkpointNanoTime);
            long calculatedNanoAdjustment = Math.multiplyExact(deltaNanoTime, this.concurrencySinceCheckpoint);
            return Math.addExact(calculatedNanoAdjustment, (long)this.excessNanosAtCheckpoint);
        }
    }
}

