"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImportDataModalComponent = exports.ImportDataModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_app_toasts = require("../../hooks/use_app_toasts");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/import_data_modal/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ImportDataModalComponent = ({
  isModalVisible,
  closeModal,
  title,
  filePickerPrompt,
  description,
  submitBtnText,
  errorMessage,
  importData,
  onImportComplete,
  children
}) => {
  const [selectedFiles, setSelectedFiles] = (0, _react.useState)(null);
  const [isImporting, setIsImporting] = (0, _react.useState)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const descriptionElementId = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const cleanupAndCloseModal = (0, _react.useCallback)(() => {
    closeModal();
    setIsImporting(false);
    setSelectedFiles(null);
  }, [closeModal]);
  const importDataCallback = (0, _react.useCallback)(async () => {
    if (selectedFiles != null) {
      setIsImporting(true);
      const abortCtrl = new AbortController();
      try {
        const importResponse = await importData({
          fileToImport: selectedFiles[0],
          signal: abortCtrl.signal
        });
        setIsImporting(false);
        setSelectedFiles(null);
        onImportComplete(importResponse);
      } catch (error) {
        cleanupAndCloseModal();
        addError(error, {
          title: errorMessage(1)
        });
      }
    }
  }, [selectedFiles, importData, errorMessage, addError, onImportComplete, cleanupAndCloseModal]);
  const handleFilePickerChange = (0, _react.useCallback)(files => {
    setSelectedFiles(files && files.length > 0 ? files : null);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: cleanupAndCloseModal,
    maxWidth: '750px',
    "aria-labelledby": modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: modalTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 13
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    id: descriptionElementId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    "data-test-subj": "rule-file-picker",
    accept: ".ndjson",
    id: "rule-file-picker",
    initialPromptText: filePickerPrompt,
    onChange: handleFilePickerChange,
    display: 'large',
    fullWidth: true,
    isLoading: isImporting,
    "aria-labelledby": descriptionElementId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }), children), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: cleanupAndCloseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, i18n.CANCEL_BUTTON), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "import-data-modal-button",
    onClick: importDataCallback,
    disabled: selectedFiles == null || isImporting,
    fill: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 13
    }
  }, submitBtnText))));
};
exports.ImportDataModalComponent = ImportDataModalComponent;
ImportDataModalComponent.displayName = 'ImportDataModalComponent';
const ImportDataModal = exports.ImportDataModal = /*#__PURE__*/_react.default.memo(ImportDataModalComponent);
ImportDataModal.displayName = 'ImportDataModal';