"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _types = require("../app/types");
var _kibana = require("../common/lib/kibana");
var _spy_routes = require("../common/utils/route/spy_routes");
var _filters_global = require("../common/components/filters_global");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _use_on_expandable_flyout_close = require("../flyout/shared/hooks/use_on_expandable_flyout_close");
var _security_route_page_wrapper = require("../common/components/security_route_page_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763381060386829078/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/routes.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// This exists only for the type signature cast
const CloudPostureSpyRoute = ({
  pageName,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, (0, _extends2.default)({
  pageName: pageName
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 26,
    columnNumber: 3
  }
}));
const cspSecuritySolutionContext = {
  getFiltersGlobalComponent: () => _filters_global.FiltersGlobal,
  getSpyRouteComponent: () => CloudPostureSpyRoute,
  useExpandableFlyoutApi: _expandableFlyout.useExpandableFlyoutApi,
  useOnExpandableFlyoutClose: _use_on_expandable_flyout_close.useOnExpandableFlyoutClose
};
const CloudSecurityPosture = () => {
  const {
    cloudSecurityPosture
  } = (0, _kibana.useKibana)().services;
  const CloudSecurityPostureRouter = cloudSecurityPosture.getCloudSecurityPostureRouter();
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CloudSecurityPostureRouter, {
    securitySolutionContext: cspSecuritySolutionContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 7
    }
  }));
};
CloudSecurityPosture.displayName = 'CloudSecurityPosture';
const routes = exports.routes = [{
  path: _cloudSecurityPostureCommon.CLOUD_SECURITY_POSTURE_BASE_PATH,
  component: (0, _security_route_page_wrapper.withSecurityRoutePageWrapper)(CloudSecurityPosture, _types.SecurityPageName.cloudSecurityPostureDashboard, {
    omitSpyRoute: true
  })
}];